/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.xemelios.controls.models.OptionModel;
import fr.gouv.finances.cp.xemelios.controls.models.ParamModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;

public class DlgEditParam
extends JDialog {
    public static final String SEPARATOR = " ";
    private ParamModel pm;
    private JScrollPane jScrollPane1;
    private JList lst;
    private JButton pbAdd;
    private JButton pbClose;
    private JButton pbRemove;

    public DlgEditParam(Frame parent, ParamModel pm) {
        super(parent, true);
        this.pm = pm;
        this.initAll();
    }

    public DlgEditParam(Dialog parent, ParamModel pm) {
        super(parent, true);
        this.pm = pm;
        this.initAll();
    }

    private void initAll() {
        this.initComponents();
        this.setLocationRelativeTo(this.getParent());
        if (!this.pm.getSelect().isMultiValued()) {
            Vector<Pair> v = new Vector<Pair>();
            for (OptionModel om : this.pm.getSelect().getOptions()) {
                Pair p = new Pair(om.getValue(), om.getLibelle());
                v.add(p);
            }
            this.lst.setListData(v);
            this.pbAdd.setEnabled(true);
            this.lst.setSelectionMode(0);
            this.lst.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    DlgEditParam.this.pbRemove.setEnabled(DlgEditParam.this.lst.getSelectedIndex() >= 0);
                }
            });
        } else {
            Object oValue = this.pm.getValue();
            HashSet<String> values = new HashSet<String>();
            if (oValue != null && oValue instanceof String) {
                String s = (String)oValue;
                StringTokenizer tokenizer = new StringTokenizer(s, SEPARATOR);
                while (tokenizer.hasMoreTokens()) {
                    values.add(tokenizer.nextToken());
                }
            }
            this.lst.setSelectionMode(2);
            this.lst.setCellRenderer(new MyCellRenderer());
            Vector<String> data = new Vector<String>();
            Vector<Integer> selectedIndices = new Vector<Integer>();
            for (OptionModel om : this.pm.getSelect().getOptions()) {
                String key = om.getValue();
                if (values.contains(key)) {
                    selectedIndices.add(new Integer(data.size()));
                }
                data.add(key);
            }
            this.lst.setListData(data);
            int[] indices = new int[selectedIndices.size()];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = (Integer)selectedIndices.get(i);
            }
            this.lst.setSelectedIndices(indices);
            if (this.pm.getSelect().isEditable()) {
                this.pbAdd.setEnabled(true);
                this.lst.addListSelectionListener(new ListSelectionListener(){

                    public void valueChanged(ListSelectionEvent e) {
                        DlgEditParam.this.pbRemove.setEnabled(DlgEditParam.this.lst.getSelectedIndex() >= 0);
                    }
                });
            }
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.lst = new JList();
        this.pbClose = new JButton();
        this.pbAdd = new JButton();
        this.pbRemove = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(this.pm.getName());
        this.lst.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lst.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.lst);
        this.pbClose.setText("Fermer");
        this.pbClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgEditParam.this.pbCloseActionPerformed(evt);
            }
        });
        this.pbAdd.setText("Ajouter");
        this.pbAdd.setEnabled(false);
        this.pbAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgEditParam.this.pbAddActionPerformed(evt);
            }
        });
        this.pbRemove.setText("Supprimer");
        this.pbRemove.setEnabled(false);
        this.pbRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgEditParam.this.pbRemoveActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 221, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.pbRemove).add((Component)this.pbAdd, -2, 98, -2).add((Component)this.pbClose, -2, 98, -2)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.pbAdd).addPreferredGap(0).add((Component)this.pbRemove).addPreferredGap(0, 195, Short.MAX_VALUE).add((Component)this.pbClose)).add((Component)this.jScrollPane1, -1, 276, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void pbAddActionPerformed(ActionEvent evt) {
        String s = JOptionPane.showInputDialog(this, (Object)"Valeur \u00e0 ajouter :");
        OptionModel om = new OptionModel(s, s);
        try {
            this.pm.getSelect().addChild(om, OptionModel.QN);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (!this.pm.getSelect().isMultiValued()) {
            Vector<Pair> v = new Vector<Pair>();
            for (OptionModel om2 : this.pm.getSelect().getOptions()) {
                Pair p = new Pair(om2.getValue(), om2.getLibelle());
                v.add(p);
            }
            this.lst.setListData(v);
        } else {
            Vector<String> data = new Vector<String>();
            for (OptionModel om2 : this.pm.getSelect().getOptions()) {
                String key = om2.getValue();
                data.add(key);
            }
            this.lst.setListData(data);
        }
    }

    private void pbRemoveActionPerformed(ActionEvent evt) {
        if (this.pm.getSelect().isEditable()) {
            if (!this.pm.getSelect().isMultiValued()) {
                Pair p = (Pair)this.lst.getSelectedValue();
                if (p != null) {
                    int index = this.lst.getSelectedIndex();
                    this.lst.remove(index);
                    this.pm.getSelect().getOptions().remove(index);
                }
            } else {
                Object[] values = this.lst.getSelectedValues();
                Vector<String> v = new Vector<String>();
                for (Object value : values) {
                    v.add((String)value);
                }
                Vector<OptionModel> toDrop = new Vector<OptionModel>();
                for (OptionModel om : this.pm.getSelect().getOptions()) {
                    if (!v.contains(om.getValue())) continue;
                    toDrop.add(om);
                }
                this.pm.getSelect().getOptions().removeAll(toDrop);
                this.pm.setValue("");
                Vector<String> data = new Vector<String>();
                for (OptionModel om : this.pm.getSelect().getOptions()) {
                    String key = om.getValue();
                    data.add(key);
                }
                this.lst.setListData(data);
            }
        }
    }

    private void pbCloseActionPerformed(ActionEvent evt) {
        if (this.pm.getSelect().isMultiValued()) {
            int[] indices;
            StringBuffer sb = new StringBuffer();
            for (int i : indices = this.lst.getSelectedIndices()) {
                String s = this.lst.getModel().getElementAt(i).toString();
                sb.append(s).append(SEPARATOR);
            }
            if (sb.length() > 1) {
                sb.deleteCharAt(sb.length() - 1);
            }
            this.pm.setValue(sb.toString());
        }
        this.setVisible(false);
    }

    private class MyCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        public MyCellRenderer() {
            this.setBorder(new LineBorder(Color.GRAY, 1));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                this.setText(value.toString());
            } else {
                this.setText("");
            }
            this.setSelected(isSelected);
            this.setBorderPainted(cellHasFocus);
            if (cellHasFocus) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

