/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.NoeudModifiable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.ChampModel;
import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.HiddenModel;
import fr.gouv.finances.cp.xemelios.common.config.WidgetModel;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListeResultatModel
implements NoeudModifiable,
Cloneable {
    private static Logger logger = Logger.getLogger(ListeResultatModel.class);
    private ElementModel parent;
    private NoeudModifiable _NMParent = null;
    public static final transient String TAG = "liste-resultat";
    public static final transient QName QN = new QName("liste-resultat");
    private String triDefaut;
    private String ordre;
    private Hashtable<String, ChampModel> champs = new Hashtable();
    private Vector<ChampModel> listeChamps = new Vector();
    private HashMap<String, ChampModel> hChampModels = new HashMap();
    private Vector<HiddenModel> hiddens = new Vector();
    private HashMap<String, HiddenModel> hHiddenModels = new HashMap();
    private Vector<WidgetModel> widgets = new Vector();
    private HashMap<String, WidgetModel> hWidgets = new HashMap();
    private String configXPath = null;

    public ListeResultatModel(QName tagName) {
        WidgetModel wm = new WidgetModel(WidgetModel.QN);
        wm.setClassName("fr.gouv.finances.cp.xemelios.widgets.generic.ViewCode");
        wm.setId("viewcode");
        wm.setLibelle("Voir le Xml...");
        try {
            this.addChild((XmlMarshallable)wm, WidgetModel.QN);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, QName tagName) throws SAXException {
        if (ChampModel.QN.equals(tagName)) {
            ChampModel cm = (ChampModel)child;
            if (this.hChampModels.containsKey(cm.getId())) {
                ChampModel old = this.hChampModels.get(cm.getId());
                this.champs.remove(old.getId());
                this.listeChamps.remove(old);
                this.hChampModels.remove(old.getId());
            }
            cm.setParent(this);
            cm.setParentAsNoeudModifiable(this);
            this.champs.put(cm.getId(), cm);
            this.listeChamps.add(cm);
            this.hChampModels.put(cm.getId(), cm);
        } else if (HiddenModel.QN.equals(tagName)) {
            HiddenModel hm = (HiddenModel)child;
            if (this.hHiddenModels.containsKey(hm.getName())) {
                HiddenModel old = this.hHiddenModels.get(hm.getName());
                this.hiddens.remove(old);
                this.hHiddenModels.remove(old.getName());
            }
            hm.setParentAsNoeudModifiable(this);
            this.hiddens.add(hm);
            this.hHiddenModels.put(hm.getName(), hm);
        } else if (WidgetModel.QN.equals(tagName)) {
            WidgetModel wm = (WidgetModel)child;
            if (this.hWidgets.containsKey(wm.getId())) {
                WidgetModel old = this.hWidgets.get(wm.getId());
                this.widgets.remove(old);
                this.hWidgets.remove(old.getId());
            }
            wm.setParentAsNoeudModifiable(this);
            this.widgets.add(wm);
            this.hWidgets.put(wm.getId(), wm);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.triDefaut = attributes.getValue("tri-defaut") != null ? attributes.getValue("tri-defaut") : this.triDefaut;
        this.ordre = attributes.getValue("ordre") != null ? attributes.getValue("ordre") : this.ordre;
        return this;
    }

    public void marshall(XmlOutputter output) {
        throw new Error("Not yet implemented");
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.triDefaut == null) {
            throw new InvalidXmlDefinition("//liste-resultat/@tri-defaut is required (" + this.getConfigXPath() + ")");
        }
        for (String s : this.triDefaut.split(",")) {
            if (s.length() == 0 || this.champs.get(s) != null) continue;
            throw new InvalidXmlDefinition(this.getConfigXPath() + "/@tri-defaut references a champ that is not defined: " + s);
        }
        if (this.ordre == null) {
            throw new InvalidXmlDefinition("//liste-resultat/@ordre is required (" + this.getConfigXPath() + ")");
        }
        for (WidgetModel wm : this.widgets) {
            wm.validate();
        }
        for (ChampModel cm : this.listeChamps) {
            cm.validate();
        }
        for (HiddenModel h : this.hiddens) {
            h.validate();
        }
    }

    public Hashtable<String, ChampModel> getChamps() {
        return this.champs;
    }

    public String getOrdre() {
        return this.ordre;
    }

    public String getTriDefaut() {
        return this.triDefaut;
    }

    public Vector<ChampModel> getListeChamps() {
        return this.listeChamps;
    }

    public ListeResultatModel clone() {
        ListeResultatModel other = new ListeResultatModel(QN);
        other.triDefaut = this.triDefaut == null ? null : new String(this.triDefaut);
        other.ordre = this.ordre == null ? null : new String(this.ordre);
        for (ChampModel cm : this.listeChamps) {
            ChampModel cm2 = cm.clone();
            try {
                other.addChild((XmlMarshallable)cm2, ChampModel.QN);
            }
            catch (SAXException ignore) {}
        }
        other.champs.putAll(this.champs);
        for (HiddenModel hm : this.hiddens) {
            try {
                other.addChild((XmlMarshallable)hm.clone(), HiddenModel.QN);
            }
            catch (SAXException saxEx) {}
        }
        other.emptyWidgets();
        for (WidgetModel wm : this.widgets) {
            try {
                other.addChild((XmlMarshallable)wm.clone(), WidgetModel.QN);
            }
            catch (SAXException saxEx) {}
        }
        return other;
    }

    public ElementModel getParent() {
        return this.parent;
    }

    public void setParent(ElementModel parent) {
        this.parent = parent;
    }

    public void setOrdre(String ordre) {
        this.ordre = ordre;
    }

    public void setTriDefaut(String triDefaut) {
        this.triDefaut = triDefaut;
    }

    public Vector<HiddenModel> getHiddens() {
        return this.hiddens;
    }

    public void setParentAsNoeudModifiable(NoeudModifiable p) {
        this._NMParent = p;
    }

    public NoeudModifiable getParentAsNoeudModifiable() {
        return this._NMParent;
    }

    public NoeudModifiable getChildAsNoeudModifiable(String tagName, String id) {
        if ("champ".equals(tagName)) {
            return this.hChampModels.get(id);
        }
        if ("hidden".equals(tagName)) {
            return this.hHiddenModels.get(id);
        }
        if ("widget".equals(tagName)) {
            return this.hWidgets.get(id);
        }
        return null;
    }

    public void modifyAttr(String attrName, String value) {
    }

    public void modifyAttrs(Attributes attrs) {
        try {
            this.getAttributes(new XmlAttributes(attrs));
        }
        catch (Exception e) {
            logger.error((Object)("Erreur lors de la mise \u00e0 jour des attributs : " + e));
        }
    }

    public String[] getChildIdAttrName(String childTagName) {
        if ("champ".equals(childTagName)) {
            return new String[]{"id"};
        }
        if ("hidden".equals(childTagName)) {
            return new String[]{"name"};
        }
        if ("widget".equals(childTagName)) {
            return new String[]{"id"};
        }
        return null;
    }

    public void resetCharData() {
    }

    public String getIdValue() {
        return null;
    }

    public void removeAllChamps() {
        this.champs = new Hashtable();
        this.listeChamps = new Vector();
        this.hChampModels = new HashMap();
    }

    public Vector<WidgetModel> getWidgets() {
        return this.widgets;
    }

    public String getConfigXPath() {
        if (this.configXPath == null) {
            this.configXPath = this.getParentAsNoeudModifiable() != null ? this.getParentAsNoeudModifiable().getConfigXPath() : "";
            this.configXPath = this.configXPath + "/liste-resultat";
        }
        return this.configXPath;
    }

    public XmlMarshallable getChildToModify(String uri, String localName, String qName, Attributes atts) {
        QName name = new QName(uri, localName);
        if (ChampModel.QN.equals(name)) {
            return (XmlMarshallable)this.hChampModels.get(atts.getValue("id"));
        }
        if (HiddenModel.QN.equals(name)) {
            return (XmlMarshallable)this.hHiddenModels.get(atts.getValue("name"));
        }
        if (WidgetModel.QN.equals(name)) {
            return (XmlMarshallable)this.hWidgets.get(atts.getValue("id"));
        }
        return null;
    }

    public QName getQName() {
        return QN;
    }

    protected void emptyWidgets() {
        this.hWidgets.clear();
        this.widgets.clear();
    }
}

