/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.utils;

public class WordWrap {
    public static String wrap(String inString, int wrap_length, String prepend) {
        int offset = 0;
        StringBuffer result = new StringBuffer();
        if (inString == null) {
            return null;
        }
        if (wrap_length < 0) {
            throw new IllegalArgumentException("bad params");
        }
        if (prepend != null) {
            result.append(prepend);
        }
        char[] charAry = inString.toCharArray();
        int marker = 0;
        int p = 0;
        while (marker < charAry.length) {
            int p2;
            while (p < charAry.length && charAry[p] != '\n' && p - marker < wrap_length) {
                ++p;
            }
            if (p == charAry.length) {
                result.append(inString.substring(marker, p));
                return result.toString();
            }
            if (charAry[p] == '\n') {
                result.append(inString.substring(marker, p + 1));
                if (prepend != null) {
                    result.append(prepend);
                }
                p = marker = p + 1;
                continue;
            }
            if (p < charAry.length) {
                if (WordWrap.isspace(charAry[p])) {
                    offset = 1;
                } else {
                    for (p2 = p - 1; p2 > marker && !WordWrap.isspace(charAry[p2]); --p2) {
                    }
                    offset = 0;
                }
            }
            if (p2 == marker) {
                p2 = p - 1;
            }
            if (!WordWrap.isspace(charAry[p2])) {
                result.append(inString.substring(marker, p2 + 1));
            } else {
                result.append(inString.substring(marker, p2));
            }
            if (p < charAry.length) {
                result.append("\n");
                if (prepend != null) {
                    result.append(prepend);
                }
            }
            p = marker = p2 + 1 + offset;
        }
        return result.toString();
    }

    public static String wrap(String inString, int wrap_length) {
        return WordWrap.wrap(inString, wrap_length, null);
    }

    public static boolean isspace(char c) {
        return c == '\n' || c == ' ' || c == '\t';
    }
}

