/*
 * Decompiled with CFR 0.152.
 */
package org.sektor37.minium.impl;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import org.sektor37.minium.TextRenderingHints;
import org.sektor37.minium.impl.AbstractTextRenderer;

public class OversamplingTextRendererImpl
extends AbstractTextRenderer {
    public Rectangle2D getLogicalBounds(Graphics g, Font font, String str) {
        int magnification = this.getMagnification(g);
        Font magnifiedFont = this.getMagnifiedFont(font, magnification);
        Rectangle2D result = g.getFontMetrics(magnifiedFont).getStringBounds(str, g);
        result.setRect(result.getX() / (double)magnification, result.getY() / (double)magnification, result.getWidth() / (double)magnification, result.getHeight() / (double)magnification);
        return result;
    }

    public Rectangle2D getVisualBounds(Graphics _g, Font font, String str) {
        Graphics2D g = (Graphics2D)_g;
        int magnification = this.getMagnification(g);
        Font magnifiedFont = this.getMagnifiedFont(font, magnification);
        Rectangle2D result = new TextLayout(str, magnifiedFont, g.getFontRenderContext()).getBounds();
        result.setRect(result.getX() / (double)magnification, result.getY() / (double)magnification, result.getWidth() / (double)magnification, result.getHeight() / (double)magnification);
        return result;
    }

    private float getMaxFontSize(TextRenderingHints.Key key) {
        Number maxFontSize = (Number)this.getTextRenderingHint(key);
        if (null == maxFontSize) {
            return 0.0f;
        }
        return maxFontSize.floatValue();
    }

    private int getMagnification(Graphics g) {
        Number oversamplingHint = (Number)this.getTextRenderingHint(TextRenderingHints.KEY_OVERSAMPLING);
        if (null == oversamplingHint || TextRenderingHints.VALUE_OVERSAMPLING_AUTO == oversamplingHint) {
            int fontSize = g.getFontMetrics().getHeight();
            float minFontSize = 0.0f;
            Number minFontSizeNum = (Number)this.getTextRenderingHint(TextRenderingHints.KEY_OVERSAMPLING_MIN_FONTSIZE);
            if (null != minFontSizeNum) {
                minFontSize = minFontSizeNum.floatValue();
            }
            if ((float)fontSize >= minFontSize) {
                float[] maxFontSizes = new float[]{this.getMaxFontSize(TextRenderingHints.KEY_OVERSAMPLING_8X_MAX_FONTSIZE), this.getMaxFontSize(TextRenderingHints.KEY_OVERSAMPLING_7X_MAX_FONTSIZE), this.getMaxFontSize(TextRenderingHints.KEY_OVERSAMPLING_6X_MAX_FONTSIZE), this.getMaxFontSize(TextRenderingHints.KEY_OVERSAMPLING_5X_MAX_FONTSIZE), this.getMaxFontSize(TextRenderingHints.KEY_OVERSAMPLING_4X_MAX_FONTSIZE), this.getMaxFontSize(TextRenderingHints.KEY_OVERSAMPLING_3X_MAX_FONTSIZE), this.getMaxFontSize(TextRenderingHints.KEY_OVERSAMPLING_2X_MAX_FONTSIZE)};
                for (int i = 0; i < maxFontSizes.length; ++i) {
                    if (!(maxFontSizes[i] >= (float)fontSize)) continue;
                    return 8 - i;
                }
            }
            return 1;
        }
        return oversamplingHint.intValue();
    }

    private Font getMagnifiedFont(Font font, int magnification) {
        return font.deriveFont(font.getSize2D() * (float)magnification);
    }

    public Rectangle2D getBounds(Graphics g, String str) {
        int magnification = this.getMagnification(g);
        Font magnifiedFont = this.getMagnifiedFont(g.getFont(), magnification);
        Rectangle2D result = g.getFontMetrics(magnifiedFont).getStringBounds(str, g);
        result.setRect(result.getX() / (double)magnification, result.getY() / (double)magnification, result.getWidth() / (double)magnification, result.getHeight() / (double)magnification);
        return result;
    }

    public LineMetrics getLineMetrics(Graphics _g, Font font, String str) {
        Graphics2D g = (Graphics2D)_g;
        int magnification = this.getMagnification(g);
        Font magnifiedFont = this.getMagnifiedFont(font, magnification);
        return new LineMetricsImpl(magnifiedFont.getLineMetrics(str, g.getFontRenderContext()), magnification);
    }

    public void drawString(Graphics _g, String str, float x, float y) {
        int magnification;
        Graphics2D g = (Graphics2D)_g;
        AffineTransform savedTransform = g.getTransform();
        Rectangle originalClip = g.getClipBounds();
        if (null == originalClip) {
            originalClip = new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        if (1 == (magnification = this.getMagnification(g))) {
            g.drawString(str, x, y);
        } else {
            AffineTransform upScale = AffineTransform.getScaleInstance(savedTransform.getScaleX(), savedTransform.getScaleY());
            Font magnifiedFont = this.getMagnifiedFont(g.getFont(), magnification).deriveFont(upScale);
            Rectangle2D magnifiedSize = g.getFontMetrics(magnifiedFont).getStringBounds(str, g);
            LineMetrics lm = magnifiedFont.getLineMetrics(str, g.getFontRenderContext());
            float magnifiedAscent = lm.getAscent();
            float ascent = magnifiedAscent / (float)magnification;
            float top = y - ascent;
            if (x >= (float)(originalClip.x + originalClip.width) || top >= (float)(originalClip.y + originalClip.height)) {
                return;
            }
            if ((double)x + Math.ceil(magnifiedSize.getWidth()) / (double)magnification < (double)originalClip.x || (double)top + Math.ceil(lm.getHeight()) / (double)magnification < (double)originalClip.y) {
                return;
            }
            float internalOffsetX = (float)((double)x % 1.0 * (double)magnification);
            float internalOffsetY = (float)((double)top % 1.0 * (double)magnification);
            int bufferWidth = (int)Math.ceil((double)internalOffsetX + magnifiedSize.getWidth());
            int bufferHeight = (int)Math.ceil(internalOffsetY + lm.getHeight());
            Point2D.Double clipMin = new Point2D.Double(originalClip.getMinX(), originalClip.getMinY());
            Point2D.Double clipMax = new Point2D.Double(originalClip.getMaxX(), originalClip.getMaxY());
            upScale.transform(clipMin, clipMin);
            upScale.transform(clipMax, clipMax);
            Rectangle2D.Double scaledClip = new Rectangle2D.Double(((Point2D)clipMin).getX(), ((Point2D)clipMin).getY(), ((Point2D)clipMax).getX() - ((Point2D)clipMin).getX(), ((Point2D)clipMax).getY() - ((Point2D)clipMin).getY());
            int clipLeft = ((int)((RectangularShape)scaledClip).getX() - (int)x) * magnification;
            int clipRight = (long)clipLeft + (long)((RectangularShape)scaledClip).getWidth() * (long)magnification < Integer.MAX_VALUE ? clipLeft + (int)((RectangularShape)scaledClip).getWidth() * magnification : Integer.MAX_VALUE;
            int clippedBufferWidth = Math.min(bufferWidth, clipRight) - Math.max(0, clipLeft);
            if (clippedBufferWidth <= 0) {
                return;
            }
            bufferWidth = clippedBufferWidth;
            bufferWidth += magnification - 1;
            bufferWidth -= bufferWidth % magnification;
            bufferHeight += magnification - 1;
            bufferHeight -= bufferHeight % magnification;
            BufferedImage buffer = new BufferedImage(bufferWidth, bufferHeight, 2);
            Graphics2D bufferGraphics = buffer.createGraphics();
            this.setRenderingHints(bufferGraphics, g, magnification);
            bufferGraphics.setColor(g.getColor());
            bufferGraphics.setFont(magnifiedFont);
            bufferGraphics.drawString(str, (float)(clipLeft > 0 ? -clipLeft : 0) + internalOffsetX, internalOffsetY + magnifiedAscent);
            bufferGraphics.dispose();
            Image downscaledImage = buffer.getScaledInstance(bufferWidth / magnification, bufferHeight / magnification, 4);
            AffineTransform downScale = AffineTransform.getScaleInstance(1.0 / savedTransform.getScaleX(), 1.0 / savedTransform.getScaleY());
            g.transform(downScale);
            int ix = Math.max((int)((RectangularShape)scaledClip).getX(), (int)x);
            int iy = (int)top;
            g.drawImage(downscaledImage, ix, iy, null);
            g.setTransform(savedTransform);
        }
    }

    private void setRenderingHints(Graphics2D graphics, Graphics2D template, int magnification) {
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Object textAntialiasingHint = this.getTextRenderingHint(TextRenderingHints.KEY_TEXT_ANTIALIASING);
        Object fractionalMetricsHint = this.getTextRenderingHint(TextRenderingHints.KEY_FRACTIONALMETRICS);
        if (1 == magnification || null != textAntialiasingHint && TextRenderingHints.VALUE_TEXT_ANTIALIAS_FROM_GRAPHICS == textAntialiasingHint) {
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, template.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING));
        } else if (null == textAntialiasingHint || TextRenderingHints.VALUE_TEXT_ANTIALIAS_ON == textAntialiasingHint) {
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else if (TextRenderingHints.VALUE_TEXT_ANTIALIAS_OFF == textAntialiasingHint) {
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        } else {
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if (1 == magnification || null == fractionalMetricsHint && TextRenderingHints.VALUE_FRACTIONALMETRICS_FROM_GRAPHICS == fractionalMetricsHint) {
            graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, template.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS));
        } else if (null == fractionalMetricsHint || TextRenderingHints.VALUE_FRACTIONALMETRICS_ON == fractionalMetricsHint) {
            graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        } else if (TextRenderingHints.VALUE_FRACTIONALMETRICS_OFF == fractionalMetricsHint) {
            graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        } else {
            graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
    }

    private static class LineMetricsImpl
    extends LineMetrics {
        private LineMetrics lineMetrics;
        private int magnification;

        public LineMetricsImpl(LineMetrics lineMetrics, int magnification) {
            this.lineMetrics = lineMetrics;
            this.magnification = magnification;
        }

        public float getAscent() {
            return this.lineMetrics.getAscent() / (float)this.magnification;
        }

        public float getDescent() {
            return this.lineMetrics.getDescent() / (float)this.magnification;
        }

        public float getHeight() {
            return this.lineMetrics.getHeight() / (float)this.magnification;
        }

        public float getLeading() {
            return this.lineMetrics.getLeading() / (float)this.magnification;
        }

        public int getNumChars() {
            return this.lineMetrics.getNumChars();
        }

        public float getStrikethroughOffset() {
            return this.lineMetrics.getStrikethroughOffset() / (float)this.magnification;
        }

        public float getStrikethroughThickness() {
            return this.lineMetrics.getStrikethroughThickness() / (float)this.magnification;
        }

        public float getUnderlineOffset() {
            return this.lineMetrics.getUnderlineOffset() / (float)this.magnification;
        }

        public float getUnderlineThickness() {
            return this.lineMetrics.getUnderlineThickness() / (float)this.magnification;
        }

        public int getBaselineIndex() {
            return this.lineMetrics.getBaselineIndex();
        }

        public float[] getBaselineOffsets() {
            float[] offsets = this.lineMetrics.getBaselineOffsets();
            float[] result = new float[offsets.length];
            for (int i = 0; i < offsets.length; ++i) {
                result[i] = offsets[i] / (float)this.magnification;
            }
            return result;
        }
    }
}

