/*
 * Decompiled with CFR 0.152.
 */
package org.sektor37.minium;

import org.sektor37.minium.TextRenderer;
import org.sektor37.minium.TextRendererConfigurationException;
import org.sektor37.minium.impl.Java2DTextRendererFactory;
import org.sektor37.minium.impl.OversamplingTextRendererFactory;

public abstract class TextRendererFactory {
    protected TextRendererFactory() {
    }

    public static TextRendererFactory newInstance() throws TextRendererConfigurationException {
        String factoryClassName = System.getProperty("org.sektor37.minium.TextRendererFactory");
        try {
            Class factoryClass = null != factoryClassName ? Class.forName(factoryClassName) : Java2DTextRendererFactory.class;
            return (TextRendererFactory)factoryClass.newInstance();
        }
        catch (Exception e) {
            String message = "Cannot instantiate TextRendererFactory instance";
            throw new TextRendererConfigurationException(message, e);
        }
    }

    public static TextRendererFactory newDefaultInstance() {
        return new Java2DTextRendererFactory();
    }

    public static TextRendererFactory newOversamplingInstance() {
        return new OversamplingTextRendererFactory();
    }

    public abstract TextRenderer newTextRenderer();
}

