/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.pdf.PdfEncryptor;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class InspectPDF
extends AbstractTool {
    static /* synthetic */ Class class$java$lang$String;

    public InspectPDF() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to inspect", false, new PdfFilter()));
        this.arguments.add(new ToolArgument(this, "ownerpassword", "The owner password if the file is encrypt", (class$java$lang$String == null ? (class$java$lang$String = InspectPDF.class$("java.lang.String")) : class$java$lang$String).getName()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Pdf Information", true, true, true);
        this.internalFrame.setSize(500, 300);
        this.internalFrame.setJMenuBar(this.getMenubar());
        this.internalFrame.getContentPane().add(this.getConsole(40, 30));
    }

    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            PdfReader reader = this.getValue("ownerpassword") == null ? new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath()) : new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath(), ((String)this.getValue("ownerpassword")).getBytes());
            System.out.println("=== Document Information ===");
            System.out.println("PDF Version: " + reader.getPdfVersion());
            System.out.println("Number of pages: " + reader.getNumberOfPages());
            System.out.println("Number of PDF objects: " + reader.getXrefSize());
            System.out.println("File length: " + reader.getFileLength());
            System.out.println("Encrypted? " + reader.isEncrypted());
            if (reader.isEncrypted()) {
                System.out.println("Permissions: " + PdfEncryptor.getPermissionsVerbose(reader.getPermissions()));
                System.out.println("128 bit? " + reader.is128Key());
            }
            System.out.println("Rebuilt? " + !reader.isRebuilt());
            System.out.println("=== Metadata ===");
            HashMap info = reader.getInfo();
            Iterator i = info.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                String value = (String)info.get(key);
                System.out.println(key + ": " + value);
            }
            if (reader.getMetadata() == null) {
                System.out.println("There is no XML Metadata in the file");
            } else {
                System.out.println("XML Metadata: " + new String(reader.getMetadata()));
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    public void valueHasChanged(ToolArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] args) {
        InspectPDF tool = new InspectPDF();
        if (args.length < 1) {
            System.err.println(tool.getUsage());
        }
        tool.setArguments(args);
        tool.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is no file to show.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        InspectPDF.addVersion("$Id: InspectPDF.java,v 1.4 2005/09/30 11:06:10 blowagie Exp $");
    }
}

