/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.Anchor;
import com.lowagie.text.Chapter;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.Header;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Section;
import com.lowagie.text.html.HtmlWriter;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.SimpleBookmark;
import com.lowagie.tools.Executable;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class HtmlBookmarks
extends AbstractTool {
    static /* synthetic */ Class class$java$lang$String;

    public HtmlBookmarks() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to inspect", false, new PdfFilter()));
        this.arguments.add(new ToolArgument(this, "ownerpassword", "The owner password if the file is encrypt", (class$java$lang$String == null ? (class$java$lang$String = HtmlBookmarks.class$("java.lang.String")) : class$java$lang$String).getName()));
        this.arguments.add(new ToolArgument(this, "css", "The path to a CSS file", (class$java$lang$String == null ? (class$java$lang$String = HtmlBookmarks.class$("java.lang.String")) : class$java$lang$String).getName()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Html Bookmarks", true, true, true);
        this.internalFrame.setSize(500, 300);
        this.internalFrame.setJMenuBar(this.getMenubar());
        this.internalFrame.getContentPane().add(this.getConsole(40, 30));
    }

    public void execute() {
        try {
            List list;
            Object title;
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File src = (File)this.getValue("srcfile");
            PdfReader reader = this.getValue("ownerpassword") == null ? new PdfReader(src.getAbsolutePath()) : new PdfReader(src.getAbsolutePath(), ((String)this.getValue("ownerpassword")).getBytes());
            File directory = src.getParentFile();
            String name = src.getName();
            name = name.substring(0, name.lastIndexOf("."));
            File html = new File(directory, name + "_index.html");
            Document document = new Document();
            HtmlWriter.getInstance(document, new FileOutputStream(html));
            Object css = this.getValue("css");
            if (css != null) {
                document.add(new Header("stylesheet", css.toString()));
            }
            if ((title = reader.getInfo().get("Title")) == null) {
                document.addTitle("Index for " + src.getName());
            } else {
                document.addKeywords("Index for '" + title + "'");
            }
            Object keywords = reader.getInfo().get("Keywords");
            if (keywords != null) {
                document.addKeywords((String)keywords);
            }
            Object description = reader.getInfo().get("Subject");
            if (keywords != null) {
                document.addSubject((String)description);
            }
            document.open();
            Paragraph t = title == null ? new Paragraph("Index for " + src.getName()) : new Paragraph("Index for '" + title + "'");
            t.setMarkupAttribute("class", "title");
            document.add(t);
            if (description != null) {
                Paragraph d = new Paragraph((String)description);
                d.setMarkupAttribute("class", "description");
                document.add(d);
            }
            if ((list = SimpleBookmark.getBookmark(reader)) == null) {
                document.add(new Paragraph("This document has no bookmarks."));
            } else {
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    HashMap c = (HashMap)i.next();
                    Chapter chapter = (Chapter)HtmlBookmarks.createBookmark(src.getName(), null, c);
                    ArrayList kids = (ArrayList)c.get("Kids");
                    if (kids != null) {
                        Iterator k = kids.iterator();
                        while (k.hasNext()) {
                            HtmlBookmarks.addBookmark(src.getName(), chapter, (HashMap)k.next());
                        }
                    }
                    document.add(chapter);
                }
            }
            document.close();
            Executable.launchBrowser(html.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    private static void addBookmark(String pdf, Section section, HashMap bookmark) {
        Section s = HtmlBookmarks.createBookmark(pdf, section, bookmark);
        ArrayList kids = (ArrayList)bookmark.get("Kids");
        if (kids == null) {
            return;
        }
        Iterator i = kids.iterator();
        while (i.hasNext()) {
            HtmlBookmarks.addBookmark(pdf, s, (HashMap)i.next());
        }
    }

    private static Section createBookmark(String pdf, Section section, HashMap bookmark) {
        Paragraph title = new Paragraph((String)bookmark.get("Title"));
        System.out.println((String)bookmark.get("Title"));
        String action = (String)bookmark.get("Action");
        if ("GoTo".equals(action)) {
            if (bookmark.get("Page") != null) {
                String page = (String)bookmark.get("Page");
                StringTokenizer tokens = new StringTokenizer(page);
                String token = tokens.nextToken();
                Anchor anchor = new Anchor(" page" + token);
                anchor.setReference(pdf + "#page=" + token);
                title.add(anchor);
            }
        } else if ("URI".equals(action)) {
            String url = (String)bookmark.get("URI");
            Anchor anchor = new Anchor(" Goto URL");
            anchor.setReference(url);
            title.add(anchor);
        } else if ("GoToR".equals(action)) {
            String remote = (String)bookmark.get("File");
            Anchor anchor = new Anchor(" goto " + remote);
            if (bookmark.get("Named") != null) {
                String named = (String)bookmark.get("Named");
                remote = remote + "#nameddest=" + named;
            } else if (bookmark.get("Page") != null) {
                String page = (String)bookmark.get("Page");
                StringTokenizer tokens = new StringTokenizer(page);
                String token = tokens.nextToken();
                anchor.add(new Chunk(" page " + token));
                remote = remote + "#page=" + token;
            }
            anchor.setReference(remote);
            title.add(anchor);
        }
        Section s = section == null ? new Chapter(title, 0) : section.addSection(title);
        s.setNumberDepth(0);
        return s;
    }

    public void valueHasChanged(ToolArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] args) {
        HtmlBookmarks tool = new HtmlBookmarks();
        if (args.length < 1) {
            System.err.println(tool.getUsage());
        }
        tool.setArguments(args);
        tool.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        throw new InstantiationException("There is no file to show.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HtmlBookmarks.addVersion("$Id: HtmlBookmarks.java,v 1.9 2005/09/30 11:06:10 blowagie Exp $");
    }
}

