/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.tools.Executable;
import com.lowagie.tools.ToolMenuItems;
import com.lowagie.tools.arguments.ToolArgument;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public abstract class AbstractTool
implements ToolMenuItems,
ActionListener {
    public static ArrayList versionsarray = new ArrayList();
    protected JInternalFrame internalFrame = null;
    protected ArrayList arguments = new ArrayList();
    protected int menuoptions = 1;
    public static final int MENU_EXECUTE = 1;
    public static final int MENU_EXECUTE_SHOW = 2;
    public static final int MENU_EXECUTE_PRINT = 4;
    public static final int MENU_EXECUTE_PRINT_SILENT = 8;

    public void setArguments(ArrayList arguments) {
        this.arguments = arguments;
    }

    public void setArguments(String[] args) {
        int counter = 0;
        Iterator i = this.arguments.iterator();
        while (i.hasNext()) {
            ToolArgument argument = (ToolArgument)i.next();
            if (args.length <= counter) break;
            argument.setValue(args[counter]);
            ++counter;
        }
    }

    public ArrayList getArguments() {
        return this.arguments;
    }

    public Object getValue(String name) throws InstantiationException {
        Iterator i = this.arguments.iterator();
        while (i.hasNext()) {
            ToolArgument argument = (ToolArgument)i.next();
            if (!name.equals(argument.getName())) continue;
            return argument.getArgument();
        }
        return null;
    }

    public void setInternalFrame(JInternalFrame internalFrame) {
        this.internalFrame = internalFrame;
    }

    public JInternalFrame getInternalFrame() {
        if (this.internalFrame == null) {
            this.createFrame();
        }
        return this.internalFrame;
    }

    public JMenuBar getMenubar() {
        JMenuItem execute;
        JMenuBar menubar = new JMenuBar();
        JMenu tool = new JMenu("Tool");
        tool.setMnemonic(70);
        JMenuItem usage = new JMenuItem("Usage");
        usage.setMnemonic(85);
        usage.addActionListener(this);
        tool.add(usage);
        JMenuItem args = new JMenuItem("Arguments");
        args.setMnemonic(65);
        args.addActionListener(this);
        tool.add(args);
        if ((this.menuoptions & 1) > 0) {
            execute = new JMenuItem("Execute");
            execute.setMnemonic(69);
            execute.addActionListener(this);
            tool.add(execute);
        }
        if ((this.menuoptions & 2) > 0) {
            execute = new JMenuItem("Execute+Open");
            execute.addActionListener(this);
            tool.add(execute);
        }
        if ((this.menuoptions & 4) > 0) {
            execute = new JMenuItem("Execute+Printdialog");
            execute.addActionListener(this);
            tool.add(execute);
        }
        if ((this.menuoptions & 8) > 0) {
            execute = new JMenuItem("Execute+Print");
            execute.addActionListener(this);
            tool.add(execute);
        }
        JMenuItem close = new JMenuItem("Close");
        close.setMnemonic(67);
        close.addActionListener(this);
        tool.add(close);
        menubar.add(tool);
        if (this.arguments.size() > 0) {
            JMenu params = new JMenu("Arguments");
            tool.setMnemonic(84);
            Iterator i = this.arguments.iterator();
            while (i.hasNext()) {
                ToolArgument argument = (ToolArgument)i.next();
                JMenuItem item = new JMenuItem(argument.getName());
                item.setToolTipText(argument.getDescription());
                item.addActionListener(argument);
                params.add(item);
            }
            menubar.add(params);
        }
        return menubar;
    }

    public JScrollPane getConsole(int columns, int rows) {
        try {
            Console console = new Console(columns, rows);
            return new JScrollPane(console.textArea);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public String getUsage() {
        ToolArgument argument;
        StringBuffer buf = new StringBuffer("java ");
        buf.append(this.getClass().getName());
        Iterator i = this.arguments.iterator();
        while (i.hasNext()) {
            argument = (ToolArgument)i.next();
            buf.append(" ");
            buf.append(argument.getName());
        }
        buf.append("\n");
        i = this.arguments.iterator();
        while (i.hasNext()) {
            argument = (ToolArgument)i.next();
            buf.append(argument.getUsage());
        }
        return buf.toString();
    }

    public String getArgs() {
        StringBuffer buf = new StringBuffer("Current arguments:\n");
        Iterator i = this.arguments.iterator();
        while (i.hasNext()) {
            ToolArgument argument = (ToolArgument)i.next();
            buf.append("  ");
            buf.append(argument.getName());
            if (argument.getValue() == null) {
                buf.append(" = null\n");
                continue;
            }
            buf.append(" = '");
            buf.append(argument.getValue());
            buf.append("'\n");
        }
        return buf.toString();
    }

    public void actionPerformed(ActionEvent evt) {
        if ("Close".equals(evt.getActionCommand())) {
            this.internalFrame.dispose();
        }
        if ("Usage".equals(evt.getActionCommand())) {
            JOptionPane.showMessageDialog(this.internalFrame, this.getUsage());
        }
        if ("Arguments".equals(evt.getActionCommand())) {
            JOptionPane.showMessageDialog(this.internalFrame, this.getArgs());
        }
        if ("Execute".equals(evt.getActionCommand())) {
            this.execute();
        }
        if ("Execute+Open".equals(evt.getActionCommand())) {
            this.execute();
            try {
                Executable.openDocument(this.getDestPathPDF());
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        if ("Execute+Printdialog".equals(evt.getActionCommand())) {
            this.execute();
            try {
                Executable.printDocument(this.getDestPathPDF());
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        if ("Execute+Print".equals(evt.getActionCommand())) {
            this.execute();
            try {
                Executable.printDocumentSilent(this.getDestPathPDF());
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }

    protected abstract File getDestPathPDF() throws InstantiationException;

    protected abstract void createFrame();

    public abstract void execute();

    public abstract void valueHasChanged(ToolArgument var1);

    protected static void addVersion(String version) {
        version = version.substring(5, version.length() - 7);
        version = version.substring(0, version.lastIndexOf(" "));
        versionsarray.add(version);
    }

    public class Console {
        PipedInputStream piOut;
        PipedInputStream piErr;
        PipedOutputStream poOut;
        PipedOutputStream poErr;
        JTextArea textArea = new JTextArea();

        public Console(int columns, int rows) throws IOException {
            this.piOut = new PipedInputStream();
            this.poOut = new PipedOutputStream(this.piOut);
            System.setOut(new PrintStream(this.poOut, true));
            this.piErr = new PipedInputStream();
            this.poErr = new PipedOutputStream(this.piErr);
            System.setErr(new PrintStream(this.poErr, true));
            this.textArea.setEditable(false);
            this.textArea.setRows(rows);
            this.textArea.setColumns(columns);
            new ReaderThread(this.piOut).start();
            new ReaderThread(this.piErr).start();
        }

        class ReaderThread
        extends Thread {
            PipedInputStream pi;

            ReaderThread(PipedInputStream pi) {
                this.pi = pi;
            }

            public void run() {
                byte[] buf = new byte[1024];
                try {
                    int len;
                    while ((len = this.pi.read(buf)) != -1) {
                        Console.this.textArea.append(new String(buf, 0, len));
                        Console.this.textArea.setCaretPosition(Console.this.textArea.getDocument().getLength());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

