/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools;

import com.lowagie.tools.Executable;
import com.lowagie.tools.ToolMenuItems;
import com.lowagie.tools.Versions;
import com.lowagie.tools.plugins.AbstractTool;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class Toolbox
extends JFrame
implements ToolMenuItems,
ActionListener {
    private JDesktopPane desktop;
    private Properties toolmap = new Properties();
    private int locationX = 0;
    private int locationY = 0;
    static /* synthetic */ Class class$com$lowagie$tools$Toolbox;

    public Toolbox() {
        this.setSize(600, 400);
        this.setDefaultCloseOperation(3);
        this.setResizable(true);
        this.setTitle("iText Toolbox");
        this.setJMenuBar(this.getMenubar());
        this.desktop = new JDesktopPane();
        this.setContentPane(this.desktop);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        Toolbox toolbox = new Toolbox();
    }

    private JMenuBar getMenubar() {
        Properties p = new Properties();
        try {
            p.load((class$com$lowagie$tools$Toolbox == null ? (class$com$lowagie$tools$Toolbox = Toolbox.class$("com.lowagie.tools.Toolbox")) : class$com$lowagie$tools$Toolbox).getClassLoader().getResourceAsStream("com/lowagie/tools/plugins/tools.txt"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.toolmap = new Properties();
        TreeMap<Object, Object> tmp = new TreeMap<Object, Object>();
        tmp.putAll(p);
        JMenuBar menubar = new JMenuBar();
        JMenu file = new JMenu("File");
        JMenuItem close = new JMenuItem("Close");
        close.setMnemonic(67);
        close.addActionListener(this);
        file.add(close);
        JMenu tools = new JMenu("Tools");
        file.setMnemonic(84);
        AbstractButton current = null;
        Iterator i = tmp.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (current == null || !name.startsWith(current.getText())) {
                current = new JMenu(name.substring(0, name.indexOf(".")));
                tools.add((JMenuItem)current);
            }
            JMenuItem item = new JMenuItem(name.substring(current.getText().length() + 1));
            item.addActionListener(this);
            String tool = (String)tmp.get(name);
            try {
                Class.forName(tool);
                this.toolmap.put(item.getText(), tool);
                ((JMenu)current).add(item);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Plugin " + name + " was not found in your CLASSPATH.");
            }
        }
        JMenu help = new JMenu("Help");
        JMenuItem about = new JMenuItem("About");
        about.setMnemonic(65);
        about.addActionListener(this);
        help.add(about);
        JMenuItem versions = new JMenuItem("Version");
        versions.addActionListener(this);
        help.add(versions);
        menubar.add(file);
        menubar.add(tools);
        menubar.add(Box.createGlue());
        menubar.add(help);
        return menubar;
    }

    private void createFrame(String name) throws InstantiationException, IllegalAccessException, ClassNotFoundException, PropertyVetoException {
        AbstractTool ti = (AbstractTool)Class.forName((String)this.toolmap.get(name)).newInstance();
        JInternalFrame f = ti.getInternalFrame();
        f.setLocation(this.locationX, this.locationY);
        this.locationX += 25;
        if (this.locationX > this.getWidth() + 50) {
            this.locationX = 0;
        }
        this.locationY += 25;
        if (this.locationY > this.getHeight() + 50) {
            this.locationY = 0;
        }
        f.setVisible(true);
        this.desktop.add(f);
        f.setSelected(true);
    }

    public void actionPerformed(ActionEvent evt) {
        if ("Close".equals(evt.getActionCommand())) {
            System.out.println("The Toolbox is closed.");
            System.exit(0);
        } else if ("About".equals(evt.getActionCommand())) {
            System.out.println("The iText Toolbox is part of iText, a Free Java-PDF Library.\nVisit http://www.lowagie.com/iText/toolbox.html for more info.");
            try {
                Executable.launchBrowser("http://www.lowagie.com/iText/toolbox.html");
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "The iText Toolbox is part of iText, a Free Java-PDF Library.\nVisit http://www.lowagie.com/iText/toolbox.html for more info.");
            }
        } else if ("Version".equals(evt.getActionCommand())) {
            Versions f = new Versions();
            f.setVisible(true);
        } else {
            try {
                this.createFrame(evt.getActionCommand());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

