/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Section;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.field.RtfTOCEntry;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class RtfSection
extends RtfElement {
    protected RtfParagraph title = null;
    protected ArrayList items = new ArrayList();

    public RtfSection(RtfDocument doc, Section section) {
        super(doc);
        try {
            if (section.title() != null) {
                this.title = (RtfParagraph)doc.getMapper().mapElement(section.title());
            }
            if (this.document.getAutogenerateTOCEntries()) {
                StringBuffer titleText = new StringBuffer();
                Iterator it = section.title().iterator();
                while (it.hasNext()) {
                    Element element = (Element)it.next();
                    if (element.type() != 10) continue;
                    titleText.append(((Chunk)element).content());
                }
                if (titleText.toString().trim().length() > 0) {
                    RtfTOCEntry tocEntry = new RtfTOCEntry(titleText.toString(), section.title().font());
                    tocEntry.setRtfDocument(this.document);
                    this.items.add(tocEntry);
                }
            }
            Iterator iterator = section.iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                RtfBasicElement rtfElement = doc.getMapper().mapElement(element);
                if (rtfElement == null) continue;
                this.items.add(rtfElement);
            }
            this.updateIndentation(section.indentationLeft(), section.indentationRight(), section.indentation());
        }
        catch (DocumentException de) {
            de.printStackTrace();
        }
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(RtfParagraph.PARAGRAPH);
            if (this.title != null) {
                result.write(this.title.write());
            }
            for (int i = 0; i < this.items.size(); ++i) {
                result.write(((RtfBasicElement)this.items.get(i)).write());
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public void setInTable(boolean inTable) {
        super.setInTable(inTable);
        for (int i = 0; i < this.items.size(); ++i) {
            ((RtfBasicElement)this.items.get(i)).setInTable(inTable);
        }
    }

    public void setInHeader(boolean inHeader) {
        super.setInHeader(inHeader);
        for (int i = 0; i < this.items.size(); ++i) {
            ((RtfBasicElement)this.items.get(i)).setInHeader(inHeader);
        }
    }

    private void updateIndentation(float indentLeft, float indentRight, float indentContent) {
        if (this.title != null) {
            this.title.setIndentLeft((int)((double)this.title.getIndentLeft() + (double)indentLeft * 20.0));
            this.title.setIndentRight((int)((double)this.title.getIndentRight() + (double)indentRight * 20.0));
        }
        for (int i = 0; i < this.items.size(); ++i) {
            RtfBasicElement rtfElement = (RtfBasicElement)this.items.get(i);
            if (rtfElement instanceof RtfSection) {
                ((RtfSection)rtfElement).updateIndentation(indentLeft + indentContent, indentRight, 0.0f);
                continue;
            }
            if (!(rtfElement instanceof RtfParagraph)) continue;
            ((RtfParagraph)rtfElement).setIndentLeft((int)((double)((RtfParagraph)rtfElement).getIndentLeft() + (double)(indentLeft + indentContent) * 20.0));
            ((RtfParagraph)rtfElement).setIndentRight((int)((double)((RtfParagraph)rtfElement).getIndentRight() + (double)indentRight * 20.0));
        }
    }
}

