/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Paragraph;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.graphic.RtfImage;
import com.lowagie.text.rtf.text.RtfPhrase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfParagraph
extends RtfPhrase {
    public static final byte[] PARAGRAPH = "\\par".getBytes();
    public static final byte[] ALIGN_LEFT = "\\ql".getBytes();
    public static final byte[] ALIGN_RIGHT = "\\qr".getBytes();
    public static final byte[] ALIGN_CENTER = "\\qc".getBytes();
    public static final byte[] ALIGN_JUSTIFY = "\\qj".getBytes();
    public static final byte[] INDENT_LEFT = "\\li".getBytes();
    public static final byte[] INDENT_RIGHT = "\\ri".getBytes();
    public static final byte[] KEEP_TOGETHER = "\\keep".getBytes();
    public static final byte[] KEEP_TOGETHER_WITH_NEXT = "\\keepn".getBytes();
    private static final byte[] SPACING_BEFORE = "\\sb".getBytes();
    private static final byte[] SPACING_AFTER = "\\sa".getBytes();
    private int alignment = -1;
    private int indentLeft = 0;
    private int indentRight = 0;
    private boolean keepTogether = false;
    private boolean keepTogetherWithNext = false;
    private int spacingBefore = 0;
    private int spacingAfter = 0;

    public RtfParagraph(RtfDocument doc, Paragraph paragraph) {
        super(doc, paragraph);
        this.alignment = paragraph.alignment();
        this.indentLeft = (int)((double)paragraph.indentationLeft() * 20.0);
        this.indentRight = (int)((double)paragraph.indentationRight() * 20.0);
        this.keepTogether = paragraph.getKeepTogether();
        this.spacingBefore = (int)((double)paragraph.spacingBefore() * 20.0);
        this.spacingAfter = (int)((double)paragraph.spacingAfter() * 20.0);
        for (int i = 0; i < this.chunks.size(); ++i) {
            if (!(this.chunks.get(i) instanceof RtfImage)) continue;
            ((RtfImage)this.chunks.get(i)).setAlignment(this.alignment);
        }
    }

    public void setKeepTogetherWithNext(boolean keepTogetherWithNext) {
        this.keepTogetherWithNext = keepTogetherWithNext;
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(PARAGRAPH_DEFAULTS);
            if (this.keepTogether) {
                result.write(KEEP_TOGETHER);
            }
            if (this.keepTogetherWithNext) {
                result.write(KEEP_TOGETHER_WITH_NEXT);
            }
            if (this.inTable) {
                result.write(IN_TABLE);
            }
            switch (this.alignment) {
                case 0: {
                    result.write(ALIGN_LEFT);
                    break;
                }
                case 2: {
                    result.write(ALIGN_RIGHT);
                    break;
                }
                case 1: {
                    result.write(ALIGN_CENTER);
                    break;
                }
                case 3: 
                case 8: {
                    result.write(ALIGN_JUSTIFY);
                }
            }
            result.write(INDENT_LEFT);
            result.write(this.intToByteArray(this.indentLeft));
            result.write(INDENT_RIGHT);
            result.write(this.intToByteArray(this.indentRight));
            if (this.spacingBefore > 0) {
                result.write(SPACING_BEFORE);
                result.write(this.intToByteArray(this.spacingBefore));
            }
            if (this.spacingAfter > 0) {
                result.write(SPACING_AFTER);
                result.write(this.intToByteArray(this.spacingAfter));
            }
            if (this.lineLeading > 0) {
                result.write(LINE_SPACING);
                result.write(this.intToByteArray(this.lineLeading));
            }
            for (int i = 0; i < this.chunks.size(); ++i) {
                result.write(((RtfBasicElement)this.chunks.get(i)).write());
            }
            if (!this.inTable) {
                result.write(PARAGRAPH);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public int getIndentLeft() {
        return this.indentLeft;
    }

    public void setIndentLeft(int indentLeft) {
        this.indentLeft = indentLeft;
    }

    public int getIndentRight() {
        return this.indentRight;
    }

    public void setIndentRight(int indentRight) {
        this.indentRight = indentRight;
    }
}

