/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.table;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfColor;
import com.lowagie.text.rtf.table.RtfBorderGroup;
import com.lowagie.text.rtf.table.RtfRow;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class RtfCell
extends Cell
implements RtfExtendedElement {
    private static final int MERGE_NONE = 0;
    private static final int MERGE_VERT_PARENT = 1;
    private static final int MERGE_VERT_CHILD = 2;
    private RtfRow parentRow = null;
    private ArrayList content = null;
    private int cellRight = 0;
    private int cellWidth = 0;
    private RtfBorderGroup borders = null;
    private int verticalAlignment = 5;
    private RtfColor backgroundColor = null;
    private int cellPadding = 0;
    private int mergeType = 0;
    private int colspan = 1;
    private int rowspan = 1;
    private RtfDocument document = null;
    private boolean inHeader = false;

    public RtfCell() {
        this.borders = new RtfBorderGroup();
    }

    public RtfCell(String content) {
        super(content);
        this.borders = new RtfBorderGroup();
    }

    public RtfCell(Element element) throws BadElementException {
        super(element);
        this.borders = new RtfBorderGroup();
    }

    public RtfCell(Properties properties) {
        super(properties);
        this.borders = new RtfBorderGroup();
    }

    protected RtfCell(RtfDocument doc, RtfRow row, Cell cell) {
        this.document = doc;
        this.parentRow = row;
        this.importCell(cell);
    }

    private void importCell(Cell cell) {
        this.content = new ArrayList();
        if (cell == null) {
            this.borders = new RtfBorderGroup(this.document, 2, this.parentRow.getParentTable().getBorders());
            return;
        }
        this.colspan = cell.colspan();
        this.rowspan = cell.rowspan();
        if (cell.rowspan() > 1) {
            this.mergeType = 1;
        }
        this.borders = cell instanceof RtfCell ? new RtfBorderGroup(this.document, 2, ((RtfCell)cell).getBorders()) : new RtfBorderGroup(this.document, 2, cell.border(), cell.borderWidth(), cell.borderColor());
        this.verticalAlignment = cell.verticalAlignment();
        if (cell.backgroundColor() == null && cell.grayFill() == 0.0f) {
            this.backgroundColor = new RtfColor(this.document, 255, 255, 255);
        } else if (cell.backgroundColor() != null) {
            this.backgroundColor = new RtfColor(this.document, cell.backgroundColor());
        } else {
            int grayScale = (int)(cell.grayFill() * 255.0f);
            this.backgroundColor = new RtfColor(this.document, grayScale, grayScale, grayScale);
        }
        this.cellPadding = (int)this.parentRow.getParentTable().getCellPadding();
        if (cell != null) {
            Iterator cellIterator = cell.getElements();
            Paragraph container = null;
            while (cellIterator.hasNext()) {
                try {
                    RtfBasicElement rtfElement;
                    Element element = (Element)cellIterator.next();
                    if (!(element instanceof Paragraph)) {
                        if (container != null) {
                            container.add(element);
                            continue;
                        }
                        container = new Paragraph();
                        container.setAlignment(cell.horizontalAlignment());
                        container.add(element);
                        continue;
                    }
                    if (container != null) {
                        rtfElement = this.document.getMapper().mapElement(container);
                        rtfElement.setInTable(true);
                        this.content.add(rtfElement);
                        container = null;
                    }
                    if (element instanceof Paragraph && ((Paragraph)element).alignment() == -1) {
                        ((Paragraph)element).setAlignment(cell.horizontalAlignment());
                    }
                    rtfElement = this.document.getMapper().mapElement(element);
                    rtfElement.setInTable(true);
                    this.content.add(rtfElement);
                }
                catch (DocumentException de) {
                    de.printStackTrace();
                }
            }
            if (container != null) {
                try {
                    RtfBasicElement rtfElement = this.document.getMapper().mapElement(container);
                    rtfElement.setInTable(true);
                    this.content.add(rtfElement);
                }
                catch (DocumentException de) {
                    de.printStackTrace();
                }
            }
        }
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            if (this.mergeType == 1) {
                result.write("\\clvmgf".getBytes());
            } else if (this.mergeType == 2) {
                result.write("\\clvmrg".getBytes());
            }
            switch (this.verticalAlignment) {
                case 6: {
                    result.write("\\clvertalb".getBytes());
                    break;
                }
                case 1: 
                case 5: {
                    result.write("\\clvertalc".getBytes());
                    break;
                }
                case 4: {
                    result.write("\\clvertalt".getBytes());
                }
            }
            result.write(this.borders.write());
            if (this.backgroundColor != null) {
                result.write("\\clcbpat".getBytes());
                result.write(this.intToByteArray(this.backgroundColor.getColorNumber()));
            }
            result.write(10);
            result.write("\\clftsWidth3".getBytes());
            result.write(10);
            result.write("\\clwWidth".getBytes());
            result.write(this.intToByteArray(this.cellWidth));
            result.write(10);
            if (this.cellPadding > 0) {
                result.write("\\clpadl".getBytes());
                result.write(this.intToByteArray(this.cellPadding / 2));
                result.write("\\clpadt".getBytes());
                result.write(this.intToByteArray(this.cellPadding / 2));
                result.write("\\clpadr".getBytes());
                result.write(this.intToByteArray(this.cellPadding / 2));
                result.write("\\clpadb".getBytes());
                result.write(this.intToByteArray(this.cellPadding / 2));
                result.write("\\clpadfl3".getBytes());
                result.write("\\clpadft3".getBytes());
                result.write("\\clpadfr3".getBytes());
                result.write("\\clpadfb3".getBytes());
            }
            result.write("\\cellx".getBytes());
            result.write(this.intToByteArray(this.cellRight));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            if (this.content.size() == 0) {
                result.write(RtfParagraph.PARAGRAPH_DEFAULTS);
                if (this.parentRow.getParentTable().getTableFitToPage()) {
                    result.write(RtfParagraph.KEEP_TOGETHER_WITH_NEXT);
                }
                result.write("\\intbl".getBytes());
            } else {
                for (int i = 0; i < this.content.size(); ++i) {
                    RtfBasicElement rtfElement = (RtfBasicElement)this.content.get(i);
                    if (rtfElement instanceof RtfParagraph) {
                        ((RtfParagraph)rtfElement).setKeepTogetherWithNext(this.parentRow.getParentTable().getTableFitToPage());
                    }
                    result.write(rtfElement.write());
                    if (!(rtfElement instanceof RtfParagraph) || i >= this.content.size() - 1) continue;
                    result.write(RtfParagraph.PARAGRAPH);
                }
            }
            result.write("\\cell".getBytes());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    protected void setCellRight(int cellRight) {
        this.cellRight = cellRight;
    }

    protected int getCellRight() {
        return this.cellRight;
    }

    protected void setCellWidth(int cellWidth) {
        this.cellWidth = cellWidth;
    }

    protected int getCellWidth() {
        return this.cellWidth;
    }

    protected int getColspan() {
        return this.colspan;
    }

    protected int getRowspan() {
        return this.rowspan;
    }

    protected int getCellpadding() {
        return this.cellPadding;
    }

    protected RtfBorderGroup getBorders() {
        return this.borders;
    }

    public void setBorders(RtfBorderGroup borderGroup) {
        this.borders = new RtfBorderGroup(this.document, 2, borderGroup);
    }

    protected int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    protected RtfColor getBackgroundColor() {
        return this.backgroundColor;
    }

    protected void setCellMergeChild(RtfCell mergeParent) {
        this.mergeType = 2;
        this.cellWidth = mergeParent.getCellWidth();
        this.cellRight = mergeParent.getCellRight();
        this.cellPadding = mergeParent.getCellpadding();
        this.borders = mergeParent.getBorders();
        this.verticalAlignment = mergeParent.getVerticalAlignment();
        this.backgroundColor = mergeParent.getBackgroundColor();
    }

    public void setRtfDocument(RtfDocument doc) {
        this.document = doc;
    }

    public void setInTable(boolean inTable) {
    }

    public void setInHeader(boolean inHeader) {
        this.inHeader = inHeader;
        for (int i = 0; i < this.content.size(); ++i) {
            ((RtfBasicElement)this.content.get(i)).setInHeader(inHeader);
        }
    }

    private byte[] intToByteArray(int i) {
        return Integer.toString(i).getBytes();
    }
}

