/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.field;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class RtfField
extends Chunk
implements RtfBasicElement {
    private static final byte[] FIELD = "\\field".getBytes();
    private static final byte[] FIELD_DIRTY = "\\flddirty".getBytes();
    private static final byte[] FIELD_PRIVATE = "\\fldpriv".getBytes();
    private static final byte[] FIELD_LOCKED = "\\fldlock".getBytes();
    private static final byte[] FIELD_EDIT = "\\fldedit".getBytes();
    private static final byte[] FIELD_ALT = "\\fldalt".getBytes();
    private static final byte[] FIELD_INSTRUCTIONS = "\\*\\fldinst".getBytes();
    private static final byte[] FIELD_RESULT = "\\fldrslt".getBytes();
    private boolean fieldDirty = false;
    private boolean fieldEdit = false;
    private boolean fieldLocked = false;
    private boolean fieldPrivate = false;
    private boolean fieldAlt = false;
    private boolean inTable = false;
    private boolean inHeader = false;
    protected RtfDocument document = null;
    private RtfFont font = null;

    protected RtfField(RtfDocument doc) {
        this(doc, new Font());
    }

    protected RtfField(RtfDocument doc, Font font) {
        super("", font);
        this.document = doc;
        this.font = new RtfFont(this.document, font);
    }

    public void setRtfDocument(RtfDocument doc) {
        this.document = doc;
        this.font.setRtfDocument(this.document);
    }

    private byte[] writeFieldBegin() throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        result.write(RtfBasicElement.OPEN_GROUP);
        result.write(FIELD);
        if (this.fieldDirty) {
            result.write(FIELD_DIRTY);
        }
        if (this.fieldEdit) {
            result.write(FIELD_EDIT);
        }
        if (this.fieldLocked) {
            result.write(FIELD_LOCKED);
        }
        if (this.fieldPrivate) {
            result.write(FIELD_PRIVATE);
        }
        return result.toByteArray();
    }

    private byte[] writeFieldInstBegin() throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        result.write(RtfBasicElement.OPEN_GROUP);
        result.write(FIELD_INSTRUCTIONS);
        result.write(RtfBasicElement.DELIMITER);
        return result.toByteArray();
    }

    protected abstract byte[] writeFieldInstContent() throws IOException;

    private byte[] writeFieldInstEnd() throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        if (this.fieldAlt) {
            result.write(RtfBasicElement.DELIMITER);
            result.write(FIELD_ALT);
        }
        result.write(RtfBasicElement.CLOSE_GROUP);
        return result.toByteArray();
    }

    private byte[] writeFieldResultBegin() throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        result.write(RtfBasicElement.OPEN_GROUP);
        result.write(FIELD_RESULT);
        result.write(RtfBasicElement.DELIMITER);
        return result.toByteArray();
    }

    protected abstract byte[] writeFieldResultContent() throws IOException;

    private byte[] writeFieldResultEnd() throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        result.write(RtfBasicElement.DELIMITER);
        result.write(RtfBasicElement.CLOSE_GROUP);
        return result.toByteArray();
    }

    private byte[] writeFieldEnd() throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        result.write(RtfBasicElement.CLOSE_GROUP);
        return result.toByteArray();
    }

    public byte[] write() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(this.font.writeBegin());
            result.write(this.writeFieldBegin());
            result.write(this.writeFieldInstBegin());
            result.write(this.writeFieldInstContent());
            result.write(this.writeFieldInstEnd());
            result.write(this.writeFieldResultBegin());
            result.write(this.writeFieldResultContent());
            result.write(this.writeFieldResultEnd());
            result.write(this.writeFieldEnd());
            result.write(this.font.writeEnd());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }

    public boolean isFieldAlt() {
        return this.fieldAlt;
    }

    public void setFieldAlt(boolean fieldAlt) {
        this.fieldAlt = fieldAlt;
    }

    public boolean isFieldDirty() {
        return this.fieldDirty;
    }

    public void setFieldDirty(boolean fieldDirty) {
        this.fieldDirty = fieldDirty;
    }

    public boolean isFieldEdit() {
        return this.fieldEdit;
    }

    public void setFieldEdit(boolean fieldEdit) {
        this.fieldEdit = fieldEdit;
    }

    public boolean isFieldLocked() {
        return this.fieldLocked;
    }

    public void setFieldLocked(boolean fieldLocked) {
        this.fieldLocked = fieldLocked;
    }

    public boolean isFieldPrivate() {
        return this.fieldPrivate;
    }

    public void setFieldPrivate(boolean fieldPrivate) {
        this.fieldPrivate = fieldPrivate;
    }

    public void setInTable(boolean inTable) {
        this.inTable = inTable;
    }

    public void setInHeader(boolean inHeader) {
        this.inHeader = inHeader;
    }

    public boolean isEmpty() {
        return false;
    }
}

