/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.codec.postscript.MetaDoPS;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;

public class ImgPostscript
extends Image
implements Element {
    ImgPostscript(Image image) {
        super(image);
    }

    public ImgPostscript(URL url) throws BadElementException, IOException {
        super(url);
        this.processParameters();
    }

    public ImgPostscript(String filename) throws BadElementException, MalformedURLException, IOException {
        this(Image.toURL(filename));
    }

    public ImgPostscript(byte[] img) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = img;
        this.originalData = img;
        this.processParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processParameters() throws BadElementException, IOException {
        InputStream is;
        block13: {
            block11: {
                block12: {
                    this.type = 35;
                    this.originalType = 7;
                    is = null;
                    try {
                        String errorID;
                        if (this.rawData == null) {
                            is = this.url.openStream();
                            errorID = this.url.toString();
                        } else {
                            is = new ByteArrayInputStream(this.rawData);
                            errorID = "Byte array";
                        }
                        String boundingbox = null;
                        BufferedReader r = new BufferedReader(new InputStreamReader(is));
                        while (((Reader)r).ready()) {
                            char c;
                            StringBuffer sb = new StringBuffer();
                            while ((c = (char)((Reader)r).read()) != '\n') {
                                sb.append(c);
                            }
                            if (sb.toString().startsWith("%%BoundingBox:")) {
                                boundingbox = sb.toString();
                            }
                            if (sb.toString().startsWith("%%TemplateBox:")) {
                                boundingbox = sb.toString();
                            }
                            if (!sb.toString().startsWith("%%EndComments")) continue;
                        }
                        if (boundingbox == null) {
                            Object var16_8 = null;
                            if (is == null) break block11;
                            break block12;
                        }
                        StringTokenizer st = new StringTokenizer(boundingbox, ": \r\n");
                        st.nextElement();
                        String xx1 = st.nextToken();
                        String yy1 = st.nextToken();
                        String xx2 = st.nextToken();
                        String yy2 = st.nextToken();
                        int left = Integer.parseInt(xx1);
                        int top = Integer.parseInt(yy1);
                        int right = Integer.parseInt(xx2);
                        int bottom = Integer.parseInt(yy2);
                        boolean inch = true;
                        this.dpiX = 72;
                        this.dpiY = 72;
                        this.scaledHeight = (float)(bottom - top) / (float)inch * 1.0f;
                        this.scaledHeight = 800.0f;
                        this.setTop(this.scaledHeight);
                        this.scaledWidth = (float)(right - left) / (float)inch * 1.0f;
                        this.scaledWidth = 800.0f;
                        this.setRight(this.scaledWidth);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var16_10 = null;
                        if (is != null) {
                            is.close();
                        }
                        this.plainWidth = this.width();
                        this.plainHeight = this.height();
                        throw throwable;
                    }
                }
                is.close();
            }
            this.plainWidth = this.width();
            this.plainHeight = this.height();
            return;
        }
        Object var16_9 = null;
        if (is != null) {
            is.close();
        }
        this.plainWidth = this.width();
        this.plainHeight = this.height();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPostscript(PdfTemplate template) throws IOException, DocumentException {
        this.setTemplateData(template);
        template.setWidth(this.width());
        template.setHeight(this.height());
        InputStream is = null;
        try {
            is = this.rawData == null ? this.url.openStream() : new ByteArrayInputStream(this.rawData);
            MetaDoPS meta = new MetaDoPS(is, template);
            meta.readAll();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

