/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.widgets.generic;

import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.WidgetModel;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.cp.xemelios.ui.resulttable.DataHandler;
import fr.gouv.finances.cp.xemelios.ui.resulttable.EtatResultTableModel;
import fr.gouv.finances.cp.xemelios.widgets.AbstractWidget;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class SaveAs
extends AbstractWidget {
    private static Logger logger = Logger.getLogger(SaveAs.class);

    public SaveAs(WidgetModel wm, ElementModel em) {
        super(wm, em);
    }

    public void run(EtatResultTableModel etrm, int row) {
        try {
            DataHandler dh = etrm.getRowAt(row, 0);
            Document doc = dh.getDocument();
            String encoding = dh.getDocumentEncoding();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.setOutputProperty("encoding", encoding);
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Enregistrer " + ("male".equals(this.getWidgetModel().getParam("gender").getValue()) ? "le" : "la") + " " + this.getElementModel().getTitre() + " sous...");
            chooser.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toUpperCase().endsWith(".XML");
                }

                public String getDescription() {
                    return "Fichier XML";
                }
            });
            File saveTo = null;
            boolean bContinue = true;
            while (bContinue) {
                if (0 == chooser.showSaveDialog(MainWindow.instance)) {
                    int len;
                    File f = chooser.getSelectedFile();
                    String fileName = f.getAbsolutePath();
                    if (fileName.substring((len = fileName.length()) - 4).indexOf(46) < 0) {
                        fileName = fileName + ".xml";
                        f = new File(fileName);
                    }
                    if (f.exists()) {
                        int ret = JOptionPane.showConfirmDialog(MainWindow.instance, f.getAbsolutePath() + "\nexiste. Voulez-vous l'\u00e9craser ?", "Ecrasement de fichier", 1);
                        switch (ret) {
                            case 1: {
                                break;
                            }
                            case 0: {
                                saveTo = f;
                            }
                            case 2: {
                                bContinue = false;
                            }
                        }
                        continue;
                    }
                    saveTo = f;
                    bContinue = false;
                    continue;
                }
                bContinue = false;
            }
            if (saveTo != null) {
                logger.debug((Object)"writting");
                FileOutputStream fos = new FileOutputStream(saveTo, false);
                StreamResult sr = new StreamResult(fos);
                t.transform(new DOMSource(doc), sr);
                fos.flush();
                fos.close();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"in run: ", (Throwable)ex);
        }
    }

    private static class LocalFileFilter
    extends FileFilter {
        private String ext;
        private String description;

        public LocalFileFilter(String ext, String desc) {
            this.ext = ext;
            this.description = this.description;
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toUpperCase().equals(this.ext);
        }

        public String getDescription() {
            return this.description;
        }
    }
}

