/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.updater.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.xml.sax.SAXException;

public class ReleaseModel
implements XmlMarshallable {
    public static final transient String TAG = "release";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private String v;
    private Date date;

    public ReleaseModel(String tag) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.v = attributes.getValue("v");
        String sTmp = attributes.getValue("date");
        try {
            this.date = sdf.parse(sTmp);
        }
        catch (ParseException pEx) {
            throw new SAXException("format for date attribute is YYYY-MM-DD");
        }
        return this;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        output.addAttribute("v", this.v);
        output.addAttribute("date", sdf.format(this.date));
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getV() {
        return this.v;
    }

    public void setV(String v) {
        this.v = v;
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.v == null || this.v.length() == 0) {
            throw new InvalidXmlDefinition("attribute v is mandatory for release element.");
        }
        if (this.date == null) {
            throw new InvalidXmlDefinition("attribute date is mandatory for release element.");
        }
    }

    public ReleaseModel clone() {
        ReleaseModel rm = new ReleaseModel(TAG);
        rm.v = this.v;
        rm.date = (Date)this.date.clone();
        return rm;
    }
}

