/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.updater.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.updater.config.ComponentRefModel;
import fr.gouv.finances.cp.xemelios.updater.config.ConfigurationModel;
import fr.gouv.finances.cp.xemelios.updater.config.FileListModel;
import fr.gouv.finances.cp.xemelios.updater.config.ReleaseModel;
import fr.gouv.finances.cp.xemelios.updater.config.RequireModel;
import fr.gouv.finances.cp.xemelios.updater.config.TexteModel;
import java.util.ArrayList;
import java.util.Iterator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentModel
implements XmlMarshallable {
    public static final transient String TAG = "component";
    public static final int XEMELIOS = 1;
    public static final int CONFIG = 2;
    public static final int FEATURE = 3;
    private String id;
    private String name;
    private ReleaseModel release;
    private TexteModel description;
    private RequireModel requires;
    private ArrayList<FileListModel> fileLists = new ArrayList();
    private ConfigurationModel configuration;
    private boolean visible = true;
    public boolean selected = false;
    public int type = 0;

    public ComponentModel(String tag) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
        if ("release".equals(tagName)) {
            this.release = (ReleaseModel)child;
        } else if ("description".equals(tagName)) {
            this.description = (TexteModel)child;
        } else if ("requires".equals(tagName)) {
            this.requires = (RequireModel)child;
        } else if ("files".equals(tagName)) {
            this.fileLists.add((FileListModel)child);
        } else if ("configuration".equals(tagName)) {
            this.configuration = (ConfigurationModel)child;
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("cid");
        this.name = attributes.getValue("name");
        String sTmp = attributes.getValue("visible");
        if (sTmp != null) {
            this.visible = attributes.getBooleanValue("visible");
        }
        return this;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        output.addAttribute("cid", this.id);
        output.addAttribute("name", this.name);
        if (!this.visible) {
            output.addAttribute("visible", "no");
        }
        this.release.marshall(output);
        this.description.marshall(output);
        if (this.requires != null) {
            this.requires.marshall(output);
        }
        Iterator<FileListModel> it = this.fileLists.iterator();
        while (it.hasNext()) {
            it.next().marshall(output);
        }
        output.endTag(TAG);
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.id == null) {
            throw new InvalidXmlDefinition("cid attribute is mandatory for element component");
        }
        if (this.name == null) {
            throw new InvalidXmlDefinition("name attribute is mandatory for element component");
        }
    }

    public ComponentModel clone() {
        ComponentModel cm = new ComponentModel(TAG);
        cm.id = this.id;
        cm.name = this.name;
        cm.release = this.release.clone();
        cm.description = this.description.clone();
        Iterator<FileListModel> it = this.fileLists.iterator();
        while (it.hasNext()) {
            cm.fileLists.add(it.next().clone());
        }
        return cm;
    }

    public TexteModel getDescription() {
        return this.description;
    }

    public void setDescription(TexteModel description) {
        this.description = description;
    }

    public void setDescription(String s) {
        TexteModel desc = new TexteModel("description");
        try {
            desc.addCharacterData(s);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setDescription(desc);
    }

    public ArrayList<FileListModel> getFileLists() {
        return this.fileLists;
    }

    public void setFileLists(ArrayList<FileListModel> fileLists) {
        this.fileLists = fileLists;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ReleaseModel getRelease() {
        return this.release;
    }

    public void setRelease(ReleaseModel release) {
        this.release = release;
    }

    public void setRelease(String s) {
        ReleaseModel rm = new ReleaseModel("release");
        rm.setV(s);
        this.setRelease(rm);
    }

    public RequireModel getRequires() {
        return this.requires;
    }

    public void setRequires(RequireModel requires) {
        this.requires = requires;
    }

    public String toString() {
        return this.getId() + " (" + this.getRelease().getV() + ")";
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean equals(Object o) {
        if (o instanceof ComponentModel) {
            ComponentModel cm = (ComponentModel)o;
            return cm.getId().equals(this.id) && cm.getRelease().getV().equals(this.getRelease().getV());
        }
        if (o instanceof ComponentRefModel) {
            ComponentRefModel cm = (ComponentRefModel)o;
            return cm.getId().equals(this.id) && cm.getVersion().equals(this.getRelease().getV());
        }
        if (o instanceof String) {
            return this.getId().equals((String)o);
        }
        return false;
    }

    public ConfigurationModel getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ConfigurationModel configuration) {
        this.configuration = configuration;
    }
}

