/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.xhtmlviewer;

import fr.gouv.finances.cp.utils.IoUtils;
import fr.gouv.finances.cp.utils.NavigationContext;
import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.StartUrl;
import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.xemelios.common.DematTransform;
import fr.gouv.finances.cp.xemelios.common.NetAccess;
import fr.gouv.finances.cp.xemelios.common.PJRef;
import fr.gouv.finances.cp.xemelios.common.ToolException;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.EtatModel;
import fr.gouv.finances.cp.xemelios.data.DataAccessException;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import fr.gouv.finances.cp.xemelios.data.DataImpl;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.cp.xemelios.ui.UpdatableToolbar;
import fr.gouv.finances.cp.xemelios.ui.xhtmlviewer.Dest;
import fr.gouv.finances.cp.xemelios.ui.xhtmlviewer.LocalException;
import fr.gouv.finances.cp.xemelios.ui.xhtmlviewer.NotFoundException;
import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xhtmlrenderer.swing.NaiveUserAgent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XemeliosUserAgent
extends NaiveUserAgent {
    private static final Logger logger = Logger.getLogger(XemeliosUserAgent.class);
    public static final int MAX_VISITED_URIS = 100;
    LinkedHashMap<String, Object> visitedUris;
    private int index = -1;
    private ArrayList<String> history = new ArrayList();
    private String baseUrl;
    private UpdatableToolbar toolbar;
    protected NavigationContext nc;
    private MainWindow mainWindow;
    private Component viewer;

    public XemeliosUserAgent(MainWindow mw, Component viewer, UpdatableToolbar toolbar) {
        this(viewer);
        this.mainWindow = mw;
        this.toolbar = toolbar;
    }

    protected XemeliosUserAgent(Component viewer) {
        this.viewer = viewer;
        this.visitedUris = new LinkedHashMap<String, Object>(16, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Object> eldest) {
                return this.size() == 100;
            }
        };
    }

    public boolean isVisited(String uri) {
        return this.visitedUris.containsKey(uri);
    }

    public String resolveURI(String uri) {
        if (uri == null) {
            return this.getBaseURL();
        }
        if (uri.startsWith("xemelios:")) {
            String shortUri;
            logger.debug((Object)("resolving " + uri));
            String anchor = null;
            int indexSharp = uri.indexOf("#");
            if (indexSharp > 0) {
                shortUri = uri.substring(0, indexSharp);
                anchor = uri.substring(indexSharp + 1);
            } else {
                shortUri = uri;
            }
            Dest dest = (Dest)this.visitedUris.get(shortUri);
            if (dest == null || "true".equals(System.getProperty("xemelios.navigation.force-reload"))) {
                dest = this.calculateQuery(shortUri);
                this.visitedUris.put(shortUri, dest);
            }
            if (dest != null && dest.url != null) {
                if (dest.toExternal) {
                    try {
                        StartUrl.startUrl(dest.url.toExternalForm());
                    }
                    catch (ToolException toEx) {
                        // empty catch block
                    }
                    return null;
                }
                String ret = dest.url.toExternalForm();
                if (indexSharp > 0) {
                    ret = ret + uri.substring(indexSharp);
                }
                return ret;
            }
        }
        return super.resolveURI(uri);
    }

    public void setBaseURL(String url) {
        String historic;
        super.setBaseURL(url);
        if (this.baseUrl != null && this.baseUrl.startsWith("error:")) {
            this.baseUrl = null;
        }
        this.baseUrl = url;
        if (this.baseUrl == null) {
            return;
        }
        if (this.index >= 0 && (historic = this.history.get(this.index)).equals(this.baseUrl)) {
            this.toolbar.updateToolbarButtons();
            return;
        }
        ++this.index;
        int i = this.index;
        while (i < this.history.size()) {
            this.history.remove(i);
        }
        this.history.add(this.index, this.baseUrl);
        this.toolbar.updateToolbarButtons();
        this.toolbar.setBaseUrl(url);
    }

    public String getForward() {
        ++this.index;
        return this.history.get(this.index);
    }

    public String getBack() {
        --this.index;
        return this.history.get(this.index);
    }

    public boolean hasForward() {
        return this.index + 1 < this.history.size() && this.index >= 0;
    }

    public boolean hasBack() {
        return this.index > 0;
    }

    protected InputStream resolveAndOpenStream(String uri) {
        InputStream retValue = null;
        try {
            GetMethod meth;
            HttpClient client;
            int retCode;
            URL url = new URL(uri);
            if ("http".equals(url.getProtocol()) && (retCode = (client = NetAccess.getHttpClient()).executeMethod((HttpMethod)(meth = new GetMethod(uri)))) <= 300) {
                retValue = meth.getResponseBodyAsStream();
            }
        }
        catch (MalformedURLException muEx) {
        }
        catch (DataConfigurationException dcEx) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (retValue == null) {
            retValue = super.resolveAndOpenStream(uri);
        }
        return retValue;
    }

    public Dest calculateQuery(String query) {
        NavigationContext ctx = null;
        ctx = this.nc == null ? new NavigationContext() : this.nc.clone();
        Hashtable<String, Object> params = new Hashtable<String, Object>();
        params.put("browser-destination", "internal");
        String servlet = null;
        String sTmp = query;
        int start = query.indexOf(63);
        if (start >= 0) {
            servlet = query.substring(query.indexOf("/") + 1, start);
            sTmp = query.substring(start + 1);
        }
        if ("query".equals(servlet)) {
            StringTokenizer st = new StringTokenizer(sTmp, "&");
            while (st.hasMoreTokens()) {
                String data = st.nextToken();
                logger.debug((Object)("parsing " + data));
                int pos = data.indexOf(61);
                if (pos <= 0) continue;
                String paramName = data.substring(0, pos);
                String paramValue = null;
                try {
                    paramValue = URLDecoder.decode(data.substring(pos + 1), "UTF-8");
                    logger.debug((Object)(paramName + "=" + paramValue));
                }
                catch (Throwable t) {
                    logger.error((Object)"decoding", t);
                }
                if ("docId".equals(paramName)) {
                    ctx.setDocId(paramValue);
                    continue;
                }
                if ("etatId".equals(paramName)) {
                    ctx.setEtatId(paramValue);
                    continue;
                }
                if ("elementId".equals(paramName)) {
                    ctx.setElementId(paramValue);
                    continue;
                }
                if ("collectivite".equals(paramName)) {
                    ctx.setCollectivite(paramValue);
                    continue;
                }
                if ("budget".equals(paramName)) {
                    ctx.setBudget(paramValue);
                    continue;
                }
                if ("sp1".equals(paramName)) {
                    ctx.setSp1(paramValue);
                    continue;
                }
                if ("sp2".equals(paramName)) {
                    ctx.setSp2(paramValue);
                    continue;
                }
                if ("path".equals(paramName)) {
                    ctx.setPath(paramValue);
                    continue;
                }
                if (!paramName.startsWith("xsl:param")) continue;
                int virg = paramValue.indexOf(44);
                String pName = paramValue.substring(1, virg);
                String pValue = paramValue.substring(virg + 1, paramValue.length() - 1);
                params.put(pName, pValue);
            }
            return this.generateDestContext(ctx, params, false);
        }
        if ("resource".equals(servlet)) {
            Dest ret = null;
            try {
                File resourceDir = new File(System.getProperty("xemelios.resources.location"));
                File res = new File(resourceDir, sTmp);
                ret = new Dest(res.toURL(), false);
            }
            catch (Throwable t) {
                // empty catch block
            }
            return ret;
        }
        if ("attachment".equals(servlet)) {
            StringTokenizer st = new StringTokenizer(sTmp, "&");
            String pjCollectivite = ctx.getCollectivite();
            String pjId = null;
            while (st.hasMoreTokens()) {
                String data = st.nextToken();
                logger.debug((Object)("parsing " + data));
                int pos = data.indexOf(61);
                if (pos <= 0) continue;
                String paramName = data.substring(0, pos);
                String paramValue = null;
                try {
                    paramValue = URLDecoder.decode(data.substring(pos + 1), "UTF-8");
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if ("collectivite".equals(paramName)) {
                    pjCollectivite = paramValue;
                    continue;
                }
                if (!"pjId".equals(paramName)) continue;
                pjId = paramValue;
            }
            if (pjId != null && pjCollectivite != null) {
                try {
                    DataImpl impl = DataLayerManager.getImplementation();
                    PJRef pjRef = impl.getPjByUniqueId(new Pair(pjCollectivite, ""), pjId);
                    if (pjRef != null) {
                        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
                        File tmpFile = File.createTempFile("tmp-", pjRef.getFileName(), tmpDir);
                        FileOutputStream fos = new FileOutputStream(tmpFile);
                        fos.write(pjRef.getData());
                        fos.flush();
                        fos.close();
                        return new Dest(tmpFile.toURL(), true);
                    }
                    JOptionPane.showMessageDialog(this.viewer, "Pi\u00e8ce non trouv\u00e9e", "Erreur", 0);
                }
                catch (DataConfigurationException dcEx) {
                }
                catch (DataAccessException daEx) {
                }
                catch (IOException ioEx) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public Dest generateDestContext(NavigationContext ctx, Hashtable<String, Object> params, boolean toExternalDest) {
        logger.debug((Object)ctx);
        boolean noException = false;
        Dest ret = null;
        try {
            ArrayList<String> documents;
            ElementModel element;
            DocumentModel dm = this.mainWindow.getDocModels().getDocumentById(ctx.getDocId());
            if (dm == null) {
                throw new LocalException("doc " + ctx.getDocId() + " inconnu");
            }
            EtatModel em = dm.getEtatById(ctx.getEtatId());
            if (em == null) {
                throw new LocalException("etat " + ctx.getEtatId() + " inconnu");
            }
            ElementModel elementModel = element = ctx.getElementId() != null ? em.getElementById(ctx.getElementId()) : em.getBrowsableElement();
            if (ctx.getCollectivite() == null) {
                throw new LocalException("collectivite non definie");
            }
            if (ctx.getBudget() == null) {
                throw new LocalException("budget non definit");
            }
            DataImpl impl = DataLayerManager.getImplementation();
            String docId = null;
            if (ctx.getPath() == null) {
                documents = impl.getDocumentListFromSpecialKeys(element, ctx.getCollectivite(), ctx.getBudget(), ctx.getSp1(), ctx.getSp2(), ctx.getSp3());
                if (documents.size() == 0) {
                    JOptionPane.showMessageDialog(this.viewer, "Le document est introuvable", "", 2);
                    noException = true;
                } else if (documents.size() > 1 && !em.isMultiPage()) {
                    JOptionPane.showMessageDialog(this.viewer, "Plusieurs documents r\u00e9pondant \u00e0 ces crit\u00e8res ont \u00e9t\u00e9 trouv\u00e9s.", "Erreur", 0);
                    noException = true;
                } else {
                    docId = documents.get(0);
                }
            } else {
                if (ctx.getElementId() == null) {
                    ctx.setElementId(element.getId());
                }
                if (ctx.getPath() != null && ctx.getPath().startsWith("[")) {
                    ctx.setPath(element.getPath().getFormattedPath() + ctx.getPath());
                }
                if ((documents = impl.getDocumentListFromXPath(element, ctx.getCollectivite(), ctx.getBudget(), ctx.getSp1(), ctx.getSp2(), ctx.getSp3(), ctx.getPath())).size() == 0) {
                    JOptionPane.showMessageDialog(this.viewer, "Le document est introuvable", "", 2);
                    noException = true;
                } else if (documents.size() > 1 && !em.isMultiPage()) {
                    JOptionPane.showMessageDialog(this.viewer, "Plusieurs documents r\u00e9pondant \u00e0 ces crit\u00e8res ont \u00e9t\u00e9 trouv\u00e9s.", "Erreur", 0);
                    noException = true;
                } else {
                    docId = documents.get(0);
                }
            }
            if (docId != null) {
                Document doc = impl.getDocumentAsDom(em, new Pair(ctx.getCollectivite(), null), new Pair(ctx.getBudget(), null), docId);
                File f = new File(em.getParent().getBaseDirectory(), element.getXslt());
                InputStream is = IoUtils.getInputStream(f.getPath());
                Hashtable<String, Object> parameters = new Hashtable<String, Object>();
                parameters.putAll(params);
                if (parameters.get("browser-destination") == null) {
                    parameters.put("browser-destination", em.useExternalBrowser() ? "external" : "internal");
                }
                Document repository = impl.getRepositoryAsDom(dm, new Pair(ctx.getCollectivite(), null));
                parameters.put("repository", repository);
                parameters.put("config", this.mainWindow.getDocModels().getSmallDOM());
                InputStream htmlStream = DematTransform.transform(doc, is, parameters);
                File tmpDir = new File(System.getProperty("java.io.tmpdir"));
                tmpDir = new File(tmpDir, "XEMELIOS");
                tmpDir.mkdirs();
                File tmp = File.createTempFile("xemelios-data-", ".html", tmpDir);
                BufferedInputStream bis = new BufferedInputStream(htmlStream);
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tmp));
                byte[] buff = new byte[1024];
                int lengthRead = bis.read(buff);
                while (lengthRead > 0) {
                    bos.write(buff, 0, lengthRead);
                    lengthRead = bis.read(buff);
                }
                bos.flush();
                bos.close();
                URL url = tmp.toURL();
                this.nc = ctx;
                ret = new Dest(url, toExternalDest);
            } else if (!noException) {
                throw new NotFoundException("Pas de " + element.getTitre() + " trouv\u00e9(e)");
            }
        }
        catch (LocalException lEx) {
            JOptionPane.showMessageDialog(this.viewer, lEx.getMessage(), "Erreur de param\u00e9trage", 0);
        }
        catch (Exception ex) {
            Component comp2;
            for (comp2 = this.viewer; comp2 != null && !(comp2 instanceof JFrame); comp2 = comp2.getParent()) {
            }
            if (comp2 != null) {
                new DisplayExceptionDlg((Frame)((JFrame)comp2), (Throwable)ex);
            }
            new DisplayExceptionDlg((Frame)null, (Throwable)ex);
        }
        return ret;
    }

    public Component getViewer() {
        return this.viewer;
    }
}

