/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.resulttable;

import fr.gouv.finances.cp.utils.Amount;
import fr.gouv.finances.cp.utils.xml.dompath.DomPath;
import fr.gouv.finances.cp.utils.xml.xpath.FunctionResolver;
import fr.gouv.finances.cp.xemelios.common.config.ChampModel;
import fr.gouv.finances.cp.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.cp.xemelios.data.DataAccessException;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import fr.gouv.finances.cp.xemelios.data.DataResultSet;
import fr.gouv.finances.cp.xemelios.ui.resulttable.CachedData;
import fr.gouv.finances.cp.xemelios.ui.resulttable.PjRefHandler;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DataHandler
implements Comparable {
    public static final transient int ORDER_NO = 0;
    public static final transient int ORDER_DESC = 1;
    public static final transient int ORDER_ASC = -1;
    public static long timeCountLocal = 0L;
    public static long timeCountExtern = 0L;
    private static Logger logger = Logger.getLogger(DataHandler.class);
    private static XPathFactory xpf = null;
    private Element el;
    private Object value;
    private ListeResultatModel lrm;
    private int orderByCol;
    private int sort;
    private DataResultSet drs;
    private String resultKey;
    private Comparable[] cachedData;
    private CachedData globalData;
    private Object[] innerData;
    private Document document = null;
    private String documentEncoding = null;
    private XPath xPath = null;
    private int positionsFilled = 0;

    public DataHandler(ListeResultatModel lrm, Element el, DataResultSet drs, String resultKey, CachedData globalData) {
        this.lrm = lrm;
        this.el = el;
        this.drs = drs;
        this.resultKey = resultKey;
        this.globalData = globalData;
        this.xPath = xpf.newXPath();
        this.cachedData = new Comparable[lrm.getListeChamps().size() + lrm.getHiddens().size()];
        this.innerData = new Object[this.cachedData.length];
        this.setOrderByColumn(DataHandler.getColumnTri(lrm.getTriDefaut()), DataHandler.getOrdreTri(lrm.getOrdre()));
    }

    public void setOrderByColumn(int index, int sort) {
        this.orderByCol = index;
        this.sort = sort;
        try {
            this.computeValue();
        }
        catch (Exception ex) {
            logger.error((Object)"setOrderByColumn", (Throwable)ex);
        }
    }

    public void setOrderByColumn(String colId, int sort) {
        Vector<ChampModel> chps = this.lrm.getListeChamps();
        String sColId = DataHandler.getColumnTri(colId);
        for (int i = 0; i < chps.size(); ++i) {
            if (!chps.elementAt(i).getId().equals(sColId)) continue;
            this.setOrderByColumn(i, sort);
            break;
        }
    }

    public int getOrderByColumn() {
        return this.orderByCol;
    }

    public int getSortOrder() {
        return this.sort;
    }

    protected void computeValue() throws ParseException {
        this.value = this.getValueAtColumn(this.orderByCol);
    }

    public Object getValue() throws ParseException {
        if (this.value == null) {
            this.computeValue();
        }
        return this.value;
    }

    public int compareTo(Object arg0) {
        if (arg0 == this) {
            return 0;
        }
        if (arg0 instanceof DataHandler) {
            DataHandler other = (DataHandler)arg0;
            int ret = 0;
            try {
                Comparable maValeur = (Comparable)this.getValue();
                Comparable autreValeur = (Comparable)other.getValue();
                ret = maValeur == null ? -1 : (autreValeur == null ? 1 : maValeur.compareTo(autreValeur));
            }
            catch (ParseException pEx) {
                // empty catch block
            }
            if (ret == 0 && arg0 != this) {
                ret = -1;
            }
            return this.sort * -1 * ret;
        }
        return -1;
    }

    public boolean equals(Object arg0) {
        return this.compareTo(arg0) == 0;
    }

    public Object getValueAtColumn(int pos) throws ParseException {
        Object ret = "<error>";
        if (this.innerData[pos] == null) {
            Object computed = null;
            String path = pos < this.lrm.getListeChamps().size() ? this.lrm.getListeChamps().get(pos).getPath().getPath() : this.lrm.getHiddens().get(pos - this.lrm.getListeChamps().size()).getPath().getPath();
            long now = System.currentTimeMillis();
            if (path.startsWith("/")) {
                try {
                    ret = this.queryCachedData(path);
                }
                catch (Exception ex) {
                    logger.error((Object)"querying document: ", (Throwable)ex);
                    this.globalData.setCachedData(this.resultKey, path, ret);
                }
                timeCountExtern += System.currentTimeMillis() - now;
            } else {
                try {
                    DomPath domPath;
                    if (pos < this.lrm.getListeChamps().size()) {
                        if (!"pj-list".equals(this.lrm.getListeChamps().get(pos).getDatatype())) {
                            domPath = this.lrm.getListeChamps().get(pos).getPath().getDomPath(this.lrm.getParent().getParent().getParent().getNamespaces());
                            ret = domPath.getValue(this.el, true);
                        } else {
                            PjRefHandler pjHandler = new PjRefHandler();
                            this.xPath.setNamespaceContext(this.lrm.getParent().getParent().getParent().getNamespaces());
                            NodeList nl = (NodeList)this.xPath.evaluate(this.lrm.getListeChamps().get(pos).getPath().getFormattedPath(), this.el, XPathConstants.NODESET);
                            for (int i = 0; i < nl.getLength(); ++i) {
                                Element el = (Element)nl.item(i);
                                pjHandler.addPj(this.lrm.getParent().getParent().getParent(), el);
                            }
                            ret = pjHandler;
                        }
                    } else {
                        domPath = this.lrm.getHiddens().get(pos - this.lrm.getListeChamps().size()).getPath().getDomPath(this.lrm.getParent().getParent().getParent().getNamespaces());
                        ret = domPath.getValue(this.el, true);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"getValueAtColumn", (Throwable)ex);
                    this.globalData.setCachedData(this.resultKey, path, ret);
                }
                timeCountLocal += System.currentTimeMillis() - now;
            }
            if (ret == null || ret.toString().length() == 0) {
                computed = null;
                this.innerData[pos] = "";
            } else {
                Class classToReturn = pos >= this.lrm.getListeChamps().size() ? String.class : this.lrm.getListeChamps().get(pos).getDataClass();
                if (classToReturn.equals(Float.class)) {
                    try {
                        computed = new Float(Float.parseFloat((String)ret));
                    }
                    catch (NumberFormatException nfEx) {
                        computed = new Float(Float.NaN);
                    }
                } else if (classToReturn.equals(Integer.class)) {
                    try {
                        computed = new Integer(Integer.parseInt((String)ret));
                    }
                    catch (NumberFormatException nfEx) {
                        computed = "NaN";
                    }
                } else if (classToReturn.equals(Amount.class)) {
                    try {
                        computed = new Amount((String)ret);
                    }
                    catch (NumberFormatException nfEx) {
                        computed = new Amount(Float.NaN);
                    }
                } else if (classToReturn.equals(Date.class)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    computed = sdf.parse((String)ret);
                } else {
                    computed = classToReturn.equals(PjRefHandler.class) ? (Comparable)ret : ret.toString();
                }
            }
            this.cachedData[pos] = computed;
            if (this.innerData[pos] == null) {
                this.innerData[pos] = ret;
            }
            ++this.positionsFilled;
            if (this.positionsFilled == this.cachedData.length) {
                this.document = null;
            }
        }
        return this.cachedData[pos];
    }

    public Object getInnerDataAt(int pos) {
        return this.innerData[pos];
    }

    public Element getElement() {
        return this.el;
    }

    public Document getDocument() throws DataConfigurationException, DataAccessException {
        if (this.document == null) {
            this.document = this.drs.getDocument(this.resultKey);
        }
        return this.document;
    }

    public String getDocumentEncoding() throws DataConfigurationException, DataAccessException {
        if (this.documentEncoding == null) {
            this.documentEncoding = this.drs.getDocumentEncoding(this.resultKey);
        }
        return this.documentEncoding;
    }

    private Object queryCachedData(String path) throws DataConfigurationException, DataAccessException {
        Object ret = this.globalData.getCachedData(this.resultKey, path);
        if (ret == null) {
            try {
                ret = this.xPath.evaluate(path, this.getDocument());
            }
            catch (XPathExpressionException xpExpr) {
                throw new DataConfigurationException(xpExpr);
            }
            this.globalData.setCachedData(this.resultKey, path, ret);
        }
        return ret;
    }

    public static String getColumnTri(String orderByColumns) {
        StringTokenizer tokenizer = new StringTokenizer(orderByColumns, ",");
        if (tokenizer.hasMoreTokens()) {
            return tokenizer.nextToken();
        }
        return null;
    }

    public static int getOrdreTri(String orderByOrdres) {
        StringTokenizer tokenizer = new StringTokenizer(orderByOrdres, ",");
        if (tokenizer.hasMoreTokens()) {
            return "DESC".equals(tokenizer.nextToken()) ? 1 : -1;
        }
        return -1;
    }

    static {
        try {
            xpf = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom");
        }
        catch (Throwable t) {
            xpf = XPathFactory.newInstance();
        }
        xpf.setXPathFunctionResolver(new FunctionResolver());
    }
}

