/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.importDialog;

import fr.gouv.finances.cp.utils.ui.IhmFactory;
import fr.gouv.finances.cp.xemelios.ui.importDialog.ImportFile;
import fr.gouv.finances.cp.xemelios.ui.importDialog.ImportFileTreeTableModel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.TreeTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportDialog {
    private static final Logger logger = Logger.getLogger(ImportDialog.class);
    private JFrame parent = null;
    private String title = "";
    protected List<ImportFile> resultList = new ArrayList<ImportFile>();

    public ImportDialog(JFrame parent, String title) {
        this.parent = parent;
        this.title = title;
    }

    public List<ImportFile> startDialog(File rootDir, String[] extensions) {
        ImportFileTreeTableModel model = this.createImportFileModel(rootDir, extensions);
        InnerImportDialog d = new InnerImportDialog(model, this.parent, this.title, true);
        d.setVisible(true);
        return this.resultList;
    }

    public ImportFileTreeTableModel createImportFileModel(File rootDir, String[] extensions) {
        ImportFileTreeTableModel model = null;
        if (!rootDir.isDirectory()) {
            return model;
        }
        ImportFile racineDir = new ImportFile(rootDir);
        MyTreeNode racine = this.splitPath(racineDir, racineDir);
        Iterator iter = FileUtils.iterateFiles((File)rootDir, (String[])extensions, (boolean)true);
        ImportFile fichierImport = null;
        while (iter.hasNext()) {
            File fichier = (File)iter.next();
            fichierImport = new ImportFile(fichier);
            this.addSorted(racine, this.splitPath(fichierImport, racineDir));
        }
        model = new ImportFileTreeTableModel(racine);
        return model;
    }

    private MyTreeNode splitPath(ImportFile fichierImport, ImportFile upToDir) {
        File parentFile;
        MyTreeNode currentNode = new MyTreeNode(fichierImport);
        if (upToDir.getFile().equals(fichierImport.getFile())) {
            return currentNode;
        }
        File upDir = upToDir.getFile();
        while ((parentFile = ((ImportFile)currentNode.getUserObject()).getFile().getParentFile()) != null) {
            ImportFile parentImportFile = new ImportFile(parentFile);
            MyTreeNode parentNode = new MyTreeNode(parentImportFile);
            parentNode.add(currentNode);
            currentNode = parentNode;
            if (!parentFile.equals(upDir)) continue;
            break;
        }
        return currentNode;
    }

    private void addSorted(MyTreeNode racine, MyTreeNode newNode) {
        MyTreeNode newNodeBrowser = newNode;
        MyTreeNode rootBrowser = racine;
        boolean continuer = true;
        while (continuer) {
            ImportFile rootBrowserFile;
            ImportFile newNodeBrowserFile = (ImportFile)newNodeBrowser.getUserObject();
            if (newNodeBrowserFile.equals(rootBrowserFile = (ImportFile)rootBrowser.getUserObject())) {
                MyTreeNode rootSon = this.matchingChild(newNodeBrowser = (MyTreeNode)newNodeBrowser.getFirstChild(), rootBrowser);
                if (rootSon != null) {
                    rootBrowser = rootSon;
                    continue;
                }
                continuer = false;
                continue;
            }
            continuer = false;
        }
        rootBrowser.add(newNodeBrowser);
    }

    private MyTreeNode matchingChild(DefaultMutableTreeNode newNodeBrowser, DefaultMutableTreeNode rootBrowser) {
        MyTreeNode result = null;
        ImportFile newNodeBrowserFile = (ImportFile)newNodeBrowser.getUserObject();
        Enumeration<TreeNode> enumerator = rootBrowser.children();
        while (enumerator.hasMoreElements() && result == null) {
            MyTreeNode child = (MyTreeNode)enumerator.nextElement();
            ImportFile childFile = (ImportFile)child.getUserObject();
            if (!childFile.equals(newNodeBrowserFile)) continue;
            result = child;
        }
        return result;
    }

    public class MyTreeNode
    extends DefaultMutableTreeNode {
        private ImportFile importFile;

        public MyTreeNode(ImportFile iFile) {
            super(iFile);
            this.importFile = iFile;
        }

        public boolean isLeaf() {
            boolean ret = !this.importFile.getFile().isDirectory();
            return ret;
        }
    }

    class InnerImportDialog
    extends JDialog
    implements ActionListener {
        JButton boutonExpandAll;
        JButton boutonCollapseAll;
        JButton boutonSelectAll;
        JButton boutonSelectNone;
        JButton boutonOk;
        JButton boutonAnnuler;
        static final long serialVersionUID = 345134599L;
        private JXTreeTable treeTable;
        private ImportFileTreeTableModel importFileTreeTableModel;

        public InnerImportDialog(ImportFileTreeTableModel model, JFrame parent, String title, boolean modal) {
            super(parent, title, modal);
            this.importFileTreeTableModel = null;
            this.importFileTreeTableModel = model;
            this.treeTable = new JXTreeTable((TreeTableModel)this.importFileTreeTableModel);
            JScrollPane jScrollPane1 = new JScrollPane();
            this.setDefaultCloseOperation(2);
            jScrollPane1.setViewportView((Component)this.treeTable);
            jScrollPane1.setHorizontalScrollBarPolicy(30);
            this.boutonOk = new JButton("Ok");
            this.boutonOk.addActionListener(this);
            this.boutonAnnuler = new JButton("Annuler");
            this.boutonAnnuler.addActionListener(this);
            JToolBar toolbar = new JToolBar(0);
            toolbar.setFloatable(false);
            toolbar.setRollover(true);
            IhmFactory ihmFactory = IhmFactory.newInstance();
            this.boutonExpandAll = new JButton(ihmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/expandAll.png"));
            this.boutonExpandAll.setToolTipText("D\u00e9plier l'arborescence");
            this.boutonExpandAll.addActionListener(this);
            toolbar.add(this.boutonExpandAll);
            this.boutonCollapseAll = new JButton(ihmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/collapseAll.png"));
            this.boutonCollapseAll.setToolTipText("Replier l'arborescence");
            this.boutonCollapseAll.addActionListener(this);
            toolbar.add(this.boutonCollapseAll);
            this.boutonSelectAll = new JButton(ihmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/selectAll.png"));
            this.boutonSelectAll.setToolTipText("Tout s\u00e9lectionner");
            this.boutonSelectAll.addActionListener(this);
            toolbar.add(this.boutonSelectAll);
            this.boutonSelectNone = new JButton(ihmFactory.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/selectNone.png"));
            this.boutonSelectNone.setToolTipText("Tout d\u00e9s\u00e9lectionner");
            this.boutonSelectNone.addActionListener(this);
            toolbar.add(this.boutonSelectNone);
            GroupLayout layout = new GroupLayout(this.getContentPane());
            this.getContentPane().setLayout((LayoutManager)layout);
            layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)jScrollPane1, -1, 434, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.boutonAnnuler).addPreferredGap(0).add((Component)this.boutonOk))).addContainerGap()).add((Component)toolbar, -1, 458, Short.MAX_VALUE));
            layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)toolbar, -2, 25, -2).addPreferredGap(0).add((Component)jScrollPane1, -1, 365, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.boutonOk).add((Component)this.boutonAnnuler)).addContainerGap()));
            this.pack();
            this.setSize(500, 400);
            this.setLocationRelativeTo(parent);
            TableColumn col = this.treeTable.getColumnModel().getColumn(1);
            col.setPreferredWidth(75);
            col.setMinWidth(60);
            col = this.treeTable.getColumnModel().getColumn(0);
            col.setMinWidth(200);
            col.setPreferredWidth(380);
        }

        public void actionPerformed(ActionEvent ae) {
            Object cmd = ae.getSource();
            if (cmd.equals(this.boutonExpandAll)) {
                this.treeTable.expandAll();
            } else if (cmd.equals(this.boutonCollapseAll)) {
                this.treeTable.collapseAll();
            } else if (cmd.equals(this.boutonSelectAll)) {
                this.importFileTreeTableModel.selectAll();
            } else if (cmd.equals(this.boutonSelectNone)) {
                this.importFileTreeTableModel.selectNone();
            } else if (cmd.equals(this.boutonOk)) {
                ImportDialog.this.resultList = this.importFileTreeTableModel.getFilesToImportList();
                this.setVisible(false);
            } else if (cmd.equals(this.boutonAnnuler)) {
                this.setVisible(false);
            }
        }
    }
}

