/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui.export;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.StartUrl;
import fr.gouv.finances.cp.utils.ui.InterruptibleInfiniteGlassPane;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.EtatModel;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import fr.gouv.finances.cp.xemelios.data.DataResultSet;
import fr.gouv.finances.cp.xemelios.export.ConfigModel;
import fr.gouv.finances.cp.xemelios.export.Exporter;
import fr.gouv.finances.cp.xemelios.ui.export.EditConfig;
import fr.gouv.finances.cp.xemelios.ui.resulttable.EtatResultTableModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DlgSearchConfig
extends JDialog {
    private static Logger logger = Logger.getLogger(DlgSearchConfig.class);
    private File _f = null;
    private DlgSearchConfig _sc = this;
    private DocumentsModel docModels;
    private Vector<ConfigModel> listeConfigs;
    private int mode = 0;
    public static final int EXEC_FROM_RECHERCHE = 1;
    public static final int EXEC_FROM_CONF = 2;
    public static final int EXEC_FROM_MENU = 3;
    private EtatResultTableModel ertm;
    private DocumentModel dm;
    private ElementModel em;
    private Pair coll = null;
    private Pair budg = null;
    private String fic = null;
    private Pair SK1 = null;
    private Pair SK2 = null;
    private int whatToExport = 0;
    private InterruptibleInfiniteGlassPane interruptible;
    private JButton bChanger;
    private JButton bNouveau;
    private JButton bRechercher;
    private JComboBox cbDoc;
    private JComboBox cbEtat;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JTable jTable1;
    private JButton bSupprimer;
    private JButton bExecuter;
    private JButton bFermer;
    private Action escapeAction;

    public DlgSearchConfig(JFrame parent, DocumentsModel dm, int mode) {
        super((Frame)parent, true);
        this.docModels = dm;
        this.setMode(mode);
        this.initComponents();
    }

    private void activateSupModButtons(boolean active) {
        this.bSupprimer.setEnabled(active);
        this.bChanger.setEnabled(active);
    }

    private void activateNewRechButton(boolean active) {
        this.bNouveau.setEnabled(active);
        this.bRechercher.setEnabled(active);
    }

    private void shouldActivateNewRech() {
        if (!((Pair)this.cbEtat.getSelectedItem()).key.equals("RIEN")) {
            this.activateNewRechButton(true);
        } else {
            this.activateNewRechButton(false);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.cbDoc = new JComboBox();
        this.jLabel3 = new JLabel();
        this.cbEtat = new JComboBox();
        this.bRechercher = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.bNouveau = new JButton();
        this.bChanger = new JButton();
        this.bSupprimer = new JButton();
        this.bExecuter = new JButton();
        this.bFermer = new JButton();
        this.setDefaultCloseOperation(3);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Recherche"));
        this.jLabel2.setText("Document");
        Vector<Pair> cbDocItems = this.getDocsIds();
        this.cbDoc.setModel(new DefaultComboBoxModel<Pair>(cbDocItems));
        this.cbDoc.setSelectedIndex(0);
        this.cbDoc.setBorder(BorderFactory.createEtchedBorder());
        this.cbDoc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                String petName = ((Pair)cb.getSelectedItem()).key;
                DlgSearchConfig.this.updateEtats(petName);
                DlgSearchConfig.this.shouldActivateNewRech();
                DlgSearchConfig.this.activateSupModButtons(false);
            }
        });
        this.jLabel3.setText("Etat");
        this.cbEtat.setBorder(BorderFactory.createEtchedBorder());
        this.cbEtat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DlgSearchConfig.this.shouldActivateNewRech();
            }
        });
        this.bRechercher.setText("Rechercher");
        this.bRechercher.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgSearchConfig.this.bRechercherActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jLabel3)).add(39, 39, 39).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.cbDoc, -2, 356, -2).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.cbEtat, -2, 356, -2).addPreferredGap(0, 27, Short.MAX_VALUE).add((Component)this.bRechercher))).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.cbDoc, -2, 24, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.cbEtat, -2, 24, -2).add((Component)this.jLabel3).add((Component)this.bRechercher)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Configurations"));
        this.jScrollPane2.setViewportView(this.jTable1);
        this.jTable1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (DlgSearchConfig.this.mode != 2) {
                        DlgSearchConfig.this.bExecuterActionPerformed(null);
                    } else {
                        DlgSearchConfig.this.bChangerActionPerformed(null);
                    }
                }
            }
        });
        this.jTable1.setSelectionMode(0);
        this.jTable1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (DlgSearchConfig.this.jTable1.getSelectedRow() >= 0) {
                    DlgSearchConfig.this.bSupprimer.setEnabled(true);
                    DlgSearchConfig.this.bChanger.setEnabled(true);
                    if (DlgSearchConfig.this.getMode() != 2) {
                        DlgSearchConfig.this.bExecuter.setEnabled(true);
                    }
                } else {
                    DlgSearchConfig.this.bSupprimer.setEnabled(false);
                    DlgSearchConfig.this.bChanger.setEnabled(false);
                    DlgSearchConfig.this.bExecuter.setEnabled(false);
                }
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane2, -1, 557, Short.MAX_VALUE).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jScrollPane2, -1, 327, Short.MAX_VALUE).addContainerGap()));
        this.bNouveau.setText("Nouveau");
        this.bNouveau.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgSearchConfig.this.bNouveauActionPerformed(evt);
            }
        });
        this.bChanger.setText("Modifier");
        this.bChanger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgSearchConfig.this.bChangerActionPerformed(evt);
            }
        });
        this.bSupprimer.setText("Supprimer");
        this.bSupprimer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgSearchConfig.this.bSupprimerActionPerformed(evt);
            }
        });
        this.bExecuter.setText("Ex\u00e9cuter");
        this.bExecuter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgSearchConfig.this.bExecuterActionPerformed(evt);
            }
        });
        this.bFermer.setText("Fermer");
        this.bFermer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgSearchConfig.this.bFermerActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.bExecuter).addPreferredGap(0).add((Component)this.bSupprimer).addPreferredGap(0).add((Component)this.bChanger).addPreferredGap(0).add((Component)this.bNouveau).addPreferredGap(0, 50, Short.MAX_VALUE).add((Component)this.bFermer))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.bNouveau).add((Component)this.bChanger).add((Component)this.bSupprimer).add((Component)this.bExecuter).add((Component)this.bFermer)).addContainerGap(-1, Short.MAX_VALUE)));
        this.setTitle("Liste des configurations d'export");
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.activateNewRechButton(false);
        this.activateSupModButtons(false);
        if (cbDocItems.size() == 1) {
            String petName = ((Pair)this.cbDoc.getSelectedItem()).key;
            this.updateEtats(petName);
        }
        this.interruptible = new InterruptibleInfiniteGlassPane();
        this.setGlassPane(this.interruptible);
        this.bExecuter.setEnabled(false);
    }

    private void bSupprimerActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, "Etes vous sur de vouloir supprimer cette configuration ?", "Suppression", 0) == 1) {
            return;
        }
        try {
            DataLayerManager.getImplementation().deleteConfigExport(this.listeConfigs.get(this.jTable1.getSelectedRow()));
            this.bRechercherActionPerformed(null);
        }
        catch (Exception e) {
            logger.error((Object)"Erreur lors de la suppression d'une configuration", (Throwable)e);
        }
    }

    private void bFermerActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void bExecuterActionPerformed(ActionEvent evt) {
        if (this.mode == 2) {
            return;
        }
        if (this.jTable1.getSelectedRow() < 0) {
            return;
        }
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toUpperCase().endsWith(".XLS");
            }

            public String getDescription() {
                return "Fichier Excel";
            }
        });
        if (fc.showSaveDialog(this) == 0) {
            int len;
            this._f = fc.getSelectedFile();
            String fileName = this._f.getAbsolutePath();
            if (fileName.substring((len = fileName.length()) - 4).indexOf(46) < 0) {
                fileName = fileName + ".XLS";
                this._f = new File(fileName);
            }
            if (this._f.exists() && JOptionPane.showConfirmDialog(this, fileName + "\nCe fichier existe d\u00e9j\u00e0. Voulez-vous l'\u00e9craser ?", "Ecrasement", 0) == 1) {
                return;
            }
            if (this.mode == 1) {
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            String etatKey = ((Pair)((DlgSearchConfig)DlgSearchConfig.this).cbEtat.getSelectedItem()).key;
                            Exporter ex = new Exporter(DlgSearchConfig.this._f, DlgSearchConfig.this.ertm, DlgSearchConfig.this.dm, etatKey, DlgSearchConfig.this.em, (ConfigModel)DlgSearchConfig.this.listeConfigs.get(DlgSearchConfig.this.jTable1.getSelectedRow()));
                            ex.setParentFrame(DlgSearchConfig.this._sc);
                            DlgSearchConfig.this.interruptible.setThreadToInterrupt(ex);
                            DlgSearchConfig.this.getGlassPane().setVisible(true);
                            ex.execute();
                        }
                    });
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            } else {
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                String docKey = ((Pair)((DlgSearchConfig)DlgSearchConfig.this).cbDoc.getSelectedItem()).key;
                                String etatKey = ((Pair)((DlgSearchConfig)DlgSearchConfig.this).cbEtat.getSelectedItem()).key;
                                DlgSearchConfig.this.em = DlgSearchConfig.this.docModels.getDocumentById(docKey).getEtatById(etatKey).getImportableElement();
                                DataResultSet drs = DataLayerManager.getImplementation().getDataResultSetForExport(DlgSearchConfig.this.whatToExport, DlgSearchConfig.this.em, DlgSearchConfig.this.coll, DlgSearchConfig.this.budg, DlgSearchConfig.this.fic, DlgSearchConfig.this.SK1, DlgSearchConfig.this.SK2);
                                Exporter ex = new Exporter(DlgSearchConfig.this._f, drs, DlgSearchConfig.this.dm, etatKey, DlgSearchConfig.this.em, (ConfigModel)DlgSearchConfig.this.listeConfigs.get(DlgSearchConfig.this.jTable1.getSelectedRow()));
                                ex.setParentFrame(DlgSearchConfig.this._sc);
                                DlgSearchConfig.this.interruptible.setThreadToInterrupt(ex);
                                DlgSearchConfig.this.getGlassPane().setVisible(true);
                                ex.execute();
                            }
                            catch (DataConfigurationException dae) {
                                logger.error((Object)"", (Throwable)dae);
                            }
                            catch (SQLException sqle) {
                                logger.error((Object)"", (Throwable)sqle);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    public void showXLS() {
        try {
            this.getGlassPane().setVisible(false);
            this.setVisible(false);
            StartUrl.startUrl(this._f.getAbsolutePath());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void bRechercherActionPerformed(ActionEvent evt) {
        this.jTable1.removeAll();
        try {
            String docKey = ((Pair)this.cbDoc.getSelectedItem()).key;
            String etatKey = ((Pair)this.cbEtat.getSelectedItem()).key;
            if (!"RIEN".equals(docKey) && !"RIEN".equals(etatKey)) {
                this.listeConfigs = DataLayerManager.getImplementation().getListeConfigsExport(docKey, etatKey);
                this.jTable1.setModel(new ConfigTableModel(this.listeConfigs));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void bChangerActionPerformed(ActionEvent evt) {
        String docKey = ((Pair)this.cbDoc.getSelectedItem()).key;
        String etatKey = ((Pair)this.cbEtat.getSelectedItem()).key;
        DocumentModel dm = this.docModels.getDocumentById(docKey);
        EditConfig ec = new EditConfig((JDialog)this, dm, this.listeConfigs.get(this.jTable1.getSelectedRow()));
        ec.setVisible(true);
    }

    private void bNouveauActionPerformed(ActionEvent evt) {
        String docKey = ((Pair)this.cbDoc.getSelectedItem()).key;
        String etatKey = ((Pair)this.cbEtat.getSelectedItem()).key;
        DocumentModel dm = this.docModels.getDocumentById(docKey);
        EditConfig ec = new EditConfig((JDialog)this, dm, etatKey);
        ec.setVisible(true);
    }

    private Vector<Pair> getDocsIds() {
        Vector<Pair> ret = new Vector<Pair>();
        if (this.docModels.getDocuments().size() > 1) {
            ret.add(new Pair("RIEN", "S\u00e9lectionnez un document"));
        }
        block0: for (DocumentModel dm : this.docModels.getDocuments()) {
            for (EtatModel em : dm.getEtats()) {
                if (!em.isExportable()) continue;
                ret.add(new Pair(dm.getId(), dm.getTitre()));
                continue block0;
            }
        }
        return ret;
    }

    private Vector<Pair> getEtatsIds(String docID) {
        Vector<Pair> ret = new Vector<Pair>();
        if (this.docModels.getDocumentById(docID).getEtats().size() > 1) {
            ret.add(new Pair("RIEN", "S\u00e9lectionnez un \u00e9tat"));
        }
        for (EtatModel em : this.docModels.getDocumentById(docID).getEtats()) {
            if (!em.isExportable()) continue;
            ret.add(new Pair(em.getId(), em.getTitre()));
        }
        return ret;
    }

    private void updateEtats(String docID) {
        if (!"RIEN".equals(docID)) {
            Vector<Pair> cbEtatIds = this.getEtatsIds(docID);
            this.cbEtat.setModel(new DefaultComboBoxModel<Pair>(cbEtatIds));
            if (cbEtatIds.size() == 1) {
                this.cbEtat.setSelectedIndex(0);
                this.bRechercherActionPerformed(null);
                this.activateNewRechButton(true);
            }
        } else {
            this.cbEtat.setModel(new DefaultComboBoxModel());
        }
    }

    @Override
    protected JRootPane createRootPane() {
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JRootPane rp = new JRootPane();
        this.escapeAction = new AbstractAction("Fermer"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                DlgSearchConfig.this.setVisible(false);
            }
        };
        rp.registerKeyboardAction(this.escapeAction, "TOTOTOTO", ks, 2);
        return rp;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public ConfigModel getConfigSelected() {
        return this.listeConfigs.get(this.jTable1.getSelectedRow());
    }

    public EtatResultTableModel getErtm() {
        return this.ertm;
    }

    public void setErtm(EtatResultTableModel ertm) {
        this.ertm = ertm;
    }

    public ElementModel getEm() {
        return this.em;
    }

    public void setEm(ElementModel em) {
        this.em = em;
    }

    public DocumentModel getDm() {
        return this.dm;
    }

    public void setDm(DocumentModel dm) {
        this.dm = dm;
    }

    public static boolean docHasEtatToExport(DocumentsModel dms) {
        if (dms.getDocuments().size() < 1) {
            return false;
        }
        for (DocumentModel dm : dms.getDocuments()) {
            for (EtatModel em : dm.getEtats()) {
                if (!em.isExportable()) continue;
                return true;
            }
        }
        return false;
    }

    public Pair getBudg() {
        return this.budg;
    }

    public void setBudg(Pair budg) {
        this.budg = budg;
    }

    public Pair getColl() {
        return this.coll;
    }

    public void setColl(Pair coll) {
        this.coll = coll;
    }

    public void setWhatToExport(int whatToExport) {
        this.whatToExport = whatToExport;
    }

    public void setFic(String fic) {
        this.fic = fic;
    }

    public Pair getSK1() {
        return this.SK1;
    }

    public void setSK1(Pair sk1) {
        this.SK1 = sk1;
    }

    public Pair getSK2() {
        return this.SK2;
    }

    public void setSK2(Pair sk2) {
        this.SK2 = sk2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Code", "Libell\u00e9", "Cr\u00e9ateur", "Date cr\u00e9ation"};
        private Vector<String[]> data = new Vector();

        public ConfigTableModel(Vector<ConfigModel> d) {
            boolean row = false;
            int column = 0;
            for (ConfigModel cm : d) {
                column = 0;
                String[] tmp = new String[4];
                tmp[column++] = cm.getCode();
                tmp[column++] = cm.getLibelle();
                tmp[column++] = cm.getOwner();
                tmp[column++] = cm.getDateCreation();
                this.data.add(tmp);
            }
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data != null ? this.data.size() : 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data != null ? this.data.get(rowIndex)[columnIndex] : "";
        }
    }
}

