/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import fr.gouv.finances.cp.utils.IoUtils;
import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.utils.ui.IhmFactory;
import fr.gouv.finances.cp.utils.ui.VerticalFlowLayout;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.xemelios.auth.XemeliosUser;
import fr.gouv.finances.cp.xemelios.common.DematTransform;
import fr.gouv.finances.cp.xemelios.common.ToolException;
import fr.gouv.finances.cp.xemelios.common.config.CritereModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.EtatModel;
import fr.gouv.finances.cp.xemelios.common.config.PluginModel;
import fr.gouv.finances.cp.xemelios.common.config.RechercheModel;
import fr.gouv.finances.cp.xemelios.common.config.SavedRequestsModel;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import fr.gouv.finances.cp.xemelios.ui.CriteriaViewer;
import fr.gouv.finances.cp.xemelios.ui.DlgEditEnvironment;
import fr.gouv.finances.cp.xemelios.ui.DlgSelectRequest;
import fr.gouv.finances.cp.xemelios.ui.ListDisplayable;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.cp.xemelios.ui.export.DlgSearchConfig;
import fr.gouv.finances.cp.xemelios.ui.resulttable.EtatResultTableModel;
import fr.gouv.finances.cp.xemelios.ui.resulttable.PageSeeker;
import fr.gouv.finances.cp.xemelios.ui.search.SearchThread;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.xml.sax.SAXException;

public class SearchWindow
extends JInternalFrame {
    private static final long serialVersionUID = 3257002159676469814L;
    private static Logger logger = Logger.getLogger(SearchWindow.class);
    private JPanel scroller;
    private JScrollPane sc;
    private JPanel mainPane = null;
    private JComboBox colls;
    private JComboBox budgets;
    private JTable table = null;
    private JSplitPane splitter = null;
    private JButton pbSearch;
    private JButton pbValidateHeader;
    private JButton pbSearchBackground;
    private JButton pbClear;
    private JButton pbSaveRequest;
    private PageSeeker ps = null;
    private JTextField bottomField;
    public MainWindow parentFrame;
    private ElementModel em;
    private Vector<Pair> collectivites = null;
    private Pair currentBudget;
    private Pair currentCollectivite;
    private String title;
    private ActionListener lineAdder;
    private Vector<CriteriaViewer> criterias;
    private boolean canExport = false;
    private static int frameCount = 1;
    private int rank = 0;
    private PluginModel plugin;
    private DocumentModel dm = null;

    public SearchWindow(MainWindow pf, DocumentModel dm, ElementModel em) throws ToolException {
        super("Recherche - " + em.getTitre() + " <" + frameCount + ">", true, true, true);
        this.parentFrame = pf;
        this.rank = frameCount;
        this.title = "Recherche - " + em.getTitre() + " <" + frameCount++ + ">";
        this.em = em;
        this.dm = dm;
        this.initComponents();
        em.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("mode".equals(evt.getPropertyName())) {
                    SearchWindow.this.clearAll();
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    protected void initComponents() throws ToolException {
        try {
            Vector<Pair> tmpColls = DataLayerManager.getImplementation().getCollectivites(this.dm);
            this.collectivites = new Vector();
            XemeliosUser user = this.getParentFrame().getConnectedUser();
            for (Pair p : tmpColls) {
                if (!user.isAllowedTo(p.key, 16)) continue;
                this.collectivites.add(p);
            }
        }
        catch (Exception ex) {
            Container comp2;
            for (comp2 = this; comp2 != null && !(comp2 instanceof JFrame); comp2 = comp2.getParent()) {
            }
            if (comp2 != null) {
                new DisplayExceptionDlg((Frame)((JFrame)comp2), (Throwable)ex);
            } else {
                ex.printStackTrace();
            }
            throw new ToolException(8);
        }
        this.mainPane = new JPanel(new BorderLayout());
        IhmFactory iF = IhmFactory.newInstance();
        this.pbValidateHeader = new JButton(iF.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/add.png"));
        this.pbValidateHeader.setToolTipText("Ajouter un crit\u00e8re de recherche");
        this.lineAdder = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchWindow.this.addLine();
            }
        };
        this.pbValidateHeader.addActionListener(this.lineAdder);
        this.pbSearch = new JButton((Icon)iF.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/search.png")){
            private static final long serialVersionUID = 1L;

            public void fireActionPerformed(ActionEvent event) {
                SearchWindow.this.parentFrame.startWaiter();
                super.fireActionPerformed(event);
            }
        };
        this.pbSearch.setToolTipText("Chercher");
        this.pbSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchWindow.this.search();
            }
        });
        this.pbSearch.setEnabled(false);
        this.colls = new JComboBox<Pair>(this.collectivites);
        this.budgets = new JComboBox();
        this.colls.setSelectedIndex(0);
        this.colls.addActionListener(new ActionListener(){

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(ActionEvent evt) {
                Pair bd = (Pair)SearchWindow.this.colls.getSelectedItem();
                Vector<Object> data = new Vector();
                try {
                    data = DataLayerManager.getImplementation().getBudgets(SearchWindow.this.dm, bd);
                }
                catch (Exception ex) {
                    void var5_7;
                    SearchWindow searchWindow = SearchWindow.this;
                    while (var5_7 != null && !(var5_7 instanceof JFrame)) {
                        Container container = var5_7.getParent();
                    }
                    if (var5_7 != null) {
                        new DisplayExceptionDlg((Frame)((JFrame)var5_7), (Throwable)ex);
                    }
                    ex.printStackTrace();
                }
                SearchWindow.this.budgets.removeAllItems();
                for (Pair pair : data) {
                    SearchWindow.this.budgets.addItem(pair);
                }
                if (data.size() > 0) {
                    SearchWindow.this.budgets.setSelectedIndex(0);
                }
            }
        });
        this.criterias = new Vector();
        this.pbSaveRequest = new JButton(iF.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/save.png"));
        this.pbSaveRequest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchWindow.this.saveRequest();
            }
        });
        this.pbSaveRequest.setToolTipText("Enregistrer les crit\u00e8res de recherche");
        JButton pbOpenRequest = new JButton(iF.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/openRequest.png"));
        pbOpenRequest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchWindow.this.openRequest();
            }
        });
        pbOpenRequest.setToolTipText("Ouvrir une recherche pr\u00e9-enregistr\u00e9e");
        this.pbSearchBackground = new JButton(iF.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/search_bg.png"));
        this.pbSearchBackground.setToolTipText("Rechercher en t\u00e2che de fond");
        this.pbSearchBackground.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchWindow.this.searchBackground();
            }
        });
        this.pbSearchBackground.setEnabled(false);
        JToolBar tb = new JToolBar();
        tb.setRollover(true);
        tb.setFloatable(false);
        tb.add(iF.newLabel("Collectivit\u00e9 ", "normal"));
        tb.add(this.colls);
        tb.addSeparator();
        tb.add(iF.newLabel("Code Budget ", "normal"));
        tb.add(this.budgets);
        this.mainPane.add((Component)tb, "First");
        tb = new JToolBar(1);
        tb.setRollover(true);
        tb.add(this.pbValidateHeader);
        tb.add(this.pbSearch);
        tb.add(this.pbSearchBackground);
        this.pbClear = new JButton(iF.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/clearAll.png"));
        tb.add(this.pbClear);
        if (this.em.getParent() == null) {
            throw new RuntimeException("elementModel.getParent() is null");
        }
        if (this.em.getParent().getParent() == null) {
            throw new RuntimeException("etatModel.getParent() is null");
        }
        if (this.em.getParent().getParent().getReferentielXsltFile() != null) {
            tb.addSeparator();
            JButton pbShowReferentiel = new JButton(iF.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/referentiel.png"));
            tb.add(pbShowReferentiel);
            pbShowReferentiel.setToolTipText("Afficher la nomenclature");
            pbShowReferentiel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SearchWindow.this.showReferentiel();
                }
            });
        }
        tb.addSeparator();
        tb.add(this.pbSaveRequest);
        tb.add(pbOpenRequest);
        tb.addSeparator();
        JButton pbEnvironment = new JButton(iF.getIconFromResource("fr/gouv/finances/cp/xemelios/ui/resources/environment.png"));
        tb.add(pbEnvironment);
        pbEnvironment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgEditEnvironment dee = new DlgEditEnvironment((Frame)SearchWindow.this.getParentFrame(), SearchWindow.this.em, 2);
                dee.setVisible(true);
            }
        });
        pbEnvironment.setToolTipText("Modifier les param\u00e8tres d'environnement de recherche.");
        this.mainPane.add((Component)tb, "Before");
        this.pbClear.setEnabled(false);
        this.pbClear.setToolTipText("Supprimer tous les crit\u00e8res");
        this.pbClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchWindow.this.clearAll();
                SearchWindow.this.pbSaveRequest.setEnabled(true);
            }
        });
        this.scroller = new JPanel(new VerticalFlowLayout(0, 0, 0));
        this.sc = new JScrollPane(this.scroller);
        this.validateHeader();
        this.sc.setVerticalScrollBarPolicy(22);
        this.splitter = new JSplitPane(0);
        this.splitter.setLeftComponent(this.sc);
        this.splitter.setRightComponent(new JPanel());
        this.mainPane.add((Component)this.splitter, "Center");
        JPanel bottomPane = new JPanel(new BorderLayout());
        this.bottomField = new JTextField();
        this.bottomField.setEditable(false);
        this.bottomField.setBackground(bottomPane.getBackground());
        this.bottomField.setBorder(BorderFactory.createEmptyBorder());
        this.bottomField.setColumns(50);
        bottomPane.add((Component)this.bottomField, "West");
        this.ps = new PageSeeker(this);
        bottomPane.add((Component)this.ps, "East");
        this.mainPane.add((Component)bottomPane, "South");
        this.getRootPane().setDefaultButton(this.pbSearch);
        InternalFrameAdapter adapter = new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
                SearchWindow.this.clearResources();
                SearchWindow.this.notifyParentStateChanged();
            }

            public void internalFrameIconified(InternalFrameEvent e) {
                SearchWindow.this.setTitle(SearchWindow.this.em.getTitre() + " <" + SearchWindow.this.rank + ">");
                SearchWindow.this.notifyParentStateChanged();
            }

            public void internalFrameDeiconified(InternalFrameEvent e) {
                SearchWindow.this.setTitle(SearchWindow.this.title);
                SearchWindow.this.notifyParentStateChanged();
            }

            public void internalFrameActivated(InternalFrameEvent e) {
                SearchWindow.this.moveToFront();
                SearchWindow.this.notifyParentStateChanged();
            }
        };
        this.addInternalFrameListener(adapter);
        this.setContentPane(this.mainPane);
        this.setIconifiable(true);
        Vector<Object> data = new Vector();
        try {
            data = DataLayerManager.getImplementation().getBudgets(this.dm, this.collectivites.get(0));
        }
        catch (Exception ex) {
            void var9_13;
            SearchWindow searchWindow = this;
            while (var9_13 != null && !(var9_13 instanceof JFrame)) {
                Container container = var9_13.getParent();
            }
            if (var9_13 != null) {
                new DisplayExceptionDlg((Frame)((JFrame)var9_13), (Throwable)ex);
            }
            ex.printStackTrace();
        }
        this.budgets.removeAllItems();
        for (Pair pair : data) {
            this.budgets.addItem(pair);
        }
        if (data.size() > 0) {
            this.budgets.setSelectedIndex(0);
        }
        this.validateHeader();
        this.budgets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchWindow.this.clearAll();
                SearchWindow.this.validateHeader();
            }
        });
        this.pack();
        this.splitter.setDividerLocation(100);
    }

    protected void clearResources() {
        this.em = null;
        this.dm = null;
        if (this.table != null) {
            JXTable latable = (JXTable)this.table;
            EtatResultTableModel etrm = (EtatResultTableModel)latable.getModel();
            etrm.getResultSet().clear();
            etrm.dispose();
        }
    }

    protected void validateHeader() {
        this.currentBudget = (Pair)this.budgets.getSelectedItem();
        this.currentCollectivite = (Pair)this.colls.getSelectedItem();
        if (this.currentBudget != null && this.currentCollectivite != null) {
            this.pbSearch.setEnabled(true);
            this.pbSearchBackground.setEnabled(true);
            this.addLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search() {
        SearchThread searcher = null;
        this.setSearchEnabled(false);
        try {
            this.setCursor(new Cursor(3));
            searcher = new SearchThread(this, this.em, this.currentCollectivite, this.currentBudget, this.criterias, this.plugin);
            SwingUtilities.invokeLater(searcher);
        }
        catch (OutOfMemoryError oomErr) {
            searcher.exceptionDuringProcess = oomErr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchBackground() {
        SearchThread searcher = null;
        this.setSearchEnabled(false);
        try {
            searcher = new SearchThread(this, this.em, this.currentCollectivite, this.currentBudget, this.criterias, this.plugin, true);
            SwingUtilities.invokeLater(searcher);
        }
        catch (OutOfMemoryError oomErr) {
            searcher.exceptionDuringProcess = oomErr;
        }
    }

    public CriteriaViewer addLine() {
        CriteriaViewer cv = new CriteriaViewer(this, this.em, this.currentCollectivite, this.currentBudget, this.criterias.size() == 0);
        this.criterias.add(cv);
        if (this.pbClear != null) {
            this.pbClear.setEnabled(true);
            this.setSearchEnabled(true);
        }
        if (this.scroller != null) {
            this.scroller.add(cv);
        }
        if (this.isVisible()) {
            cv.setVisible(true);
            this.scroller.validate();
            Rectangle rect = cv.getBounds();
            Point p = new Point(0, (int)((double)this.criterias.size() * rect.getHeight()) - 1);
            this.sc.getViewport().setViewPosition(p);
            this.repaintCriterias();
        }
        return cv;
    }

    protected CriteriaViewer addLineNoCriteria() {
        CriteriaViewer cv = new CriteriaViewer(this, this.em, this.currentCollectivite, this.currentBudget, true, true);
        this.criterias.add(cv);
        if (this.pbClear != null) {
            this.pbClear.setEnabled(true);
            this.setSearchEnabled(true);
        }
        if (this.scroller != null) {
            this.scroller.add(cv);
        }
        if (this.isVisible()) {
            cv.setVisible(true);
            this.splitter.setDividerLocation(-1);
            this.repaintCriterias();
        }
        return cv;
    }

    protected void removeLine(CriteriaViewer whichOne) {
        this.scroller.remove(whichOne);
        this.criterias.remove(whichOne);
        if (this.criterias.size() == 0) {
            this.setSearchEnabled(false);
        }
        this.repaintCriterias();
    }

    protected void repaintCriterias() {
        if (!this.isVisible()) {
            return;
        }
        this.scroller.getSize();
        this.sc.setViewportView(this.scroller);
        this.getDesktopPane().getDesktopManager().beginResizingFrame(this, 0);
        Rectangle r = this.getBounds();
        this.getDesktopPane().getDesktopManager().resizeFrame(this, r.x, r.y, r.width, r.height);
        this.getDesktopPane().getDesktopManager().endResizingFrame(this);
    }

    public void exportCSV() {
        if (!this.canExport()) {
            return;
        }
        EtatResultTableModel ertm = (EtatResultTableModel)this.table.getModel();
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toUpperCase().endsWith(".CSV");
            }

            public String getDescription() {
                return "Fichier CSV";
            }
        });
        ExportOptionPane eop = new ExportOptionPane();
        fc.setAccessory(eop);
        if (fc.showSaveDialog(this) == 0) {
            int len;
            File f = fc.getSelectedFile();
            String fileName = f.getAbsolutePath();
            if (fileName.substring((len = fileName.length()) - 4).indexOf(46) < 0) {
                fileName = fileName + ".CSV";
                f = new File(fileName);
            }
            if (f.exists() && JOptionPane.showConfirmDialog(this.getParentFrame(), fileName + "\nCe fichier existe d\u00e9j\u00e0. Voulez-vous l'\u00e9craser ?", "Ecrasement", 0) == 1) {
                return;
            }
            MainWindow.fieldSeparator = eop.getSeparator();
            String out = null;
            int[] selectedRows = this.table.getSelectedRows();
            out = ertm.getCsvBuffer(MainWindow.fieldSeparator, eop.getExportAll(), selectedRows);
            try {
                FileWriter fw = new FileWriter(f);
                fw.write(out);
                fw.flush();
                fw.close();
            }
            catch (IOException ioEx) {
                Container comp;
                for (comp = this; comp != null && !(comp instanceof JFrame); comp = comp.getParent()) {
                }
                new DisplayExceptionDlg((Frame)((JFrame)comp), (Throwable)ioEx);
            }
        }
    }

    public void exportXLS() {
        if (!this.canExport()) {
            return;
        }
        EtatResultTableModel ertm = (EtatResultTableModel)this.table.getModel();
        DocumentsModel dmsTmp = new DocumentsModel("documents");
        DocumentModel dmTmp = this.dm.clone();
        HashMap<String, EtatModel> hTmp = dmTmp.getHEtats();
        HashMap<String, EtatModel> hTmp2 = new HashMap<String, EtatModel>();
        Vector<EtatModel> vTmp2 = new Vector<EtatModel>();
        for (String k : hTmp.keySet()) {
            EtatModel emTmp = hTmp.get(k);
            if (emTmp.getElementById(this.em.getId()) == null) continue;
            hTmp2.put(emTmp.getId(), emTmp);
            vTmp2.add(emTmp);
            dmTmp.setVEtats(vTmp2);
            dmTmp.setHEtats(hTmp2);
            break;
        }
        try {
            dmsTmp.addChild((XmlMarshallable)dmTmp, "document");
        }
        catch (Throwable t) {
            // empty catch block
        }
        DlgSearchConfig sc = new DlgSearchConfig(this.getParentFrame(), dmsTmp, 1);
        sc.setErtm(ertm);
        sc.setEm(this.em);
        sc.setDm(this.dm);
        sc.setVisible(true);
    }

    public boolean canExport() {
        return this.canExport && !this.isIcon();
    }

    public void notifyParentStateChanged() {
        MainWindow mw = this.parentFrame;
        mw.innerWindowChanged();
        System.gc();
    }

    public void clearAll() {
        this.plugin = null;
        this.pbValidateHeader.setEnabled(true);
        if (this.criterias == null) {
            return;
        }
        while (this.criterias.size() > 0) {
            this.removeLine(this.criterias.elementAt(this.criterias.size() - 1));
        }
    }

    protected void showReferentiel() {
        try {
            String sXmlData = DataLayerManager.getImplementation().getRepository(this.dm, this.currentCollectivite, this.currentBudget);
            String encoding = IoUtils.getEncoding(sXmlData);
            InputStream is = IoUtils.getInputStream(this.dm.getBaseDirectory() + "/" + this.dm.getReferentielXsltFile());
            InputStream htmlStream = DematTransform.transform(new ByteArrayInputStream(sXmlData.getBytes(encoding)), is, encoding);
            this.parentFrame.displayHtmlStream(htmlStream, this.em.getParent(), this.getDesktopPane());
        }
        catch (Exception ex) {
            new DisplayExceptionDlg((Frame)this.parentFrame, (Throwable)ex);
        }
    }

    private void saveRequest() {
        String requestName = this.getRequestName();
        if (requestName == null) {
            return;
        }
        RechercheModel rm = new RechercheModel("recherche", requestName);
        for (CriteriaViewer cv : this.criterias) {
            try {
                rm.addChild(cv.getXmlMarshallable(), "critere");
                this.parentFrame.getSavedRequest(this.em).add(rm);
            }
            catch (SAXException ignore) {
                ignore.printStackTrace();
            }
        }
    }

    private void openRequest() {
        String persistence = null;
        try {
            persistence = DataLayerManager.getImplementation().getLayerName();
        }
        catch (Throwable t) {
            // empty catch block
        }
        SavedRequestsModel srm = this.parentFrame.getSavedRequest(this.em);
        TreeSet<Comparable> data = new TreeSet<Comparable>();
        data.addAll(srm.getRecherches());
        Vector<PluginModel> plugins = this.em.getPlugins();
        for (PluginModel pm : plugins) {
            if (!pm.getPluginType().equals("search") && !pm.getPluginType().equals("export") || !pm.isAvailableFor(persistence)) continue;
            data.add(pm);
        }
        Vector<Comparable> vData = new Vector<Comparable>();
        vData.addAll(data);
        DlgSelectRequest dsr = new DlgSelectRequest(this.parentFrame, vData, this.em);
        if (dsr.run()) {
            ListDisplayable xm = (ListDisplayable)dsr.getSelectedItem();
            if (xm instanceof RechercheModel) {
                RechercheModel rm = (RechercheModel)xm;
                this.clearAll();
                for (CritereModel cm : rm.getCriteres()) {
                    CriteriaViewer cv = this.addLine();
                    cv.changeCritereModel(cm);
                }
                this.pbSaveRequest.setEnabled(true);
            } else if (xm instanceof PluginModel) {
                PluginModel pm = (PluginModel)xm;
                this.clearAll();
                this.plugin = pm.clone();
                this.pbValidateHeader.setEnabled(false);
                for (CritereModel cm : pm.getCriteres()) {
                    CriteriaViewer cv = this.addLineNoCriteria();
                    cv.changeCritereModel(cm.clone());
                }
                this.pbSaveRequest.setEnabled(false);
            }
        }
    }

    public void setSearchEnabled(boolean enableIt) {
        this.pbSearch.setEnabled(enableIt);
        this.pbSearchBackground.setEnabled(enableIt);
    }

    public String getRequestName() {
        return JOptionPane.showInputDialog(this, "Veuillez saisir un nom pour cette recherche :", "Valeur par d\u00e9faut");
    }

    public void redisplayTitle() {
        this.setTitle(this.title);
    }

    public void setBottomText(String txt) {
        this.bottomField.setText(txt);
    }

    public void setCanExport(boolean how) {
        this.canExport = how;
    }

    public MainWindow getParentFrame() {
        return this.parentFrame;
    }

    public void setTable(JTable table) {
        this.table = table;
    }

    public JTable getTable() {
        return this.table;
    }

    public JSplitPane getSplitter() {
        return this.splitter;
    }

    public PageSeeker getPageSeeker() {
        return this.ps;
    }

    public ElementModel getELementModel() {
        return this.em;
    }

    public Pair getCurrentCollectivite() {
        return this.currentCollectivite;
    }

    public Pair getCurrentBudget() {
        return this.currentBudget;
    }

    public PluginModel getPluginModel() {
        return this.plugin;
    }

    public DocumentModel getDocumentModel() {
        return this.dm;
    }

    public void setVisible(boolean visible) {
        Iterator<PropertyChangeListener> it;
        if (!visible && this.em != null && (it = this.em.getPropertyListeners()) != null) {
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
        }
        super.setVisible(visible);
    }

    public void setCollectivite(Pair collectivite) {
        this.colls.setSelectedItem(collectivite);
    }

    public void setBudget(Pair budget) {
        this.budgets.setSelectedItem(budget);
    }

    public boolean isEtatExporttable() {
        if (this.dm == null) {
            return false;
        }
        for (EtatModel etat : this.dm.getEtats()) {
            ElementModel elem = etat.getElementById(this.em.getId());
            if (elem == null || !etat.isExportable()) continue;
            return true;
        }
        return false;
    }

    public static class ExportOptionPaneXLS
    extends JPanel {
        private static final long serialVersionUID = 1L;
        boolean allSelection = false;
        private JRadioButton rbAll;
        private JRadioButton rbSelection;

        public ExportOptionPaneXLS() {
            this.initComponents();
        }

        private void initComponents() {
            FormLayout fl = new FormLayout("1dlu,pref,1dlu", "1dlu,pref,1dlu,pref,4dlu,pref,1dlu,pref,1dlu");
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(fl, (JPanel)this);
            IhmFactory iF = IhmFactory.newInstance();
            int col = 2;
            int start = 2;
            this.rbSelection = new JRadioButton("S\u00e9l\u00e9ction");
            pb.add((Component)this.rbSelection, cc.xy(col, 4 + start));
            this.rbAll = new JRadioButton("Tout");
            pb.add((Component)this.rbAll, cc.xy(col, 6 + start));
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.rbSelection);
            bg.add(this.rbAll);
            this.rbAll.setSelected(true);
            this.setVisible(true);
        }

        public boolean getExportAll() {
            return this.rbAll.isSelected();
        }
    }

    private class ExportOptionPane
    extends JPanel {
        private static final long serialVersionUID = 1L;
        boolean allSelection = false;
        String separator = MainWindow.fieldSeparator;
        private JTextField fldSep;
        private JRadioButton rbAll;
        private JRadioButton rbSelection;

        public ExportOptionPane() {
            this.initComponents();
        }

        private void initComponents() {
            FormLayout fl = new FormLayout("1dlu,pref,1dlu", "1dlu,pref,1dlu,pref,4dlu,pref,1dlu,pref,1dlu");
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(fl, (JPanel)this);
            IhmFactory iF = IhmFactory.newInstance();
            int col = 2;
            int start = 2;
            pb.add((Component)iF.newLabel("S\u00e9parateur"), cc.xy(col, 0 + start));
            this.fldSep = new JTextField(this.separator);
            pb.add((Component)this.fldSep, cc.xy(col, 2 + start));
            this.rbSelection = new JRadioButton("S\u00e9l\u00e9ction");
            pb.add((Component)this.rbSelection, cc.xy(col, 4 + start));
            this.rbAll = new JRadioButton("Tout");
            pb.add((Component)this.rbAll, cc.xy(col, 6 + start));
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.rbSelection);
            bg.add(this.rbAll);
            this.rbAll.setSelected(true);
            this.setVisible(true);
        }

        public String getSeparator() {
            String sep = this.fldSep.getText();
            if ("\\t".equals(sep)) {
                sep = "\t";
            }
            return sep;
        }

        public boolean getExportAll() {
            return this.rbAll.isSelected();
        }
    }

    public static class DisplayErrorSearchThread
    implements Runnable {
        private SearchWindow sw;
        private Object obj;
        private ToolException tEx;

        public DisplayErrorSearchThread(SearchWindow sw, ToolException tEx, Object objToFocus) {
            this.sw = sw;
            this.obj = objToFocus;
            this.tEx = tEx;
        }

        public void run() {
            JOptionPane.showMessageDialog(this.sw, this.tEx.getMessage(), "", 2);
            this.sw.setSearchEnabled(true);
            if (this.obj != null) {
                ((CriteriaViewer)this.obj).doFocusOnError();
            }
        }
    }
}

