/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.cp.xemelios.ui.DatabaseTreeDataDonnee;
import fr.gouv.finances.cp.xemelios.ui.DatabaseTreeDataFichier;
import fr.gouv.finances.cp.xemelios.ui.DlgChooseDocuments;
import fr.gouv.finances.cp.xemelios.ui.DlgCleanDatabaseOld;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.cp.xemelios.ui.PanelChooseDatabaseDonnees;
import fr.gouv.finances.cp.xemelios.ui.PanelChooseDatabaseFichier;
import fr.gouv.finances.cp.xemelios.ui.export.DlgSearchConfig;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class DlgExportAll
extends DlgChooseDocuments {
    private static Logger logger = Logger.getLogger(DlgCleanDatabaseOld.class);
    private Action escapeAction;

    public DlgExportAll(Frame parent, boolean modal, DocumentsModel _dm) {
        super(parent, modal, _dm, false);
        this.setTitle("Exporter");
        this.setBActionLibelle("Exporter");
        ((PanelChooseDatabaseFichier)this.getJTabbedPane1().getComponent(1)).setMode(1);
    }

    protected void doAction(ActionEvent evt) {
        if (this.getJTabbedPane1().getSelectedComponent() instanceof PanelChooseDatabaseDonnees) {
            this.export(((PanelChooseDatabaseDonnees)this.getJTabbedPane1().getSelectedComponent()).getJTree1().getSelectionPath());
        }
        if (this.getJTabbedPane1().getSelectedComponent() instanceof PanelChooseDatabaseFichier) {
            this.exportFichiers();
        }
    }

    protected void exportFichiers() {
        DatabaseTreeDataFichier.Data datas = ((PanelChooseDatabaseFichier)this.getJTabbedPane1().getSelectedComponent()).getData().getData();
        for (DatabaseTreeDataFichier.Data d : datas.getChilds()) {
            this.exportData(d);
        }
    }

    protected void exportData(DatabaseTreeDataFichier.Data datas) {
        if (datas.isSelected()) {
            this.doExportData(datas);
        } else {
            for (DatabaseTreeDataFichier.Data d : datas.getChilds()) {
                this.exportData(d);
            }
        }
    }

    public void doExportData(DatabaseTreeDataFichier.Data d) {
        DocumentModel dm = null;
        Pair collectivite = null;
        Pair budget = null;
        String fichier = null;
        switch (d.getLevel()) {
            case 3: {
                StringTokenizer st = new StringTokenizer(d.getKey(), "|");
                dm = this.getDm().getDocumentById(st.nextToken());
                collectivite = new Pair(st.nextToken(), "");
                budget = new Pair(st.nextToken(), "");
                logger.debug((Object)("exporting BUD : " + dm.getId() + ", " + collectivite.key + ", " + budget.key));
                break;
            }
            case 6: {
                StringTokenizer st = new StringTokenizer(d.getKey(), "|");
                dm = this.getDm().getDocumentById(st.nextToken());
                collectivite = new Pair(st.nextToken(), "");
                budget = new Pair(st.nextToken(), "");
                fichier = st.nextToken();
                logger.debug((Object)("exporting FIC : " + dm.getId() + ", " + collectivite.key + ", " + budget.key + ", " + fichier));
                break;
            }
        }
        if ((d.getLevel() == 3 || d.getLevel() == 6) && JOptionPane.showConfirmDialog(this, "Etes-vous sur de vouloir exporter ces informations ?\n\nCette op\u00e9ration peut prendre beaucoup de temps\nsi le nombre d'\u00e9l\u00e9ments \u00e0 exporter est important.", "Export", 0) == 0) {
            DocumentsModel dmsTmp = new DocumentsModel("documents");
            try {
                dmsTmp.addChild((XmlMarshallable)dm, "document");
            }
            catch (Throwable t) {
                // empty catch block
            }
            DlgSearchConfig sc = new DlgSearchConfig(MainWindow.getInstance(), dmsTmp, 2);
            sc.setDm(dm);
            sc.setColl(collectivite);
            sc.setBudg(budget);
            sc.setFic(fichier);
            sc.setWhatToExport(d.getLevel());
            sc.setVisible(true);
        }
    }

    protected void export(TreePath tp) {
        if (tp == null) {
            return;
        }
        DatabaseTreeDataDonnee.DataNode node = (DatabaseTreeDataDonnee.DataNode)tp.getLastPathComponent();
        this.export(node);
    }

    protected void export(DatabaseTreeDataDonnee.DataNode dn) {
        DocumentModel dm = null;
        Pair collectivite = null;
        Pair budget = null;
        String fichier = null;
        Pair perso1 = null;
        Pair perso2 = null;
        int level = dn.getType();
        switch (level) {
            case 3: {
                budget = (Pair)dn.getData();
                collectivite = (Pair)dn.getParent().getData();
                dm = (DocumentModel)dn.getParent().getParent().getData();
                break;
            }
            case 4: {
                perso1 = (Pair)dn.getData();
                budget = (Pair)dn.getParent().getData();
                collectivite = (Pair)dn.getParent().getParent().getData();
                dm = (DocumentModel)dn.getParent().getParent().getParent().getData();
                break;
            }
            case 5: {
                perso2 = (Pair)dn.getData();
                perso1 = (Pair)dn.getParent().getData();
                budget = (Pair)dn.getParent().getParent().getData();
                collectivite = (Pair)dn.getParent().getParent().getParent().getData();
                dm = (DocumentModel)dn.getParent().getParent().getParent().getParent().getData();
            }
        }
        if ((level == 3 || level == 4 || level == 5) && JOptionPane.showConfirmDialog(this, "Etes-vous sur de vouloir exporter ces informations ?\n\nCette op\u00e9ration peut prendre beaucoup de temps\nsi le nombre d'\u00e9l\u00e9ments \u00e0 exporter est important.", "Export", 0) == 0) {
            DocumentsModel dmsTmp = new DocumentsModel("documents");
            try {
                dmsTmp.addChild((XmlMarshallable)dm, "document");
            }
            catch (Throwable t) {
                // empty catch block
            }
            DlgSearchConfig sc = new DlgSearchConfig(MainWindow.getInstance(), dmsTmp, 3);
            sc.setDm(dm);
            sc.setColl(collectivite);
            sc.setBudg(budget);
            sc.setFic(fichier);
            sc.setSK1(perso1);
            sc.setSK2(perso2);
            sc.setWhatToExport(level);
            sc.setVisible(true);
        }
    }

    protected JRootPane createRootPane() {
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JRootPane rp = new JRootPane();
        this.escapeAction = new AbstractAction("Fermer"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                DlgExportAll.this.setVisible(false);
            }
        };
        rp.registerKeyboardAction(this.escapeAction, "TOTOTOTO", ks, 2);
        return rp;
    }
}

