/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.utils.ui.InfiniteGlassPane;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.cp.xemelios.data.DataAccessException;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import fr.gouv.finances.cp.xemelios.ui.DatabaseTreeDataDonnee;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.jdesktop.swingworker.SwingWorker;

public class DlgCleanDatabaseOld
extends JDialog {
    private static final long serialVersionUID = 3256721779816151348L;
    private Action escapeAction;
    private DocumentsModel dm;
    private static Logger logger = Logger.getLogger(DlgCleanDatabaseOld.class);
    private JTree tree = null;
    private JButton pbClose = null;
    private JButton pbPurge = null;

    public DlgCleanDatabaseOld(JFrame parent, DocumentsModel dm) {
        super(parent);
        this.dm = dm;
        this.initComponents();
    }

    protected void initComponents() {
        int sepInfo = 2;
        int lineInfo = sepInfo + 2;
        int sepData = lineInfo + 2;
        int treeLine = sepData + 2;
        int buttonLine1 = treeLine + 2;
        JTextArea area = null;
        FormLayout fl = new FormLayout("3dlu,20dlu,140dlu,3dlu", "7dlu,pref,3dlu,pref,7dlu,pref,3dlu,140dlu,7dlu,pref,7dlu");
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(fl);
        this.tree = new JTree(new DatabaseTreeDataDonnee(this.dm));
        pb.addSeparator("Informations", cc.xyw(2, sepInfo, 2));
        area = new JTextArea();
        pb.add((Component)area, cc.xy(3, lineInfo));
        pb.addSeparator("Documents", cc.xyw(2, sepData, 2));
        pb.add((Component)new JScrollPane(this.tree), cc.xy(3, treeLine));
        this.pbPurge = new JButton("Supprimer");
        JPanel bPane = new JPanel(new BorderLayout());
        bPane.add((Component)this.pbPurge, "West");
        bPane.add(Box.createHorizontalGlue(), "Center");
        this.pbClose = new JButton(this.escapeAction);
        bPane.add((Component)this.pbClose, "East");
        pb.add((Component)bPane, cc.xyw(2, buttonLine1, 2));
        area.setEditable(false);
        area.setLineWrap(true);
        area.setRows(3);
        area.setBackground(this.getBackground());
        area.setText("S\u00e9lectionnez dans le graphique ci-dessous\nles \u00e9l\u00e9ments que vous souhaitez purger.");
        this.tree.setScrollsOnExpand(true);
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.getRootPane().setDefaultButton(this.pbClose);
        this.setContentPane(pb.getPanel());
        this.pbPurge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DlgCleanDatabaseOld.this.purge(DlgCleanDatabaseOld.this.tree.getSelectionPath());
            }
        });
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setGlassPane(new InfiniteGlassPane());
        this.setVisible(true);
    }

    protected void purge(TreePath tp) {
        if (tp == null) {
            return;
        }
        DatabaseTreeDataDonnee.DataNode node = (DatabaseTreeDataDonnee.DataNode)tp.getLastPathComponent();
        if (JOptionPane.showConfirmDialog(this, "Etes-vous sur de vouloir supprimer les informations\nconcernant " + node + " d\u00e9finitivement ?\n\nCette op\u00e9ration peut prendre beaucoup de temps\nsi le nombre d'\u00e9l\u00e9ments \u00e0 supprimer est important.", "Suppression", 0) == 0) {
            this.purge(node);
        }
    }

    protected void purge(DatabaseTreeDataDonnee.DataNode dn) {
        int level = dn.getType();
        Runnable process = null;
        switch (level) {
            case 1: {
                final DocumentModel dm = (DocumentModel)dn.getData();
                process = new Runnable(){

                    public void run() {
                        try {
                            DlgCleanDatabaseOld.this.getGlassPane().setVisible(true);
                            DataLayerManager.getImplementation().removeDocumentModel(dm);
                            DlgCleanDatabaseOld.this.getGlassPane().setVisible(false);
                        }
                        catch (DataAccessException daEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabaseOld.this, (Throwable)daEx);
                        }
                        catch (DataConfigurationException dcEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabaseOld.this, (Throwable)dcEx);
                        }
                    }
                };
                break;
            }
            case 2: {
                final DocumentModel dm = (DocumentModel)dn.getParent().getData();
                final Pair collectivite = (Pair)dn.getData();
                process = new Runnable(){

                    public void run() {
                        try {
                            DlgCleanDatabaseOld.this.getGlassPane().setVisible(true);
                            DataLayerManager.getImplementation().removeCollectivite(dm, collectivite);
                            DlgCleanDatabaseOld.this.getGlassPane().setVisible(false);
                        }
                        catch (DataAccessException daEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabaseOld.this, (Throwable)daEx);
                        }
                        catch (DataConfigurationException dcEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabaseOld.this, (Throwable)dcEx);
                        }
                    }
                };
                break;
            }
            case 3: {
                final Pair budget = (Pair)dn.getData();
                final Pair collectivite = (Pair)dn.getParent().getData();
                final DocumentModel dm = (DocumentModel)dn.getParent().getParent().getData();
                process = new Runnable(){

                    public void run() {
                        try {
                            DlgCleanDatabaseOld.this.getGlassPane().setVisible(true);
                            DataLayerManager.getImplementation().removeBudget(dm, collectivite, budget);
                            DlgCleanDatabaseOld.this.getGlassPane().setVisible(false);
                        }
                        catch (DataAccessException daEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabaseOld.this, (Throwable)daEx);
                        }
                        catch (DataConfigurationException dcEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabaseOld.this, (Throwable)dcEx);
                        }
                    }
                };
                break;
            }
            case 4: {
                final Pair perso1 = (Pair)dn.getData();
                final Pair budget = (Pair)dn.getParent().getData();
                final Pair collectivite = (Pair)dn.getParent().getParent().getData();
                final DocumentModel dm = (DocumentModel)dn.getParent().getParent().getParent().getData();
                process = new Runnable(){

                    public void run() {
                        try {
                            DlgCleanDatabaseOld.this.getGlassPane().setVisible(true);
                            DataLayerManager.getImplementation().removeSpecialKey1(dm, collectivite, budget, perso1);
                            DlgCleanDatabaseOld.this.getGlassPane().setVisible(false);
                        }
                        catch (DataAccessException daEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabaseOld.this, (Throwable)daEx);
                        }
                        catch (DataConfigurationException dcEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabaseOld.this, (Throwable)dcEx);
                        }
                    }
                };
                break;
            }
            case 5: {
                final Pair perso2 = (Pair)dn.getData();
                final Pair perso1 = (Pair)dn.getParent().getData();
                final Pair budget = (Pair)dn.getParent().getParent().getData();
                final Pair collectivite = (Pair)dn.getParent().getParent().getParent().getData();
                final DocumentModel dm = (DocumentModel)dn.getParent().getParent().getParent().getParent().getData();
                process = new Runnable(){

                    public void run() {
                        try {
                            DlgCleanDatabaseOld.this.getGlassPane().setVisible(true);
                            DataLayerManager.getImplementation().removeSpecialKey2(dm, collectivite, budget, perso1, perso2);
                            DlgCleanDatabaseOld.this.getGlassPane().setVisible(false);
                        }
                        catch (DataAccessException daEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabaseOld.this, (Throwable)daEx);
                        }
                        catch (DataConfigurationException dcEx) {
                            new DisplayExceptionDlg((Dialog)DlgCleanDatabaseOld.this, (Throwable)dcEx);
                        }
                    }
                };
                break;
            }
        }
        if (process != null) {
            logger.debug((Object)"deleting");
            Deleter deleter = new Deleter(process, this);
            deleter.execute();
        }
    }

    protected JRootPane createRootPane() {
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JRootPane rp = new JRootPane();
        this.escapeAction = new AbstractAction("Fermer"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                DlgCleanDatabaseOld.this.setVisible(false);
            }
        };
        rp.registerKeyboardAction(this.escapeAction, "TOTOTOTO", ks, 2);
        return rp;
    }

    private void enableButtons(boolean activate) {
        this.pbClose.setEnabled(activate);
        this.pbPurge.setEnabled(activate);
    }

    private class Deleter
    extends SwingWorker {
        private Runnable process = null;
        private DlgCleanDatabaseOld dlg = null;

        public Deleter(Runnable process, DlgCleanDatabaseOld dlg) {
            this.process = process;
            this.dlg = dlg;
        }

        public String doInBackground() {
            this.dlg.enableButtons(false);
            this.dlg.setCursor(Cursor.getPredefinedCursor(3));
            this.process.run();
            return null;
        }

        public void done() {
            this.dlg.tree.setModel(new DatabaseTreeDataDonnee(DlgCleanDatabaseOld.this.dm));
            this.dlg.setCursor(Cursor.getDefaultCursor());
            this.dlg.enableButtons(true);
        }
    }
}

