/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import fr.gouv.finances.cp.utils.ui.IhmFactory;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class AskDocumentType
extends JDialog {
    private static final long serialVersionUID = 3546362837975971889L;
    public static final transient String DLG_TITLE = "Type de document";
    private JButton pbOk;
    private JButton pbCancel;
    private boolean ret;
    private Action escapeAction;
    private String fileName;
    private DocumentsModel documentsType;
    private DocumentModel dm;
    private JComboBox cbxTypes;

    public AskDocumentType(JFrame owner, String fileName, DocumentsModel dm) {
        super(owner, DLG_TITLE, true);
        this.fileName = fileName;
        this.documentsType = dm;
        this.initComposants();
    }

    protected void initComposants() {
        int sepInfo = 2;
        int lineInfo = sepInfo + 2;
        int sepData = lineInfo + 2;
        int cbxLine = sepData + 2;
        int buttonLine = cbxLine + 2;
        JTextArea area = null;
        FormLayout fl = new FormLayout("3dlu,20dlu,pref,3dlu,100dlu,3dlu", "7dlu,pref,3dlu,pref,7dlu,pref,3dlu,pref,10dlu,pref,10dlu");
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(fl);
        IhmFactory iF = IhmFactory.newInstance();
        pb.addSeparator("Informations", cc.xyw(2, sepInfo, 4));
        area = new JTextArea();
        pb.add((Component)area, cc.xyw(3, lineInfo, 3));
        pb.addSeparator("Donn\u00e9es", cc.xyw(2, sepData, 4));
        pb.add((Component)iF.newLabel(DLG_TITLE, "normal"), cc.xy(3, cbxLine));
        this.cbxTypes = new JComboBox<DocumentModel>(this.documentsType.getVisibleDocs());
        pb.add(this.cbxTypes, cc.xy(5, cbxLine));
        JPanel bPane = new JPanel(new FlowLayout(1));
        this.pbCancel = new JButton(this.escapeAction);
        this.pbOk = new JButton("Ok");
        bPane.add(this.pbOk);
        bPane.add(this.pbCancel);
        pb.add((Component)bPane, cc.xyw(2, buttonLine, 4));
        JComboBox cbxTmp = new JComboBox();
        this.cbxTypes.setSize(new Dimension(70, (int)cbxTmp.getPreferredSize().getHeight()));
        this.add(pb.getPanel());
        area.setEditable(false);
        area.setLineWrap(true);
        area.setRows(3);
        area.setBackground(this.getBackground());
        area.setColumns(100);
        area.setText("Vous avez choisi d'importer le fichier \n" + this.fileName + "\nDe quel type de document s'agit-il ?");
        this.pbOk.setDefaultCapable(true);
        this.pbOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AskDocumentType.this.dm = (DocumentModel)AskDocumentType.this.cbxTypes.getSelectedItem();
                AskDocumentType.this.ret = true;
                AskDocumentType.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(this.pbOk);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public boolean run() {
        this.setVisible(true);
        return this.ret;
    }

    public DocumentModel getDocumentType() {
        return this.dm;
    }

    protected JRootPane createRootPane() {
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JRootPane rp = new JRootPane();
        this.escapeAction = new AbstractAction("Annuler"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent evt) {
                AskDocumentType.this.ret = false;
                AskDocumentType.this.setVisible(false);
            }
        };
        rp.registerKeyboardAction(this.escapeAction, "TOTOTOTO", ks, 2);
        return rp;
    }

    public void setVisible(boolean b) {
        this.cbxTypes.grabFocus();
        super.setVisible(b);
    }

    static {
        System.out.println(System.getProperty("os.name"));
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            AskDocumentType.setDefaultLookAndFeelDecorated(true);
        }
    }
}

