/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.importers.transformers;

import fr.gouv.finances.cp.utils.Base64;
import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.xemelios.common.DematTransform;
import fr.gouv.finances.cp.xemelios.common.PJRef;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import fr.gouv.finances.cp.xemelios.importers.transformers.EtatTransformeur;
import fr.gouv.finances.cp.xemelios.utils.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PJTransformeur
implements EtatTransformeur {
    private static Logger logger = Logger.getLogger(PJTransformeur.class);
    private int return_code;
    private String xsl_PJPESFACTURE_TO_XMLPESFACTURE = "PES_V2/PES-PJ_PESFACTURE.xsl";

    public void transform(Pair collectivite, String fileEncoding, String xmlVersion, String baseDirectory, String buff) {
        try {
            boolean isFICHIER;
            Node n;
            PJRef pjref = new PJRef();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(buff.getBytes(fileEncoding)));
            pjref.setCollectivite(collectivite.key);
            NodeList tmpNL = doc.getElementsByTagName("IdUnique");
            if (tmpNL.getLength() == 1) {
                n = tmpNL.item(0);
                pjref.setPjName(n.getAttributes().item(0).getNodeValue());
            }
            if ((tmpNL = doc.getElementsByTagName("NomPJ")).getLength() == 1) {
                n = tmpNL.item(0);
                pjref.setFileName(n.getAttributes().item(0).getNodeValue());
            }
            byte[] data = null;
            boolean bl = isFICHIER = doc.getElementsByTagName("Fichier").getLength() > 0;
            if (isFICHIER) {
                tmpNL = doc.getElementsByTagName("Fichier");
                if (tmpNL.getLength() == 1) {
                    Node n2 = tmpNL.item(0);
                    String encoded = n2.getTextContent();
                    GZIPInputStream gzi = new GZIPInputStream(new ByteArrayInputStream(Base64.decode(encoded)));
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] bTmp = new byte[2048];
                    int read = 0;
                    do {
                        if ((read = gzi.read(bTmp)) <= 0) continue;
                        baos.write(bTmp, 0, read);
                    } while (read > 0);
                    baos.flush();
                    baos.close();
                    gzi.close();
                    data = baos.toByteArray();
                }
            } else {
                File f = new File(new File(baseDirectory), this.xsl_PJPESFACTURE_TO_XMLPESFACTURE);
                String xsltBuffer = "";
                try {
                    String xslEncoding = FileUtils.getFileEncoding(f);
                    xsltBuffer = FileUtils.readTextFile(f, xslEncoding);
                }
                catch (IOException ioEx) {
                    logger.error((Object)"in TEtat.getImportXsltBuffer() :", (Throwable)ioEx);
                    this.return_code = 1;
                }
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                InputStream is = DematTransform.transform(new ByteArrayInputStream(buff.getBytes(fileEncoding)), new ByteArrayInputStream(xsltBuffer.replaceAll("##output-encoding##", fileEncoding).replaceAll("##xml-version##", xmlVersion).getBytes()), fileEncoding, parameters);
                StringBuffer newText = new StringBuffer();
                int len = 0;
                byte[] b = new byte[1024];
                do {
                    if ((len = is.read(b)) <= 0) continue;
                    newText.append(new String(b, 0, len));
                } while (len > 0);
                data = newText.toString().getBytes();
            }
            pjref.setData(data);
            pjref.setUncompressedSize(data.length);
            DataLayerManager.getImplementation().importPj(pjref);
            this.return_code = 0;
        }
        catch (Exception e) {
            logger.error((Object)"import PJ", (Throwable)e);
            this.return_code = 1;
        }
        catch (OutOfMemoryError oome) {
            logger.error((Object)"import PJ", (Throwable)oome);
            this.return_code = 1;
        }
    }

    public int getReturnCode() {
        return this.return_code;
    }
}

