/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.importers;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.ui.DisplayExceptionDlg;
import fr.gouv.finances.cp.utils.ui.DlgGetPair;
import fr.gouv.finances.cp.utils.ui.IhmFactory;
import fr.gouv.finances.cp.utils.ui.InfiniteGlassPane;
import fr.gouv.finances.cp.xemelios.common.ToolException;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.data.DataAccessException;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import fr.gouv.finances.cp.xemelios.importers.EtatImporteur;
import fr.gouv.finances.cp.xemelios.importers.ImportServiceProvider;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ImportServiceSwingProvider
implements ImportServiceProvider {
    private static Logger logger = Logger.getLogger(ImportServiceSwingProvider.class);
    private JFrame owner = null;
    private int lastReponse = -1;
    private static final boolean SHOW_CANCEL_BUTTON = true;
    protected ProgressDlg pg;
    private EtatImporteur ei;
    private boolean displayFeedback = true;

    public ImportServiceSwingProvider(JFrame owner, EtatImporteur ei, int nbfiles) {
        this.owner = owner;
        this.ei = ei;
    }

    public Pair getBudget(DocumentModel dm, Pair collectivite, String fileName) throws ToolException {
        Pair ret = null;
        if (ret == null) {
            TreeSet<Pair> existing = new TreeSet<Pair>();
            try {
                existing.addAll(DataLayerManager.getImplementation().getBudgets(dm, collectivite));
            }
            catch (DataConfigurationException e) {
                logger.error((Object)"in getBudget", (Throwable)e);
            }
            catch (DataAccessException e) {
                logger.error((Object)"in getBudget", (Throwable)e);
            }
            Vector<Pair> budgetsDm = dm.getDefaultBudgets();
            existing.addAll(budgetsDm);
            QueryBudget qb = new QueryBudget(fileName, existing, collectivite.libelle);
            if (SwingUtilities.isEventDispatchThread()) {
                qb.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(qb);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            ret = qb.getRet();
            if (ret == null) {
                throw new ToolException("Action interrompue", 1);
            }
        }
        return ret;
    }

    public Pair getCollectivite(DocumentModel dm, String fileName) throws ToolException {
        Pair ret = null;
        if (ret == null) {
            QueryCollectivite qc = new QueryCollectivite(fileName);
            if (SwingUtilities.isEventDispatchThread()) {
                qc.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(qc);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            ret = qc.getRet();
            if (ret == null) {
                throw new ToolException("Import interrompu", 1);
            }
        }
        return ret;
    }

    public boolean getOverwrite(String docName) throws Exception {
        if (this.lastReponse == 0 || this.lastReponse == 1) {
            return this.lastReponse == 0;
        }
        QueryOverwrite qo = new QueryOverwrite(docName);
        int ret = -2;
        if (SwingUtilities.isEventDispatchThread()) {
            qo.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(qo);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        ret = qo.getRet();
        if (ret == -1 || ret == 2) {
            throw new Exception("Annuler");
        }
        this.lastReponse = ret;
        return ret == 0;
    }

    public void displayProgress(final int nbFiles) {
        Runnable code = new Runnable(){

            public void run() {
                logger.debug((Object)this.getClass().getName());
                ImportServiceSwingProvider.this.pg = new ProgressDlg(ImportServiceSwingProvider.this.owner, nbFiles, ImportServiceSwingProvider.this.ei);
                ImportServiceSwingProvider.this.ei.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        String propName = evt.getPropertyName();
                        logger.debug((Object)("property " + propName + " changed"));
                        if ("FILE_NAME".equals(propName)) {
                            ImportServiceSwingProvider.this.pg.setCurrentFile((String)evt.getNewValue());
                        } else if ("progress".equals(propName)) {
                            Integer progress = (Integer)evt.getNewValue();
                            ImportServiceSwingProvider.this.pg.pushCurrentProgress(progress);
                        } else if ("terminated".equals(propName)) {
                            ImportServiceSwingProvider.this.pg.setDefaultCloseOperation(2);
                            ImportServiceSwingProvider.this.pg.setVisible(false);
                        }
                    }
                });
                ImportServiceSwingProvider.this.pg.setVisible(true);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(code);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void pushCurrentProgress(int progress) {
        this.pg.pushCurrentProgress(progress);
    }

    public void displayMessage(String msg, int msgType) {
        if (this.shouldDisplayFeedback()) {
            JOptionPane.showMessageDialog(this.owner, msg, "Import", msgType == 1 ? 1 : 0);
        }
    }

    public void displayException(Throwable t) {
        new DisplayExceptionDlg((Frame)this.owner, t);
    }

    public void startLongWait() {
        this.pg.setUnknownEndded(true);
    }

    public void endLongWait() {
        this.pg.setUnknownEndded(false);
    }

    public void setDisplayFeedback(boolean display) {
        this.displayFeedback = display;
    }

    public boolean shouldDisplayFeedback() {
        return this.displayFeedback;
    }

    public void setCollectivite(Pair p) {
        this.ei.col = p;
    }

    public void setBudget(Pair p) {
        this.ei.bdg = p;
    }

    public final class ProgressDlg
    extends JDialog {
        private static final long serialVersionUID = 1L;
        public static final String DEFAULT_TEXT = "Import en cours : ";
        private boolean shouldContinue;
        private EtatImporteur ei;
        private int nbFilesToImport;
        private int nbFilesImported;
        PaintableProgress globalProgress;
        PaintableProgress currentProgress;
        JTextField currentFileName;

        public ProgressDlg(JFrame owner, int nbFilesToImport, EtatImporteur ei) {
            super((Frame)owner, "Import en cours...");
            this.shouldContinue = true;
            this.ei = null;
            this.nbFilesImported = -1;
            this.nbFilesToImport = nbFilesToImport;
            this.ei = ei;
            this.initComponents(nbFilesToImport);
        }

        protected void initComponents(int nbFilesToImport) {
            IhmFactory iF = IhmFactory.newInstance();
            FormLayout fl = null;
            fl = new FormLayout("3dlu,pref,3dlu", "3dlu,pref,1dlu,pref,5dlu,pref,1dlu,pref,3dlu,pref,3dlu");
            CellConstraints cc = new CellConstraints();
            PanelBuilder pb = new PanelBuilder(fl);
            pb.add((Component)iF.newLabel("Import global", "normal"), cc.xy(2, 2));
            this.globalProgress = new PaintableProgress(0, 100);
            this.globalProgress.setStringPainted(true);
            this.globalProgress.setMaximum(1000);
            pb.add((Component)this.globalProgress, cc.xy(2, 4));
            this.currentFileName = new JTextField(30);
            this.currentFileName.setBackground(this.getBackground());
            this.currentFileName.setBorder(BorderFactory.createEmptyBorder());
            this.currentFileName.setEditable(false);
            this.currentFileName.setText(DEFAULT_TEXT);
            pb.add((Component)this.currentFileName, cc.xy(2, 6));
            this.currentProgress = new PaintableProgress(0, 100);
            this.currentProgress.setStringPainted(true);
            pb.add((Component)this.currentProgress, cc.xy(2, 8));
            JButton pbCancel = new JButton("Annuler");
            pbCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ProgressDlg.this.ei.cancel(true);
                }
            });
            pb.add((Component)pbCancel, cc.xy(2, 10));
            this.setContentPane(pb.getPanel());
            this.setResizable(false);
            this.setDefaultCloseOperation(0);
            this.pack();
            this.setLocationRelativeTo(this.getOwner());
            this.setVisible(true);
            Graphics g = this.getGraphics();
            g.setClip(0, 0, this.getWidth(), this.getHeight());
            this.paint(g);
            this.setGlassPane(new InfiniteGlassPane());
        }

        public boolean setCurrentFile(String fileName) {
            ++this.nbFilesImported;
            this.currentFileName.setText(DEFAULT_TEXT + fileName);
            this.currentProgress.setMaximum(100);
            this.currentProgress.setValue(0);
            return this.shouldContinue;
        }

        public boolean pushCurrentProgress(int value) {
            this.currentProgress.setValue(value);
            int progress = (int)(((double)this.nbFilesImported + this.currentProgress.getPercentComplete()) / (double)this.nbFilesToImport * 1000.0);
            this.globalProgress.setValue(progress);
            this.repaintImmediatly();
            return this.shouldContinue;
        }

        public void repaintImmediatly() {
            this.currentProgress.paintImmediatly();
            this.globalProgress.paintImmediatly();
            Graphics g = this.getGraphics();
            g.setClip(0, 0, this.getWidth(), this.getHeight());
            if (this.isLightweight()) {
                this.paint(g);
            } else {
                this.update(g);
            }
        }

        public void setUnknownEndded(boolean start) {
            this.getGlassPane().setVisible(start);
        }
    }

    private class QueryOverwrite
    implements Runnable {
        private String fileName;
        private int ret = -2;

        public QueryOverwrite(String fileName) {
            this.fileName = fileName;
        }

        public void run() {
            String msg = "Ce document existe d\u00e9j\u00e0 : " + this.fileName + "; voulez-vous l'\u00e9craser ?";
            Object[] options = new String[]{"Oui", "Non", "Annuler"};
            this.ret = JOptionPane.showOptionDialog(ImportServiceSwingProvider.this.owner, msg, "Confirmation", 0, 3, null, options, options[1]);
        }

        public int getRet() {
            return this.ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueryBudget
    implements Runnable {
        private String fileName;
        private TreeSet<Pair> existing;
        private Pair ret;
        private String collectivite = null;

        public QueryBudget(String fileName, TreeSet<Pair> existing, String collectivite) {
            this.fileName = fileName;
            this.existing = existing;
            this.collectivite = collectivite;
        }

        @Override
        public void run() {
            DlgGetPair dlg = null;
            dlg = new DlgGetPair(ImportServiceSwingProvider.this.owner, "Sur quel budget porte ce document : " + this.fileName + " ?", this.existing, this.collectivite, ((ImportServiceSwingProvider)ImportServiceSwingProvider.this).ei.bdg);
            if (dlg.run()) {
                this.ret = new Pair(dlg.getCode(), dlg.getLibelle());
            }
            logger.debug((Object)"fin de QueryBudget.run()");
        }

        public Pair getRet() {
            logger.debug((Object)"QueryBudget.getRet()");
            return this.ret;
        }
    }

    private class QueryCollectivite
    implements Runnable {
        private Pair ret;
        private String fileName;

        public QueryCollectivite(String fileName) {
            this.fileName = fileName;
        }

        public void run() {
            DlgGetPair dlg = new DlgGetPair(ImportServiceSwingProvider.this.owner, "Sur quelle collectivit\u00e9 porte ce document : " + this.fileName + " ?", null, null, ((ImportServiceSwingProvider)ImportServiceSwingProvider.this).ei.col);
            if (dlg.run()) {
                this.ret = new Pair(dlg.getCode(), dlg.getLibelle());
            }
        }

        public Pair getRet() {
            return this.ret;
        }
    }

    public static class PaintableProgress
    extends JProgressBar
    implements ImmediatlyPaintable {
        private static final long serialVersionUID = 1L;

        public PaintableProgress() {
        }

        public PaintableProgress(int orient) {
            super(orient);
        }

        public PaintableProgress(int min, int max) {
            super(min, max);
        }

        public PaintableProgress(int orient, int min, int max) {
            super(orient, min, max);
        }

        public PaintableProgress(BoundedRangeModel newModel) {
            super(newModel);
        }

        public void paintImmediatly() {
            Runnable code = new Runnable(){

                public void run() {
                    PaintableProgress.this.paintImmediately(0, 0, PaintableProgress.this.getWidth(), PaintableProgress.this.getHeight());
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                code.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(code);
                }
                catch (Exception ex) {
                    logger.error((Object)"tu sais ou", (Throwable)ex);
                }
            }
        }
    }

    public static interface ImmediatlyPaintable {
        public void paintImmediatly();
    }
}

