/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.data.impl.sqlconfig;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TCriteria;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TElement;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TKey;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TSqlIndex;
import fr.gouv.finances.cp.xemelios.data.impl.sqlconfig.TTable;
import fr.gouv.finances.cp.xemelios.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TEtat
implements XmlMarshallable {
    private static Logger logger = Logger.getLogger(TEtat.class);
    public static final String TAG = "etat";
    private TTable documentTable;
    private Hashtable<String, TTable> indexTables = new Hashtable();
    private TKey key1;
    private TKey key2;
    private TKey key3;
    private TKey key4;
    private TKey key5;
    private TKey key6;
    private TKey key7;
    private TKey key8;
    private TKey key9;
    private TKey key10;
    private Hashtable<String, TCriteria> criterias = new Hashtable();
    private Hashtable<String, TSqlIndex> sqlIndexesById = new Hashtable();
    private Hashtable<String, TSqlIndex> sqlIndexesByPath = new Hashtable();
    private Hashtable<String, TElement> elements = new Hashtable();
    private TTable mainTable;
    private String xsltBuffer;
    private String baseDirectory = null;
    private String id;
    private String importXsltFile;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getImportXsltFile() {
        return this.importXsltFile;
    }

    public void setImportXsltFile(String importXsltFile) {
        this.importXsltFile = importXsltFile;
    }

    public TEtat(String tagName) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
        if ("table".equals(tagName)) {
            TTable table = (TTable)child;
            logger.debug((Object)table);
            if ("document".equals(table.getType())) {
                this.documentTable = table;
            } else {
                this.indexTables.put(table.getId(), table);
                if (table.isMainTable()) {
                    this.mainTable = table;
                }
            }
        } else if ("key1".equals(tagName)) {
            this.key1 = (TKey)child;
        } else if ("key2".equals(tagName)) {
            this.key2 = (TKey)child;
        } else if ("key3".equals(tagName)) {
            this.key3 = (TKey)child;
        } else if ("key4".equals(tagName)) {
            this.key4 = (TKey)child;
        } else if ("key5".equals(tagName)) {
            this.key5 = (TKey)child;
        } else if ("key6".equals(tagName)) {
            this.key6 = (TKey)child;
        } else if ("key7".equals(tagName)) {
            this.key7 = (TKey)child;
        } else if ("key8".equals(tagName)) {
            this.key8 = (TKey)child;
        } else if ("key9".equals(tagName)) {
            this.key9 = (TKey)child;
        } else if ("key10".equals(tagName)) {
            this.key10 = (TKey)child;
        } else if ("criteria".equals(tagName)) {
            TCriteria crit = (TCriteria)child;
            this.criterias.put(crit.getId(), crit);
        } else if ("sql-index".equals(tagName)) {
            TSqlIndex index = (TSqlIndex)child;
            this.sqlIndexesById.put(index.getId(), index);
            this.sqlIndexesByPath.put(index.getPath(), index);
        } else if ("element".equals(tagName)) {
            TElement el = (TElement)child;
            this.elements.put(el.getId(), el);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        this.importXsltFile = attributes.getValue("import-xslt-file");
        return this;
    }

    public void marshall(XmlOutputter output) {
    }

    public void validate() throws InvalidXmlDefinition {
    }

    public TEtat clone() {
        TEtat other = new TEtat("");
        other.id = this.id;
        other.importXsltFile = this.importXsltFile;
        other.xsltBuffer = this.xsltBuffer;
        other.documentTable = this.documentTable.clone();
        other.mainTable = this.mainTable.clone();
        other.key1 = this.key1 != null ? this.key1.clone() : null;
        other.key2 = this.key2 != null ? this.key2.clone() : null;
        other.key3 = this.key3 != null ? this.key3.clone() : null;
        other.key4 = this.key4 != null ? this.key4.clone() : null;
        other.key5 = this.key5 != null ? this.key5.clone() : null;
        other.key6 = this.key6 != null ? this.key6.clone() : null;
        other.key7 = this.key7 != null ? this.key7.clone() : null;
        other.key8 = this.key8 != null ? this.key8.clone() : null;
        other.key9 = this.key9 != null ? this.key9.clone() : null;
        other.key10 = this.key10 != null ? this.key10.clone() : null;
        for (String s : this.indexTables.keySet()) {
            other.indexTables.put(s, this.indexTables.get(s).clone());
        }
        for (String s : this.criterias.keySet()) {
            other.criterias.put(s, this.criterias.get(s).clone());
        }
        for (String s : this.sqlIndexesById.keySet()) {
            other.sqlIndexesById.put(s, this.sqlIndexesById.get(s).clone());
        }
        for (String s : this.sqlIndexesByPath.keySet()) {
            other.sqlIndexesByPath.put(s, this.sqlIndexesByPath.get(s).clone());
        }
        for (String s : this.elements.keySet()) {
            other.elements.put(s, this.elements.get(s).clone());
        }
        other.baseDirectory = this.baseDirectory;
        return other;
    }

    public TTable getIndexTable(String indexTableId) {
        return this.indexTables.get(indexTableId);
    }

    public TTable getDocumentTable() {
        return this.documentTable;
    }

    public void setDocumentTable(TTable documentTable) {
        this.documentTable = documentTable;
    }

    public TCriteria getCriteria(String criteriaId) {
        return this.criterias.get(criteriaId);
    }

    public void removeCriteria(String criteriaId) {
        this.criterias.remove(criteriaId);
    }

    public TSqlIndex getSqlIndexById(String indexId) {
        return this.sqlIndexesById.get(indexId);
    }

    public TSqlIndex getSqlIndexByPath(String path) {
        String p = this.cleanPath(path);
        return this.sqlIndexesByPath.get(p);
    }

    protected String cleanPath(String path) {
        String left;
        int lastSlash;
        String p = new String(path);
        int pos = p.indexOf("/..");
        while (pos > 0 && (lastSlash = (left = p.substring(0, pos)).lastIndexOf("/")) >= 0) {
            String s = null;
            s = lastSlash > 0 ? left.substring(0, lastSlash) : "";
            p = s + p.substring(pos + 3);
            pos = p.indexOf("/..");
        }
        return p;
    }

    public TElement getElement(String elementId) {
        return this.elements.get(elementId);
    }

    public TKey getKey1() {
        return this.key1;
    }

    public void setKey1(TKey key1) {
        this.key1 = key1;
    }

    public TKey getKey10() {
        return this.key10;
    }

    public void setKey10(TKey key10) {
        this.key10 = key10;
    }

    public TKey getKey2() {
        return this.key2;
    }

    public void setKey2(TKey key2) {
        this.key2 = key2;
    }

    public TKey getKey3() {
        return this.key3;
    }

    public void setKey3(TKey key3) {
        this.key3 = key3;
    }

    public TKey getKey4() {
        return this.key4;
    }

    public void setKey4(TKey key4) {
        this.key4 = key4;
    }

    public TKey getKey5() {
        return this.key5;
    }

    public void setKey5(TKey key5) {
        this.key5 = key5;
    }

    public TKey getKey6() {
        return this.key6;
    }

    public void setKey6(TKey key6) {
        this.key6 = key6;
    }

    public TKey getKey7() {
        return this.key7;
    }

    public void setKey7(TKey key7) {
        this.key7 = key7;
    }

    public TKey getKey8() {
        return this.key8;
    }

    public void setKey8(TKey key8) {
        this.key8 = key8;
    }

    public TKey getKey9() {
        return this.key9;
    }

    public void setKey9(TKey key9) {
        this.key9 = key9;
    }

    public Iterable<TTable> getIndexTables() {
        return this.indexTables.values();
    }

    public TTable getMaintable() {
        return this.mainTable;
    }

    public String getImportXsltBuffer() {
        if (this.xsltBuffer == null && this.getImportXsltFile() != null) {
            File f = new File(new File(this.baseDirectory), this.getImportXsltFile());
            try {
                String xslEncoding = FileUtils.getFileEncoding(f);
                this.xsltBuffer = FileUtils.readTextFile(f, xslEncoding);
            }
            catch (IOException ioEx) {
                logger.error((Object)"in TEtat.getImportXsltBuffer() :", (Throwable)ioEx);
            }
        }
        return this.xsltBuffer;
    }

    public void setBaseDirectory(String baseDir) {
        this.baseDirectory = baseDir;
    }
}

