/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.models;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.controls.models.ControlModel;
import fr.gouv.finances.cp.xemelios.controls.models.ControlModelTech;
import fr.gouv.finances.cp.xemelios.controls.models.ParamModel;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentControlModel
implements XmlMarshallable {
    public static final transient String TAG = "document";
    public String id;
    private Vector<ParamModel> params = new Vector();
    private Vector<ControlModelTech> controlsTech;
    private Vector<ControlModel> controls = new Vector();
    private Hashtable<String, ControlModel> indexedControls;
    private Hashtable<String, ControlModelTech> indexedControlsTech;

    public DocumentControlModel(String tagName) {
        this.controlsTech = new Vector();
        this.indexedControls = new Hashtable();
        this.indexedControlsTech = new Hashtable();
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
        if ("param".equals(tagName)) {
            this.params.add((ParamModel)child);
        } else if ("control".equals(tagName)) {
            ControlModel cm = (ControlModel)child;
            this.controls.add(cm);
            this.indexedControls.put(cm.getId(), cm);
        } else if ("controlTech".equals(tagName)) {
            ControlModelTech cm = (ControlModelTech)child;
            this.controlsTech.add(cm);
            this.indexedControlsTech.put(cm.getId(), cm);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        return this;
    }

    public void validate() throws InvalidXmlDefinition {
        for (ParamModel paramModel : this.params) {
            paramModel.validate();
        }
        for (ControlModel controlModel : this.controls) {
            controlModel.validate();
        }
        for (ControlModelTech controlModelTech : this.controlsTech) {
            controlModelTech.validate();
        }
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        output.addAttribute("id", this.id);
        for (ParamModel paramModel : this.params) {
            paramModel.marshall(output);
        }
        for (ControlModelTech controlModelTech : this.controlsTech) {
            controlModelTech.marshall(output);
        }
        for (ControlModel controlModel : this.controls) {
            controlModel.marshall(output);
        }
        output.endTag(TAG);
    }

    public String getDocumentById() {
        return this.id;
    }

    public ParamModel getParamById(String etatId) {
        for (ParamModel param : this.params) {
            if (!param.getId().equals(etatId)) continue;
            return param;
        }
        return null;
    }

    public ControlModel getControlById(String ctrlId) {
        return this.indexedControls.get(ctrlId);
    }

    public ControlModelTech getControlTechById(String ctrlId) {
        return this.indexedControlsTech.get(ctrlId);
    }

    public Vector<ControlModelTech> getControlsTech() {
        return this.controlsTech;
    }

    public Vector<ControlModel> getControls() {
        return this.controls;
    }

    public Vector<ParamModel> getParams() {
        return this.params;
    }

    public DocumentControlModel clone() {
        DocumentControlModel dcm = new DocumentControlModel(TAG);
        dcm.id = this.id;
        for (ControlModel cm : this.getControls()) {
            try {
                this.addChild(cm.clone(), "control");
            }
            catch (SAXException ignore) {}
        }
        for (ControlModelTech cmt : this.getControlsTech()) {
            try {
                this.addChild(cmt.clone(), "controlTech");
            }
            catch (SAXException ignore) {}
        }
        for (ParamModel pm : this.getParams()) {
            try {
                this.addChild(pm.clone(), "param");
            }
            catch (SAXException ignore) {}
        }
        return dcm;
    }
}

