/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls.models;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.controls.models.ParamModelTech;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlModelTech
implements XmlMarshallable {
    public static final transient String TAG = "controlTech";
    public String id;
    public String libelle;
    public String severity;
    public Vector<ParamModelTech> params = new Vector();
    private Hashtable<String, ParamModelTech> indexedParamsTech = new Hashtable();

    public ControlModelTech(String tagName) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
        if ("paramTech".equals(tagName)) {
            ParamModelTech cm = (ParamModelTech)child;
            this.params.add(cm);
            this.indexedParamsTech.put(cm.getId(), cm);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id");
        this.libelle = attributes.getValue("libelle");
        this.severity = attributes.getValue("severity");
        return this;
    }

    public void validate() throws InvalidXmlDefinition {
        for (ParamModelTech pcm : this.params) {
            pcm.validate();
        }
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        output.addAttribute("id", this.id);
        output.addAttribute("libelle", this.libelle);
        output.addAttribute("severity", this.severity);
        for (ParamModelTech pcm : this.params) {
            pcm.marshall(output);
        }
        output.endTag(TAG);
    }

    public String getId() {
        return this.id;
    }

    public String getLibelle() {
        return this.libelle;
    }

    public String getSeverity() {
        return this.severity;
    }

    public Vector<ParamModelTech> getParams() {
        return this.params;
    }

    public ParamModelTech getParamTechById(String ctrlId) {
        return this.indexedParamsTech.get(ctrlId);
    }

    public ControlModelTech clone() {
        ControlModelTech cm = new ControlModelTech(TAG);
        cm.id = this.id;
        cm.libelle = this.libelle;
        cm.severity = this.severity;
        for (ParamModelTech pmt : this.getParams()) {
            try {
                this.addChild(pmt.clone(), "paramTech");
            }
            catch (SAXException ignore) {}
        }
        return cm;
    }
}

