/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.ControlContentHandler;
import fr.gouv.finances.cp.xemelios.controls.ControlParser;
import fr.gouv.finances.cp.xemelios.controls.ControlProgressListener;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.RapportWriter;
import fr.gouv.finances.cp.xemelios.controls.SaxXmlWriter;
import fr.gouv.finances.cp.xemelios.controls.models.ControlsModel;
import fr.gouv.finances.cp.xemelios.controls.models.DocumentControlModel;
import fr.gouv.finances.cp.xemelios.controls.models.ParamModel;
import fr.gouv.finances.cp.xemelios.controls.tech.TECH01;
import fr.gouv.finances.cp.xemelios.controls.tech.TECH02;
import fr.gouv.finances.cp.xemelios.controls.tech.TECH03;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.cp.xemelios.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFrame;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.apache.log4j.Logger;
import org.apache.xerces.jaxp.validation.XMLSchemaFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainControl
implements Runnable {
    public static final int STATUS_NOT_CONTROLLED = -1;
    public static final int STATUS_CONTROL_NO_ERROR = 0;
    public static final int STATUS_NOT_XML = 1;
    public static final int STATUS_INVALID_ENCODING = 2;
    public static final int STATUS_NOT_SCHEMA_VALID = 3;
    public static final int STATUS_NOT_VALID = 4;
    private static final Logger logger = Logger.getLogger(MainControl.class);
    private File cfgDir;
    private File fichierAController;
    private File rapport;
    private DocumentModel documentModel;
    private DocumentsModel docsModel;
    private Hashtable<String, Object> hashParams = new Hashtable();
    private DocumentControlModel dcm;
    private Date datecontrole;
    private NamespaceContext nameSpaces;
    private SaxXmlWriter saxWriter = new SaxXmlWriter();
    public static final String ID_DOCUMENT_RAPPORT = "DocumentRapport";
    private ControlsModel cm;
    private String IDrapport = "";
    private String domainesControles = "";
    private RapportWriter rapportWriter;
    private boolean hasTech01Error = false;
    private boolean hasTech02Error = false;
    private boolean hasTech03Error = false;
    private ControlContentHandler cch = null;
    private File fichierEnrichi = null;
    private String fichierEnrichiLocation = null;
    private String rapportLocation = null;
    private ControlProgressListener cpl = null;
    private int status = -1;

    public MainControl(DocumentModel dm, DocumentsModel docsMod) {
        this.documentModel = dm;
        this.docsModel = docsMod;
        this.cfgDir = new File(dm.getBaseDirectory());
        this.cm = this.getControlsModel();
        this.dcm = this.cm.getDocumentById(dm.getId());
        this.nameSpaces = this.documentModel.getNamespaces();
    }

    public DocumentControlModel getDocumentControl() {
        return this.dcm;
    }

    @Override
    public void run() {
        block28: {
            SAXParserFactory factorySAX = SAXParserFactory.newInstance();
            factorySAX.setNamespaceAware(true);
            TECH01 tech01 = new TECH01();
            TECH02 tech02 = new TECH02();
            TECH03 tech03 = new TECH03();
            tech03.setDocumentModel(this.documentModel);
            try {
                FileInputStream fisTech = new FileInputStream(this.fichierAController);
                SAXParser parserXmlTech = factorySAX.newSAXParser();
                tech01.setDocModel(this.documentModel);
                parserXmlTech.parse((InputStream)fisTech, (DefaultHandler)tech01);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (Anomalie a : tech01.getAnomalies()) {
                if (!a.getControleID().matches("TECH01")) continue;
                this.hasTech01Error = true;
                this.status = 1;
            }
            DocumentModel dmRapport = this.docsModel.getDocumentById(ID_DOCUMENT_RAPPORT);
            File tmpDir = new File(System.getProperty("java.io.tmpdir"), "XEMELIOS");
            if (!tmpDir.exists()) {
                tmpDir.mkdirs();
            }
            if (this.rapportLocation == null) {
                this.rapportLocation = new File(tmpDir, "rapport" + this.fichierAController.getName()).getAbsolutePath();
            }
            this.rapport = new File(this.rapportLocation);
            this.datecontrole = new Date();
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(this.rapport);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            this.rapportWriter = new RapportWriter(new XmlOutputter((OutputStream)fos, "ISO-8859-1"));
            try {
                if (!this.hasTech01Error) {
                    this.cch = this.getControlContentHandler(this.documentModel, this.dcm, this.hashParams, MainWindow.instance, this.fichierAController.getName());
                    this.cch.setParameters(this.hashParams);
                    this.cch.setControlsModel(this.dcm.getControls());
                    if (this.dcm.getControlTechById("TECH02") == null || this.dcm.getControlTechById("TECH02") != null && tech02.encodingValid(this.dcm.getControlTechById("TECH02"), this.fichierAController)) {
                        this.domainesControles = tech01.getDomaines();
                        if (this.dcm.getControlTechById("TECH03") != null) {
                            XMLSchemaFactory xmlsf = new XMLSchemaFactory();
                            File fileSchema = new File(this.documentModel.getBaseDirectory(), this.dcm.getControlTechById("TECH03").getParamTechById("schemaLocation").getValue());
                            try {
                                Schema schema = xmlsf.newSchema(fileSchema);
                                Validator validateur = schema.newValidator();
                                FileInputStream fisTech03 = new FileInputStream(this.fichierAController);
                                SAXSource saxSrc = new SAXSource(new InputSource(fisTech03));
                                tech03.setDomainesControles(this.domainesControles);
                                validateur.setErrorHandler(tech03);
                                validateur.validate(saxSrc);
                                fisTech03.close();
                            }
                            catch (SAXException saxe) {
                                saxe.printStackTrace();
                            }
                        }
                        if (this.dcm.getControlTechById("TECH03") == null || this.dcm.getControlTechById("TECH03") != null && tech03.getAnomalies().size() == 0) {
                            FileInputStream fis = new FileInputStream(this.fichierAController);
                            SAXParser parserXml = factorySAX.newSAXParser();
                            this.saxWriter.setNamespaceContext(this.nameSpaces);
                            if (this.fichierEnrichiLocation == null) {
                                this.fichierEnrichiLocation = new File(tmpDir, this.fichierAController.getName()).getAbsolutePath();
                            }
                            this.fichierEnrichi = new File(this.fichierEnrichiLocation);
                            DOMResult dr = new DOMResult();
                            this.saxWriter.setResult(dr);
                            this.cch.setSaxWriter(this.saxWriter);
                            this.cch.setNamespaceContext(this.nameSpaces);
                            parserXml.parse((InputStream)fis, (DefaultHandler)this.cch);
                            StreamResult sr = new StreamResult(this.fichierEnrichi);
                            TransformerFactory tf = TransformerFactory.newInstance();
                            Transformer t = tf.newTransformer();
                            t.setOutputProperty("encoding", tech02.getInputEncoding() == "" ? FileUtils.getFileEncoding(this.fichierAController) : tech02.getInputEncoding());
                            t.transform(new DOMSource(dr.getNode()), sr);
                            sr.getOutputStream().flush();
                            sr.getOutputStream().close();
                            fis.close();
                            this.cpl.stopWaiting();
                            this.writeRapport(this.cch.collectivite, this.cch.budget, this.cch.getVTotalAnomalies(), this.cch.MAX_ANOS);
                            this.status = this.cch.getVTotalAnomalies().size() == 0 ? 0 : 4;
                        } else if (tech03.getAnomalies().size() > 0) {
                            logger.info((Object)("Le fichier " + this.fichierAController.getName() + " n'est pas conforme au schema de " + this.dcm.id));
                            Vector<Anomalie> vano = new Vector<Anomalie>();
                            for (Anomalie ano : tech03.getAnomalies()) {
                                vano.add(ano);
                            }
                            this.status = 3;
                            this.writeRapport(new Pair("00000000000000", "Collectivite de Contr\u00f4le"), new Pair("00", "Budget de Contr\u00f4le"), vano, 0);
                        } else {
                            this.cpl.notifyTechniqueValidationFailed();
                        }
                        break block28;
                    }
                    String encodingValide = "";
                    for (int i = 0; i < this.dcm.getControlTechById("TECH02").getParams().size(); ++i) {
                        String e = this.dcm.getControlTechById("TECH02").getParams().get(i).getValue();
                        encodingValide = i + 1 == this.dcm.getControlTechById("TECH02").getParams().size() ? encodingValide + e : encodingValide + e + ",";
                    }
                    logger.info((Object)("Le fichier " + this.fichierAController.getName() + " n'est pas encod\u00e9 en " + encodingValide + "."));
                    Vector<Anomalie> vano = new Vector<Anomalie>();
                    vano.add(new Anomalie(IdGenerator.nextId(), "TECH02", "Contr\u00f4le de l'encoding du fichier.", this.documentModel.getId(), "", "", "", "", "", "Le fichier est encod\u00e9 en " + tech02.getInputEncoding() + " alors qu'il devrait \u00eatre encod\u00e9 en " + encodingValide + ".", "Le fichier doit \u00eatre encod\u00e9 en " + encodingValide + ".", "BLOQUANT", "xpath namespacise", new Hashtable<String, Object>()));
                    this.status = 2;
                    this.writeRapport(new Pair("00000000000000", "Collectivite de Contr\u00f4le"), new Pair("00", "Budget de Contr\u00f4le"), vano, 0);
                    break block28;
                }
                logger.info((Object)("Le fichier " + this.fichierAController.getName() + " n'est pas un fichier XML valide."));
                Vector<Anomalie> vano = new Vector<Anomalie>();
                for (Anomalie ano : tech01.getAnomalies()) {
                    vano.add(ano);
                }
                this.writeRapport(new Pair("00000000000000", "Collectivite de Contr\u00f4le"), new Pair("00", "Budget de Contr\u00f4le"), tech01.getAnomalies(), 0);
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Pair getCollectivite() throws IllegalStateException {
        if (this.status == -1) {
            throw new IllegalStateException("You must run control before calling getCollectivite()");
        }
        return this.cch != null ? this.cch.collectivite : null;
    }

    public Pair getBudget() throws IllegalStateException {
        if (this.status == -1) {
            throw new IllegalStateException("You must run control before calling getBudget()");
        }
        return this.cch != null ? this.cch.budget : null;
    }

    public Vector<Anomalie> getTotalAnomalies() throws IllegalStateException {
        if (this.status == -1) {
            throw new IllegalStateException("You must run control before calling getTotalAnomalies()");
        }
        return this.cch != null ? this.cch.getVTotalAnomalies() : new Vector<Anomalie>();
    }

    private ControlsModel getControlsModel() {
        ControlsModel ret = null;
        try {
            ControlParser cp = new ControlParser();
            cp.parse(new File(this.documentModel.getBaseDirectory(), this.documentModel.getControlConfigFile()));
            ControlsModel c = (ControlsModel)cp.getMarshallable();
            c.validate();
            ret = c;
        }
        catch (Exception ex) {
            logger.debug((Object)"Error in getControlsModel()!!!", (Throwable)ex);
        }
        return ret;
    }

    public void setFileToControl(File f) {
        this.fichierAController = f;
    }

    public File getFileToControl() {
        return this.fichierAController;
    }

    public void setParameters(Hashtable<String, Object> params) {
        this.hashParams = params;
    }

    private void writeRapport(Pair collec, Pair budg, Vector<Anomalie> vano, int maxanos) throws IOException {
        String[] domaines;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String msgAno = "";
        msgAno = vano != null && vano.size() >= maxanos && !vano.get(0).getControleID().startsWith("TECH") ? "true" : "false";
        this.IDrapport = this.datecontrole.getTime() + this.rapport.getName();
        Pair docid = new Pair("V", this.documentModel.getId());
        this.rapportWriter.writeElement("DocId", docid);
        this.rapportWriter.writeElement("NomFichier", new Pair("V", this.fichierAController.getName()));
        this.rapportWriter.writeElement("DateControle", new Pair("V", simpleDateFormat.format(this.datecontrole)));
        this.rapportWriter.openElement("Collectivite");
        this.rapportWriter.writeElement("Siret", new Pair("V", collec.key));
        this.rapportWriter.writeElement("Libelle", new Pair("V", collec.libelle));
        this.rapportWriter.closeElement("Collectivite");
        this.rapportWriter.openElement("Budget");
        this.rapportWriter.writeElement("Code", new Pair("V", budg.key));
        this.rapportWriter.writeElement("Libelle", new Pair("V", budg.libelle));
        this.rapportWriter.closeElement("Budget");
        this.rapportWriter.writeElement("TropAnos", new Pair("V", msgAno));
        this.rapportWriter.openElement("Domaines");
        for (String domain : domaines = this.domainesControles.split(" / ")) {
            this.rapportWriter.writeElement("Domaine", new Pair("V", domain));
        }
        this.rapportWriter.closeElement("Domaines");
        this.rapportWriter.openElement("Params");
        this.writeParameters();
        this.rapportWriter.closeElement("Params");
        this.rapportWriter.openElement("DonneesRapport");
        this.rapportWriter.openElement("Rapport");
        this.rapportWriter.writeElement("Id", new Pair("V", this.datecontrole.getTime() + this.rapport.getName()));
        if (vano != null) {
            Collections.sort(vano, Collections.reverseOrder());
            for (Anomalie anomalie : vano) {
                this.writeAnomalie(anomalie);
            }
        }
        this.rapportWriter.closeElement("Rapport");
        this.rapportWriter.closeElement("DonneesRapport");
        this.rapportWriter.endRapport();
        logger.debug((Object)("Le rapport se trouve dans : " + this.rapport.getParent()));
    }

    private void writeAnomalie(Anomalie a) {
        this.rapportWriter.openElement("Anomalie");
        this.rapportWriter.writeElement("Id", new Pair("V", a.getIdAnomalie()));
        this.rapportWriter.writeElement("IdCtrl", new Pair("V", a.getControleID()));
        this.rapportWriter.writeElement("LibelleCtrl", new Pair("V", a.getControleLibelle()));
        this.rapportWriter.writeElement("EtatId", new Pair("V", a.getEtatID()));
        this.rapportWriter.writeElement("ElementImportable", new Pair("V", a.getelementImportable()));
        this.rapportWriter.writeElement("IdElementImportable", new Pair("V", a.getIdElementImportable()));
        this.rapportWriter.writeElement("ElementEnAnomalie", new Pair("V", a.getelementEnAnomalie()));
        this.rapportWriter.writeElement("LibelleLien", new Pair("V", a.getLibelleLien()));
        this.rapportWriter.openElement("Message");
        this.rapportWriter.writeData(a.getMessage().replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("&", "&amp;"));
        this.rapportWriter.closeElement("Message");
        this.rapportWriter.openElement("Regle");
        this.rapportWriter.writeData(a.getRegle().replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("&", "&amp;"));
        this.rapportWriter.closeElement("Regle");
        this.rapportWriter.writeElement("Severity", new Pair("V", a.getSeverity()));
        this.rapportWriter.writeElement("XPath", new Pair("V", a.getXPath()));
        if (a.getXslParams() != null && a.getXslParams().size() > 0) {
            for (String key : a.getXslParams().keySet()) {
                String value = a.getXslParams().get(key).toString();
                this.rapportWriter.openElement("XslParam");
                this.rapportWriter.writeElement("Key", new Pair("V", key));
                this.rapportWriter.writeElement("Value", new Pair("V", value));
                this.rapportWriter.closeElement("XslParam");
            }
        }
        this.rapportWriter.closeElement("Anomalie");
    }

    private String writeParameters() {
        StringBuffer params = new StringBuffer();
        for (ParamModel param : this.dcm.getParams()) {
            String paramValue = "";
            if (this.hashParams.get(param.getId()).getClass().equals(Boolean.class)) {
                paramValue = this.hashParams.get(param.getId()).equals(true) ? "Oui" : (this.hashParams.get(param.getId()).equals(false) ? "Non" : "Nc");
            } else if (this.hashParams.get(param.getId()).getClass().equals(BigDecimal.class)) {
                paramValue = this.hashParams.get(param.getId()).toString();
            } else if (this.hashParams.get(param.getId()).getClass().equals(String.class)) {
                paramValue = this.hashParams.get(param.getId()).toString();
            } else if (this.hashParams.get(param.getId()).getClass().equals(Integer.class)) {
                paramValue = this.hashParams.get(param.getId()).toString();
            } else if (this.hashParams.get(param.getId()) instanceof String[]) {
                if (((String[])this.hashParams.get(param.getId())).length == 0) {
                    paramValue = "Non Renseign\u00e9";
                }
                for (int i = 0; i < ((String[])this.hashParams.get(param.getId())).length; ++i) {
                    paramValue = paramValue + (i != 0 ? ", " : "") + ((String[])this.hashParams.get(param.getId()))[i];
                }
            } else {
                paramValue = this.hashParams.get(param.getId()).getClass().getName();
            }
            this.rapportWriter.writeElement("Param", new Pair("Name", param.getName()), new Pair("Value", paramValue));
        }
        return params.toString();
    }

    public void writeControlConfigFile() throws IOException {
        File output = new File(this.documentModel.getBaseDirectory(), this.documentModel.getControlConfigFile());
        XmlOutputter outputter = new XmlOutputter((OutputStream)new FileOutputStream(output), "ISO-8859-1");
        this.cm.marshall(outputter);
    }

    public int getControlStatus() {
        return this.status;
    }

    public DocumentModel getDocumentModel() {
        return this.documentModel;
    }

    public File getFichierEnrichi() throws IllegalStateException {
        if (this.status == -1) {
            throw new IllegalStateException("You must run control before calling getFichierEnrichi()");
        }
        return this.fichierEnrichi;
    }

    public File getRapport() throws IllegalStateException {
        if (this.status == -1) {
            throw new IllegalStateException("You must run control before calling getRapport()");
        }
        return this.rapport;
    }

    public String getIdRapport() {
        return this.IDrapport;
    }

    public void setControlProgressListener(ControlProgressListener cpl) {
        this.cpl = cpl;
    }

    public void setFichierEnrichiLocation(String absoluteFileName) throws IllegalStateException {
        if (this.status != -1) {
            throw new IllegalStateException("You must not change fichierEnrichi location after control");
        }
        this.fichierEnrichiLocation = absoluteFileName;
    }

    public void setRapportLocation(String absoluteFileName) throws IllegalStateException {
        if (this.status != -1) {
            throw new IllegalStateException("You must not change rapport location after control");
        }
        this.rapportLocation = absoluteFileName;
    }

    public ControlContentHandler getControlContentHandler(DocumentModel dm, DocumentControlModel docCtrlMod, Hashtable<String, Object> parameters, JFrame frame, String file) {
        return new ControlContentHandler(dm, docCtrlMod, parameters, frame, file);
    }

    public static class Triplet {
        public String iDrapport;
        public String codeCollectivite;
        public String codeBudget;

        public Triplet(String idRapport, String codColl, String codBud) {
            this.iDrapport = idRapport;
            this.codeCollectivite = codColl;
            this.codeBudget = codBud;
        }
    }
}

