/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.controls;

import fr.gouv.finances.cp.utils.Pair;
import fr.gouv.finances.cp.utils.ui.DlgGetPair;
import fr.gouv.finances.cp.utils.xml.XmlAttributesImpl;
import fr.gouv.finances.cp.xemelios.common.ToolException;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.controls.AbstractUnitControl;
import fr.gouv.finances.cp.xemelios.controls.Anomalie;
import fr.gouv.finances.cp.xemelios.controls.ControlProgressListener;
import fr.gouv.finances.cp.xemelios.controls.IdGenerator;
import fr.gouv.finances.cp.xemelios.controls.SaxXmlWriter;
import fr.gouv.finances.cp.xemelios.controls.comm.COLLBUDG;
import fr.gouv.finances.cp.xemelios.controls.models.ControlModel;
import fr.gouv.finances.cp.xemelios.controls.models.DocumentControlModel;
import fr.gouv.finances.cp.xemelios.data.DataAccessException;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import fr.gouv.finances.cp.xemelios.data.DataLayerManager;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.xml.namespace.NamespaceContext;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlContentHandler
extends DefaultHandler
implements ContentHandler {
    private Logger logger = Logger.getLogger(this.getClass());
    public Pair collectivite;
    public Pair budget;
    public int MAX_ANOS = 300;
    private ArrayList<AbstractUnitControl> controlsToCall;
    private DocumentControlModel docControlMod;
    private DocumentModel docModel;
    private Hashtable<String, Object> hParams;
    private Stack<String> stack;
    private JFrame owner;
    private Vector<Anomalie> anos = new Vector();
    private Vector<Anomalie> vTotalAnomalies;
    private Vector<ControlModel> controlsModel;
    private SaxXmlWriter saxXmlWriter;
    private NamespaceContext nsCtx;
    private boolean startEtatPassed = false;
    public boolean importInterupted = false;
    private String fileName;
    private ControlProgressListener cpl;

    public void setControlProgressListener(ControlProgressListener cpl) {
        this.cpl = cpl;
    }

    public ControlContentHandler(DocumentModel dm, DocumentControlModel docCtrlMod, Hashtable<String, Object> parameters, JFrame frame, String file) {
        this.docModel = dm;
        this.docControlMod = docCtrlMod;
        this.owner = frame;
        this.fileName = file;
        this.nsCtx = dm.getNamespaces();
        this.vTotalAnomalies = new Vector();
        this.stack = new Stack();
        this.controlsToCall = new ArrayList();
        this.hParams = parameters;
        try {
            COLLBUDG cbc = new COLLBUDG();
            cbc.setDocumentModel(this.docControlMod);
            cbc.setCch(this);
            cbc.setColl_path(this.docModel.getCollectivitePath().getCodePath().getPath());
            cbc.setColl_lib(this.docModel.getCollectivitePath().getLibellePath().getPath());
            cbc.setBudg_path(this.docModel.getBudgetPath().getCodePath().getPath());
            cbc.setBudg_lib(this.docModel.getBudgetPath().getLibellePath().getPath());
            this.controlsToCall.add(cbc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (ControlModel ctrlm : docCtrlMod.getControls()) {
            try {
                Object o = new Object();
                if (!ctrlm.id.startsWith("TECH")) {
                    o = Class.forName(ctrlm.getClasse()).newInstance();
                }
                if (!(o instanceof AbstractUnitControl)) continue;
                AbstractUnitControl auc = (AbstractUnitControl)o;
                auc.setParameters(this.getParameters());
                auc.setDocumentModel(this.docControlMod);
                this.controlsToCall.add(auc);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void startDocument() throws SAXException {
        for (AbstractUnitControl auc : this.controlsToCall) {
            try {
                auc.startDocument();
            }
            catch (SAXException saxEx) {
                this.logger.debug((Object)"in startDocument cch !!!", (Throwable)saxEx);
            }
        }
        this.saxXmlWriter.startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.stack.push(localName);
        String xpath = this.getXpathExpression();
        this.checkBudgetCollectivite(xpath + "@V", atts.getValue("V"));
        XmlAttributesImpl attrs = new XmlAttributesImpl();
        for (int i = 0; i < atts.getLength(); ++i) {
            attrs.addAttribute(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), atts.getType(i), atts.getValue(i));
        }
        if (this.stack.size() == 1) {
            this.startEtatPassed = true;
            this.saxXmlWriter.startPrefixMapping(this.nsCtx.getPrefix("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally"), "http://projets.admisource.gouv.fr/xemelios/namespaces#anomally");
        }
        attrs.addAttribute("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally", "node-id", (this.nsCtx.getPrefix("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally") != null ? this.nsCtx.getPrefix("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally") + ":" : "") + "node-id", "CDATA", IdGenerator.nextId());
        for (AbstractUnitControl auc : this.controlsToCall) {
            auc.startElement(uri, localName, qName, attrs, this.getXpathExpression());
        }
        this.saxXmlWriter.startElement(uri, localName, qName, attrs);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Vector<Anomalie> vAno = new Vector<Anomalie>();
        for (AbstractUnitControl auc : this.controlsToCall) {
            try {
                this.anos = auc.endElement(uri, localName, qName, this.getXpathExpression());
                if (this.anos == null || this.anos.isEmpty() || this.vTotalAnomalies.size() > this.MAX_ANOS) continue;
                this.vTotalAnomalies.addAll(this.anos);
                vAno.addAll(this.anos);
            }
            catch (SAXException saxEx) {
                this.logger.debug((Object)"in endElement!!!", (Throwable)saxEx);
            }
        }
        if (!vAno.isEmpty()) {
            for (Anomalie ano : vAno) {
                this.saxXmlWriter.writeAnomally(ano);
            }
        }
        if (this.stack.size() == 1) {
            this.saxXmlWriter.endPrefixMapping(this.nsCtx.getPrefix("http://projets.admisource.gouv.fr/xemelios/namespaces#anomally"));
        }
        this.saxXmlWriter.endElement(uri, localName, qName);
        this.stack.pop();
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.collectivite == null || this.collectivite.key == null || this.collectivite.libelle == null) {
            try {
                this.collectivite = this.getCollectivite(this.docModel, this.fileName);
            }
            catch (ToolException e) {
                e.printStackTrace();
            }
        }
        if (this.budget == null || this.budget.key == null || this.budget.libelle == null || this.budget.libelle.equals("")) {
            try {
                this.budget = this.getBudget(this.docModel, this.collectivite, this.fileName);
            }
            catch (ToolException e) {
                e.printStackTrace();
            }
        }
        this.saxXmlWriter.endDocument();
    }

    private Hashtable<String, Object> getParameters() {
        return this.hParams;
    }

    public void setParameters(Hashtable<String, Object> ho) {
        this.hParams = ho;
    }

    private String getXpathExpression() {
        StringBuffer sb = new StringBuffer();
        for (String s : this.stack) {
            sb.append(s + "/");
        }
        return sb.toString();
    }

    public void setControlsModel(Vector<ControlModel> cm) {
        this.controlsModel = cm;
    }

    public void setSaxWriter(SaxXmlWriter sxw) {
        this.saxXmlWriter = sxw;
    }

    public Vector<Anomalie> getVTotalAnomalies() {
        return this.vTotalAnomalies;
    }

    public Pair getCollectivite(DocumentModel dm, String fileName) throws ToolException {
        this.logger.debug((Object)"in getCollectivite");
        Pair ret = null;
        if (ret == null) {
            QueryCollectivite qc = new QueryCollectivite(fileName);
            qc.setDefaultCollectivite(this.collectivite);
            if (SwingUtilities.isEventDispatchThread()) {
                qc.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(qc);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            ret = qc.getRet();
            if (ret == null) {
                throw new ToolException("Action interrompue", 1);
            }
        }
        return ret;
    }

    public Pair getBudget(DocumentModel dm, Pair collectivite, String fileName) throws ToolException {
        this.logger.debug((Object)"in getBudget");
        Pair ret = null;
        if (ret == null) {
            TreeSet<Pair> existing = new TreeSet<Pair>();
            try {
                existing.addAll(DataLayerManager.getImplementation().getBudgets(dm, collectivite));
            }
            catch (DataConfigurationException e) {
                this.logger.error((Object)"in getBudget", (Throwable)e);
            }
            catch (DataAccessException e) {
                this.logger.error((Object)"in getBudget", (Throwable)e);
            }
            Vector<Pair> budgetsDm = dm.getDefaultBudgets();
            existing.addAll(budgetsDm);
            if (this.docModel.getDefaultBudgets().firstElement() != null) {
                existing.add(this.docModel.getDefaultBudgets().firstElement());
            }
            QueryBudget qb = new QueryBudget(fileName, existing, collectivite.libelle);
            if (SwingUtilities.isEventDispatchThread()) {
                qb.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(qb);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            ret = qb.getRet();
            if (ret == null) {
                throw new ToolException("Action interrompue", 1);
            }
        }
        return ret;
    }

    private void checkBudgetCollectivite(String path, String value) {
        String[] s;
        String stringpath;
        if (this.docModel.getBudgetPath() != null) {
            if (this.docModel.getBudgetPath().getCodePath() != null && path.endsWith(stringpath = (s = this.docModel.getBudgetPath().getCodePath().getPath().split("/"))[s.length - 2] + "/" + s[s.length - 1])) {
                if (this.budget == null) {
                    this.budget = new Pair();
                }
                this.budget.key = value;
            }
            if (this.docModel.getBudgetPath().getLibellePath() != null && path.endsWith(stringpath = (s = this.docModel.getBudgetPath().getLibellePath().getPath().split("/"))[s.length - 2] + "/" + s[s.length - 1])) {
                if (this.budget.key == null) {
                    this.budget = new Pair();
                }
                this.budget.libelle = value;
            }
        }
        if (this.docModel.getCollectivitePath() != null) {
            if (this.docModel.getCollectivitePath().getCodePath() != null && path.endsWith(stringpath = (s = this.docModel.getCollectivitePath().getCodePath().getPath().split("/"))[s.length - 2] + "/" + s[s.length - 1])) {
                if (this.collectivite == null) {
                    this.collectivite = new Pair();
                }
                this.collectivite.key = value;
            }
            if (this.docModel.getCollectivitePath().getLibellePath() != null && path.endsWith(stringpath = (s = this.docModel.getCollectivitePath().getLibellePath().getPath().split("/"))[s.length - 2] + "/" + s[s.length - 1])) {
                if (this.collectivite.key == null) {
                    this.collectivite = new Pair();
                }
                this.collectivite.libelle = value;
            }
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        for (AbstractUnitControl auc : this.controlsToCall) {
            auc.startPrefixMapping(prefix, uri, this.getXpathExpression());
        }
        this.saxXmlWriter.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
        for (AbstractUnitControl auc : this.controlsToCall) {
            auc.endPrefixMapping(prefix, this.getXpathExpression());
        }
        this.saxXmlWriter.endPrefixMapping(prefix);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.saxXmlWriter.characters(ch, start, length);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.saxXmlWriter.setDocumentLocator(locator);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.saxXmlWriter.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) {
        try {
            this.saxXmlWriter.processingInstruction(target, data);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.saxXmlWriter.skippedEntity(name);
    }

    public void setNamespaceContext(NamespaceContext nsCtx) {
        this.nsCtx = nsCtx;
    }

    public Pair getBudget() {
        return this.budget;
    }

    public void setBudget(Pair budget) {
        this.budget = budget;
    }

    public Pair getCollectivite() {
        return this.collectivite;
    }

    public void setCollectivite(Pair collectivite) {
        this.collectivite = collectivite;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueryBudget
    implements Runnable {
        private String fileName;
        private TreeSet<Pair> existing;
        private Pair ret;
        private String collectivite = null;

        public QueryBudget(String fileName, TreeSet<Pair> existing, String collectivite) {
            this.fileName = fileName;
            this.existing = existing;
            this.collectivite = collectivite;
        }

        @Override
        public void run() {
            DlgGetPair dlg = null;
            dlg = new DlgGetPair(ControlContentHandler.this.owner, "Sur quel budget porte ce document : " + this.fileName + " ?", this.existing, this.collectivite, ControlContentHandler.this.budget);
            if (dlg.run()) {
                this.ret = new Pair(dlg.getCode(), dlg.getLibelle());
            } else if (!ControlContentHandler.this.importInterupted) {
                ControlContentHandler.this.importInterupted = true;
                ControlContentHandler.this.cpl.notifyImportInterrupted(false);
            }
            ControlContentHandler.this.logger.debug((Object)"fin de QueryBudget.run()");
        }

        public Pair getRet() {
            ControlContentHandler.this.logger.debug((Object)"QueryBudget.getRet()");
            return this.ret;
        }
    }

    private class QueryCollectivite
    implements Runnable {
        private Pair ret;
        private String fileName;
        private Pair defaultCollectivite = null;

        public Pair getDefaultCollectivite() {
            return this.defaultCollectivite;
        }

        public void setDefaultCollectivite(Pair defaultCollectivite) {
            this.defaultCollectivite = defaultCollectivite;
        }

        public QueryCollectivite(String fileName) {
            this.fileName = fileName;
        }

        public void run() {
            DlgGetPair dlg = new DlgGetPair(ControlContentHandler.this.owner, "Sur quelle collectivit\u00e9 porte ce document : " + this.fileName + " ?", null, null, ControlContentHandler.this.collectivite);
            if (dlg.run()) {
                this.ret = new Pair(dlg.getCode(), dlg.getLibelle());
            } else {
                ControlContentHandler.this.importInterupted = true;
                ControlContentHandler.this.cpl.notifyImportInterrupted(true);
            }
        }

        public Pair getRet() {
            return this.ret;
        }
    }
}

