/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.RechercheModel;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SavedRequestsModel
implements XmlMarshallable {
    public static final transient String TAG = "saved-requests";
    private String elementId;
    private String etatId;
    private String documentId;
    private Hashtable<String, RechercheModel> requests = new Hashtable();
    private boolean unavailable = false;

    public SavedRequestsModel(String tagName, ElementModel em) {
        this(tagName);
        this.elementId = em.getId();
        this.etatId = em.getParent().getId();
        this.documentId = em.getParent().getParent().getId();
    }

    public SavedRequestsModel(String tagName) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
        if ("recherche".equals(tagName)) {
            this.add((RechercheModel)child);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.elementId = attributes.getValue("element-id");
        if (this.elementId == null) {
            this.elementId = attributes.getValue("etat-id");
            Vector<ElementModel> elements = MainWindow.instance.getDocModels().getElementsById(this.elementId);
            if (elements.size() > 0) {
                this.etatId = elements.get(0).getParent().getId();
                this.documentId = elements.get(0).getParent().getParent().getId();
            } else {
                this.unavailable = true;
            }
        } else {
            this.etatId = attributes.getValue("etat-id");
            this.documentId = attributes.getValue("document-id");
        }
        return this;
    }

    public void marshall(XmlOutputter output) {
        if (this.unavailable) {
            return;
        }
        output.startTag(TAG);
        output.addAttribute("document-id", this.documentId);
        output.addAttribute("etat-id", this.etatId);
        output.addAttribute("element-id", this.elementId);
        Enumeration<RechercheModel> enumer = this.requests.elements();
        while (enumer.hasMoreElements()) {
            enumer.nextElement().marshall(output);
        }
        output.endTag(TAG);
    }

    public void validate() throws InvalidXmlDefinition {
    }

    public Object clone() {
        SavedRequestsModel srm = new SavedRequestsModel(TAG);
        Enumeration<String> enumer = this.requests.keys();
        while (enumer.hasMoreElements()) {
            String key = enumer.nextElement();
            RechercheModel rm = this.requests.get(key);
            try {
                srm.addChild(rm, "recherche");
            }
            catch (Throwable t) {}
        }
        srm.documentId = this.documentId;
        srm.etatId = this.etatId;
        srm.elementId = this.elementId;
        srm.unavailable = this.unavailable;
        return srm;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getEtatId() {
        return this.elementId;
    }

    public String getElementId() {
        return this.elementId;
    }

    public void add(RechercheModel rm) {
        this.requests.put(rm.getName(), rm);
    }

    public void delete(RechercheModel rm) {
        this.requests.remove(rm.getName());
    }

    public boolean isUnavailable() {
        return this.unavailable;
    }

    public Collection<RechercheModel> getRecherches() {
        return this.requests.values();
    }

    String getKey() {
        return this.documentId + "|" + this.etatId + "|" + this.elementId;
    }
}

