/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.NoeudModifiable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class OptionModel
implements NoeudModifiable {
    Logger logger = Logger.getLogger(OptionModel.class);
    private NoeudModifiable _NMParent = null;
    public static final transient String TAG = "option";
    private String value;
    private StringBuffer libelle;
    private String tagName;
    private String configXPath = null;

    public OptionModel(String tagName) {
        this.tagName = tagName;
        this.libelle = new StringBuffer();
    }

    public void addCharacterData(String cData) throws SAXException {
        this.libelle.append(cData);
    }

    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.value = attributes.getValue("value") != null ? attributes.getValue("value") : this.value;
        return this;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        output.addAttribute("value", StringEscapeUtils.escapeXml(this.value));
        output.addCharacterData(StringEscapeUtils.escapeXml(this.libelle.toString()));
        output.endTag(TAG);
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.value == null || this.value.length() == 0) {
            throw new InvalidXmlDefinition("//" + this.tagName + "/@value is required and can not be null (" + this.getParentAsNoeudModifiable().getConfigXPath() + ").");
        }
        if (this.getLibelle().length() == 0) {
            throw new InvalidXmlDefinition("<" + this.tagName + "> content can not be empty (" + this.getConfigXPath() + ")");
        }
    }

    public String getLibelle() {
        return this.libelle.toString();
    }

    public String getValue() {
        return this.value;
    }

    public OptionModel clone() {
        OptionModel om = new OptionModel(TAG);
        om.value = this.value;
        om.libelle = this.libelle;
        return om;
    }

    public void modifyAttr(String attrName, String value) {
    }

    public void modifyAttrs(Attributes attrs) {
        try {
            this.getAttributes(new XmlAttributes(attrs));
        }
        catch (Exception e) {
            this.logger.error((Object)("Erreur lors de la mise \u00e0 jour des attributs : " + e));
        }
    }

    public void setParentAsNoeudModifiable(NoeudModifiable p) {
        this._NMParent = p;
    }

    public NoeudModifiable getParentAsNoeudModifiable() {
        return this._NMParent;
    }

    public NoeudModifiable getChildAsNoeudModifiable(String tagName, String id) {
        return null;
    }

    public String[] getChildIdAttrName(String childTagName) {
        return null;
    }

    public void resetCharData() {
        this.libelle.setLength(0);
    }

    public String getIdValue() {
        return null;
    }

    public String getConfigXPath() {
        if (this.configXPath == null) {
            this.configXPath = this.getParentAsNoeudModifiable() != null ? this.getParentAsNoeudModifiable().getConfigXPath() : "";
            this.configXPath = this.configXPath + "/option[@value='" + this.getValue() + "']";
        }
        return this.configXPath;
    }
}

