/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.NoeudModifiable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.NSModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NamespaceModel
implements NoeudModifiable,
NamespaceContext {
    Logger logger = Logger.getLogger(NamespaceModel.class);
    private NoeudModifiable _NMParent = null;
    public static final String TAG = "namespaces";
    private Hashtable<String, String> prefixToUri = null;
    private Hashtable<String, ArrayList<String>> uriToPrefix = null;
    private ArrayList<NSModel> mappings = null;
    private HashMap<String, NSModel> hNSModels;
    private Object locker = new Object();
    private String configXPath = null;

    public NamespaceModel(String tagName) {
        this.prefixToUri = new Hashtable();
        this.uriToPrefix = new Hashtable();
        this.mappings = new ArrayList();
        this.hNSModels = new HashMap();
        NSModel m = new NSModel("ns");
        m.setPrefix("xem");
        m.setUri("http://admisource.gouv.fr/projects/xemelios/ext");
        try {
            this.addChild(m, "ns");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
        if ("ns".equals(tagName)) {
            NSModel ns = (NSModel)child;
            ns.setParentAsNoeudModifiable(this);
            this.hNSModels.put(ns.getPrefix(), ns);
            this.prefixToUri.put(ns.getPrefix(), ns.getUri());
            ArrayList<String> prefixes = this.uriToPrefix.get(ns.getUri());
            if (prefixes == null) {
                Object object = this.locker;
                synchronized (object) {
                    prefixes = new ArrayList();
                    this.uriToPrefix.put(ns.getUri(), prefixes);
                }
            }
            prefixes.add(ns.getPrefix());
            this.mappings.add(ns);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        return this;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(TAG);
        for (String prefix : this.prefixToUri.keySet()) {
            output.startTag("ns");
            output.addAttribute("prefix", prefix);
            output.addAttribute("uri", this.prefixToUri.get(prefix));
            output.endTag("ns");
        }
        output.endTag(TAG);
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.mappings.size() == 0) {
            throw new InvalidXmlDefinition("<namespaces> element must contain at least one <ns/> element (" + this.getConfigXPath() + ").");
        }
    }

    public NamespaceModel clone() {
        NamespaceModel other = new NamespaceModel(TAG);
        for (NSModel mapping : this.mappings) {
            try {
                other.addChild(mapping.clone(), "ns");
            }
            catch (Throwable t) {}
        }
        return other;
    }

    public String getNamespaceURI(String prefix) {
        String ret = this.prefixToUri.get(prefix);
        return ret;
    }

    public String getPrefix(String namespaceURI) {
        String ret = null;
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI can not be null");
        }
        if ("xml".equals(namespaceURI)) {
            ret = "http://www.w3.org/XML/1998/namespace";
        } else if ("xmlns".equals(namespaceURI)) {
            ret = "http://www.w3.org/2000/xmlns/";
        }
        ArrayList<String> prefixes = this.uriToPrefix.get(namespaceURI);
        if (prefixes != null) {
            ret = prefixes.get(0);
        }
        return ret;
    }

    public Iterator getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI must not be null");
        }
        ArrayList<String> prefixes = this.uriToPrefix.get(namespaceURI);
        if (prefixes != null) {
            return prefixes.iterator();
        }
        if ("xml".equals(namespaceURI)) {
            return new StringIterator<String>("http://www.w3.org/XML/1998/namespace");
        }
        if ("xmlns".equals(namespaceURI)) {
            return new StringIterator<String>("http://www.w3.org/2000/xmlns/");
        }
        return null;
    }

    public void modifyAttr(String attrName, String value) {
    }

    public void modifyAttrs(Attributes attrs) {
        try {
            this.getAttributes(new XmlAttributes(attrs));
        }
        catch (Exception e) {
            this.logger.error((Object)("Erreur lors de la mise \u00e0 jour des attributs : " + e));
        }
    }

    public void setParentAsNoeudModifiable(NoeudModifiable p) {
        this._NMParent = p;
    }

    public NoeudModifiable getParentAsNoeudModifiable() {
        return this._NMParent;
    }

    public NoeudModifiable getChildAsNoeudModifiable(String tagName, String id) {
        if ("ns".equals(tagName)) {
            return this.hNSModels.get(id);
        }
        return null;
    }

    public String[] getChildIdAttrName(String childTagName) {
        if ("ns".equals(childTagName)) {
            return new String[]{"prefix"};
        }
        return null;
    }

    public String getIdValue() {
        return null;
    }

    public void resetCharData() {
    }

    public String getConfigXPath() {
        if (this.configXPath == null) {
            this.configXPath = this.getParentAsNoeudModifiable() != null ? this.getParentAsNoeudModifiable().getConfigXPath() : "";
            this.configXPath = this.configXPath + "/namespaces";
        }
        return this.configXPath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StringIterator<String>
    implements Iterator {
        private final String data;
        private boolean answered = false;

        public StringIterator(String data) {
            this.data = data;
        }

        @Override
        public boolean hasNext() {
            return !this.answered;
        }

        public String next() {
            if (this.answered) {
                throw new NoSuchElementException();
            }
            this.answered = true;
            return this.data;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("can not remove !");
        }
    }
}

