/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsDeriveParser;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Loader {
    private static final Logger logger = Logger.getLogger(Loader.class);

    public static DocumentsModel getDocumentsInfos(String repertoires) throws SAXException, ParserConfigurationException, IOException {
        File[] fichiers;
        File dir;
        String[] dirs;
        DocumentsModel ret = null;
        for (String repertoire : dirs = repertoires.split(",")) {
            dir = new File(repertoire);
            logger.debug((Object)("Searching " + repertoire));
            if (!dir.exists()) {
                logger.info((Object)(repertoire + " does not exists."));
                continue;
            }
            fichiers = dir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.toUpperCase().endsWith(".XML") && !"build.xml".equals(name);
                }
            });
            if (fichiers == null) {
                logger.info((Object)("No file found in " + repertoire));
                return null;
            }
            DocumentsParser dp = new DocumentsParser();
            for (int i = 0; i < fichiers.length; ++i) {
                dp.parse(fichiers[i]);
                DocumentsModel dm = (DocumentsModel)dp.getMarshallable();
                if (ret == null) {
                    ret = dm;
                    for (DocumentModel docModel : dm.getDocuments()) {
                        docModel.setBaseDirectory(repertoire);
                    }
                    continue;
                }
                for (DocumentModel docModel : dm.getDocuments()) {
                    docModel.setBaseDirectory(repertoire);
                    ret.addChild((XmlMarshallable)docModel, "document");
                }
            }
        }
        for (String repertoire : dirs) {
            dir = new File(repertoire);
            logger.debug((Object)("Searching " + repertoire));
            if (!dir.exists()) {
                logger.info((Object)(repertoire + " does not exists."));
                continue;
            }
            fichiers = dir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.toUpperCase().endsWith(".EXML");
                }
            });
            if (fichiers == null) {
                logger.info((Object)("No file found in " + repertoire));
                return null;
            }
            DocumentsDeriveParser ddp = new DocumentsDeriveParser(ret, repertoire);
            SAXParserFactory factorySAX = SAXParserFactory.newInstance();
            factorySAX.setNamespaceAware(true);
            for (int i = 0; i < fichiers.length; ++i) {
                FileInputStream fis = new FileInputStream(fichiers[i]);
                SAXParser parserXml = factorySAX.newSAXParser();
                parserXml.parse((InputStream)fis, (DefaultHandler)ddp);
            }
        }
        try {
            ret.validate();
        }
        catch (Throwable t) {
            logger.error((Object)("while loading config files: " + t));
            ret = new DocumentsModel("documents");
        }
        logger.debug((Object)"exiting successfully getDocumentsInfos");
        return ret;
    }
}

