/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.NoeudModifiable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.ChampModel;
import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.HiddenModel;
import fr.gouv.finances.cp.xemelios.common.config.WidgetModel;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListeResultatModel
implements NoeudModifiable,
Cloneable {
    private static Logger logger = Logger.getLogger(ListeResultatModel.class);
    private ElementModel parent;
    private NoeudModifiable _NMParent = null;
    public static final transient String TAG = "liste-resultat";
    private String triDefaut;
    private String ordre;
    private Hashtable<String, ChampModel> champs = new Hashtable();
    private Vector<ChampModel> listeChamps = new Vector();
    private HashMap<String, ChampModel> hChampModels = new HashMap();
    private Vector<HiddenModel> hiddens = new Vector();
    private HashMap<String, HiddenModel> hHiddenModels = new HashMap();
    private Vector<WidgetModel> widgets = new Vector();
    private HashMap<String, WidgetModel> hWidgets = new HashMap();
    private String configXPath = null;

    public ListeResultatModel(String tagName) {
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
        if ("champ".equals(tagName)) {
            ChampModel cm = (ChampModel)child;
            cm.setParent(this);
            cm.setParentAsNoeudModifiable(this);
            this.champs.put(cm.getId(), cm);
            this.listeChamps.add(cm);
            this.hChampModels.put(cm.getId(), cm);
        } else if ("hidden".equals(tagName)) {
            HiddenModel hm = (HiddenModel)child;
            hm.setParentAsNoeudModifiable(this);
            this.hiddens.add(hm);
            this.hHiddenModels.put(hm.getName(), hm);
        } else if ("widget".equals(tagName)) {
            WidgetModel wm = (WidgetModel)child;
            wm.setParentAsNoeudModifiable(this);
            this.widgets.add(wm);
            this.hWidgets.put(wm.getId(), wm);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.triDefaut = attributes.getValue("tri-defaut") != null ? attributes.getValue("tri-defaut") : this.triDefaut;
        this.ordre = attributes.getValue("ordre") != null ? attributes.getValue("ordre") : this.ordre;
        return this;
    }

    public void marshall(XmlOutputter output) {
        throw new Error("Not yet implemented");
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.triDefaut == null) {
            throw new InvalidXmlDefinition("//liste-resultat/@tri-defaut is required (" + this.getConfigXPath() + ")");
        }
        for (String s : this.triDefaut.split(",")) {
            if (s.length() == 0 || this.champs.get(s) != null) continue;
            throw new InvalidXmlDefinition(this.getConfigXPath() + "/@tri-defaut references a champ that is not defined: " + s);
        }
        if (this.ordre == null) {
            throw new InvalidXmlDefinition("//liste-resultat/@ordre is required (" + this.getConfigXPath() + ")");
        }
        for (WidgetModel wm : this.widgets) {
            wm.validate();
        }
        for (ChampModel cm : this.listeChamps) {
            cm.validate();
        }
        for (HiddenModel h : this.hiddens) {
            h.validate();
        }
    }

    public Hashtable<String, ChampModel> getChamps() {
        return this.champs;
    }

    public String getOrdre() {
        return this.ordre;
    }

    public String getTriDefaut() {
        return this.triDefaut;
    }

    public Vector<ChampModel> getListeChamps() {
        return this.listeChamps;
    }

    public ListeResultatModel clone() {
        ListeResultatModel other = new ListeResultatModel(TAG);
        other.triDefaut = this.triDefaut == null ? null : new String(this.triDefaut);
        other.ordre = this.ordre == null ? null : new String(this.ordre);
        for (ChampModel cm : this.listeChamps) {
            ChampModel cm2 = cm.clone();
            try {
                other.addChild((XmlMarshallable)cm2, "champ");
            }
            catch (SAXException ignore) {}
        }
        other.champs.putAll(this.champs);
        for (HiddenModel hm : this.hiddens) {
            try {
                other.addChild((XmlMarshallable)hm.clone(), "hidden");
            }
            catch (SAXException saxEx) {}
        }
        for (WidgetModel wm : this.widgets) {
            try {
                other.addChild((XmlMarshallable)wm.clone(), "widget");
            }
            catch (SAXException saxEx) {}
        }
        return other;
    }

    public ElementModel getParent() {
        return this.parent;
    }

    public void setParent(ElementModel parent) {
        this.parent = parent;
    }

    public void setOrdre(String ordre) {
        this.ordre = ordre;
    }

    public void setTriDefaut(String triDefaut) {
        this.triDefaut = triDefaut;
    }

    public Vector<HiddenModel> getHiddens() {
        return this.hiddens;
    }

    public void setParentAsNoeudModifiable(NoeudModifiable p) {
        this._NMParent = p;
    }

    public NoeudModifiable getParentAsNoeudModifiable() {
        return this._NMParent;
    }

    public NoeudModifiable getChildAsNoeudModifiable(String tagName, String id) {
        if ("champ".equals(tagName)) {
            return this.hChampModels.get(id);
        }
        if ("hidden".equals(tagName)) {
            return this.hHiddenModels.get(id);
        }
        if ("widget".equals(tagName)) {
            return this.hWidgets.get(id);
        }
        return null;
    }

    public void modifyAttr(String attrName, String value) {
    }

    public void modifyAttrs(Attributes attrs) {
        try {
            this.getAttributes(new XmlAttributes(attrs));
        }
        catch (Exception e) {
            logger.error((Object)("Erreur lors de la mise \u00e0 jour des attributs : " + e));
        }
    }

    public String[] getChildIdAttrName(String childTagName) {
        if ("champ".equals(childTagName)) {
            return new String[]{"id"};
        }
        if ("hidden".equals(childTagName)) {
            return new String[]{"name"};
        }
        if ("widget".equals(childTagName)) {
            return new String[]{"id"};
        }
        return null;
    }

    public void resetCharData() {
    }

    public String getIdValue() {
        return null;
    }

    public void removeAllChamps() {
        this.champs = new Hashtable();
        this.listeChamps = new Vector();
        this.hChampModels = new HashMap();
    }

    public Vector<WidgetModel> getWidgets() {
        return this.widgets;
    }

    public String getConfigXPath() {
        if (this.configXPath == null) {
            this.configXPath = this.getParentAsNoeudModifiable() != null ? this.getParentAsNoeudModifiable().getConfigXPath() : "";
            this.configXPath = this.configXPath + "/liste-resultat";
        }
        return this.configXPath;
    }
}

