/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.xml.marshal.NoeudModifiable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.xemelios.common.config.BlankModel;
import fr.gouv.finances.cp.xemelios.common.config.ChampModel;
import fr.gouv.finances.cp.xemelios.common.config.CritereModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentModel;
import fr.gouv.finances.cp.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.cp.xemelios.common.config.ElementModel;
import fr.gouv.finances.cp.xemelios.common.config.EnfantModel;
import fr.gouv.finances.cp.xemelios.common.config.EnteteModel;
import fr.gouv.finances.cp.xemelios.common.config.EnvironmentModel;
import fr.gouv.finances.cp.xemelios.common.config.EtatModel;
import fr.gouv.finances.cp.xemelios.common.config.HiddenModel;
import fr.gouv.finances.cp.xemelios.common.config.IgnoredModel;
import fr.gouv.finances.cp.xemelios.common.config.InputModel;
import fr.gouv.finances.cp.xemelios.common.config.ListeResultatModel;
import fr.gouv.finances.cp.xemelios.common.config.NSModel;
import fr.gouv.finances.cp.xemelios.common.config.NamespaceModel;
import fr.gouv.finances.cp.xemelios.common.config.OptionModel;
import fr.gouv.finances.cp.xemelios.common.config.ParameterModel;
import fr.gouv.finances.cp.xemelios.common.config.ParametersModel;
import fr.gouv.finances.cp.xemelios.common.config.PluginModel;
import fr.gouv.finances.cp.xemelios.common.config.PropertyModel;
import fr.gouv.finances.cp.xemelios.common.config.RecherchePaireModel;
import fr.gouv.finances.cp.xemelios.common.config.ReferenceModel;
import fr.gouv.finances.cp.xemelios.common.config.SelectModel;
import fr.gouv.finances.cp.xemelios.common.config.SimpleElement;
import fr.gouv.finances.cp.xemelios.common.config.SpecialKeyEntryModel;
import fr.gouv.finances.cp.xemelios.common.config.SpecialKeyModel;
import fr.gouv.finances.cp.xemelios.common.config.TextModel;
import fr.gouv.finances.cp.xemelios.common.config.VariableModel;
import fr.gouv.finances.cp.xemelios.common.config.XPathModel;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentsDeriveParser
extends DefaultHandler {
    private static Logger logger = Logger.getLogger(DocumentsDeriveParser.class);
    NoeudModifiable current;
    NoeudModifiable oldCurrent = null;
    boolean inConstruction = false;
    String closeConstructionOn = null;
    String baseDirectory;
    private HashMap<String, Class> mapping = new HashMap();
    private DocumentsModel dmsReference = null;
    private DocumentModel dmEnrichi = null;

    public DocumentModel getDmEnrichi() {
        return this.dmEnrichi;
    }

    public DocumentsDeriveParser(DocumentsModel dm, String baseDir) {
        this.dmsReference = dm;
        this.baseDirectory = baseDir;
        this.mapping.put("champ", ChampModel.class);
        this.mapping.put("critere", CritereModel.class);
        this.mapping.put("document", DocumentModel.class);
        this.mapping.put("element", ElementModel.class);
        this.mapping.put("etat", EtatModel.class);
        this.mapping.put("input", InputModel.class);
        this.mapping.put("liste-resultat", ListeResultatModel.class);
        this.mapping.put("option", OptionModel.class);
        this.mapping.put("select", SelectModel.class);
        this.mapping.put("entete", EnteteModel.class);
        this.mapping.put("property", PropertyModel.class);
        this.mapping.put("plugin", PluginModel.class);
        this.mapping.put("special-key", SpecialKeyModel.class);
        this.mapping.put("special-key-entry", SpecialKeyEntryModel.class);
        this.mapping.put("blank", BlankModel.class);
        this.mapping.put("namespaces", NamespaceModel.class);
        this.mapping.put("ns", NSModel.class);
        this.mapping.put("recherche-paire", RecherchePaireModel.class);
        this.mapping.put("collectivite-path", RecherchePaireModel.class);
        this.mapping.put("budget-path", RecherchePaireModel.class);
        this.mapping.put("valeur", XPathModel.class);
        this.mapping.put("path", XPathModel.class);
        this.mapping.put("code-path", XPathModel.class);
        this.mapping.put("libelle-path", XPathModel.class);
        this.mapping.put("libelles", IgnoredModel.class);
        this.mapping.put("tag", IgnoredModel.class);
        this.mapping.put("enum", IgnoredModel.class);
        this.mapping.put("champ-optionnel", ChampModel.class);
        this.mapping.put("default-budget", OptionModel.class);
        this.mapping.put("desc", OptionModel.class);
        this.mapping.put("header", OptionModel.class);
        this.mapping.put("liste-export", ListeResultatModel.class);
        this.mapping.put("key1", TextModel.class);
        this.mapping.put("key2", TextModel.class);
        this.mapping.put("reference", ReferenceModel.class);
        this.mapping.put("variable", VariableModel.class);
        this.mapping.put("environment", EnvironmentModel.class);
        this.mapping.put("libelle", TextModel.class);
        this.mapping.put("hidden", HiddenModel.class);
        this.mapping.put("parameters", ParametersModel.class);
        this.mapping.put("parameter", ParameterModel.class);
        this.mapping.put("parent", SimpleElement.class);
        this.mapping.put("enfants", EnfantModel.class);
        this.mapping.put("enfant", SimpleElement.class);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("documents-derives".equals(localName)) {
            return;
        }
        if ("document".equals(localName)) {
            if (this.dmsReference == null || this.dmsReference.getDocuments().size() == 0) {
                throw new SAXException("Aucun document n'est disponible pour h\u00e9ritage.");
            }
            String extendsId = attributes.getValue("extends");
            DocumentModel dmEtendu = this.dmsReference.getDocumentById(extendsId);
            if (dmEtendu == null) {
                throw new SAXException("Configuration de " + extendsId + " introuvable");
            }
            this.dmEnrichi = dmEtendu.clone();
            this.current = this.dmEnrichi;
            this.current.modifyAttrs(attributes);
            this.dmEnrichi.setBaseDirectory(this.baseDirectory);
            this.dmEnrichi.setExtendedDocId(extendsId);
        } else {
            NoeudModifiable child = null;
            String clef = "";
            String[] ob = this.current.getChildIdAttrName(localName);
            if (ob != null) {
                String[] clefs;
                for (String c : clefs = ob) {
                    clef = clef + attributes.getValue(c) + "|";
                }
                if (clef.endsWith("|")) {
                    clef = clef.substring(0, clef.length() - 1);
                }
            }
            if ((child = this.current.getChildAsNoeudModifiable(localName, clef)) == null || this.inConstruction) {
                try {
                    Class[] paramTypes = new Class[]{String.class};
                    Class clazz = this.mapping.get(localName);
                    Constructor ctr = clazz.getConstructor(paramTypes);
                    Object[] params = new Object[]{localName};
                    NoeudModifiable nouveau = (NoeudModifiable)ctr.newInstance(params);
                    nouveau.getAttributes(new XmlAttributes(attributes));
                    this.current.addChild((XmlMarshallable)nouveau, localName);
                    this.current = nouveau;
                    this.closeConstructionOn = localName;
                    this.inConstruction = true;
                }
                catch (Exception e) {
                    logger.error((Object)("Erreur lors de la cr\u00e9ation du noeud (" + localName + ") : "), (Throwable)e);
                    throw new SAXException(e);
                }
            } else {
                this.current = child;
                this.current.modifyAttrs(attributes);
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("documents-derives".equals(localName)) {
            return;
        }
        if ("document".equals(localName)) {
            this.dmsReference.addChild((XmlMarshallable)this.dmEnrichi, "document");
        } else {
            this.current = this.current.getParentAsNoeudModifiable();
            if (this.inConstruction && localName.equals(this.closeConstructionOn)) {
                this.inConstruction = false;
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.current != null) {
            if (!this.current.equals(this.oldCurrent)) {
                this.current.resetCharData();
                this.oldCurrent = this.current;
            }
            this.current.addCharacterData(new String(ch, start, length));
        } else {
            super.characters(ch, start, length);
        }
    }
}

