/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common.config;

import fr.gouv.finances.cp.utils.Amount;
import fr.gouv.finances.cp.utils.xml.marshal.InvalidXmlDefinition;
import fr.gouv.finances.cp.utils.xml.marshal.NoeudModifiable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlAttributes;
import fr.gouv.finances.cp.utils.xml.marshal.XmlMarshallable;
import fr.gouv.finances.cp.utils.xml.marshal.XmlOutputter;
import fr.gouv.finances.cp.xemelios.common.config.XPathModel;
import fr.gouv.finances.cp.xemelios.ui.resulttable.PjRefHandler;
import java.util.Date;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ChampModel
implements NoeudModifiable {
    private static Logger logger = Logger.getLogger(ChampModel.class);
    private String configXPath = null;
    public static final transient String DATATYPE_PJ = "pj-list";
    public static final transient String DATATYPE_DECIMAL = "decimal";
    public static final transient String DATATYPE_AMOUNT = "amount";
    public static final transient String DATATYPE_INTEGER = "integer";
    public static final transient String DATATYPE_DATE = "date";
    public static final transient String TAG = "champ";
    private String tag;
    private String id;
    private String libelle;
    private String datatype;
    private XPathModel path;
    private Class classToReturn = null;
    private boolean checked = false;
    private boolean afficheDefaut = true;
    private boolean sommePossible = false;
    private boolean affichable = true;
    private boolean exportable = false;
    private boolean identifiant = false;
    private NoeudModifiable _NMParent = null;
    private NoeudModifiable parent = null;

    public void setParent(NoeudModifiable parent) {
        this.parent = parent;
    }

    public ChampModel(String tagName) {
        this.tag = tagName;
    }

    public void addCharacterData(String cData) throws SAXException {
    }

    public void addChild(XmlMarshallable child, String tagName) throws SAXException {
        if ("valeur".equals(tagName)) {
            this.path = (XPathModel)child;
            this.path.setParent(this);
            this.path.setParentAsNoeudModifiable(this);
        }
    }

    public XmlMarshallable getAttributes(XmlAttributes attributes) throws SAXException {
        this.id = attributes.getValue("id") != null ? attributes.getValue("id") : this.id;
        this.libelle = attributes.getValue("libelle") != null ? attributes.getValue("libelle") : this.libelle;
        String string = this.datatype = attributes.getValue("datatype") != null ? attributes.getValue("datatype") : this.datatype;
        if (this.datatype == null) {
            this.datatype = "string";
        }
        if (attributes.getValue("checked") != null) {
            this.checked = attributes.getBooleanValue("checked");
        }
        if (attributes.getValue("default-display") != null) {
            this.afficheDefaut = attributes.getBooleanValue("default-display");
        }
        if (attributes.getValue("aggregate") != null) {
            this.sommePossible = attributes.getBooleanValue("aggregate");
        }
        if (attributes.getValue("affichable") != null) {
            this.affichable = attributes.getBooleanValue("affichable");
        }
        if (attributes.getValue("exportable") != null) {
            this.exportable = attributes.getBooleanValue("exportable");
        }
        if (attributes.getValue("identifiant") != null) {
            this.identifiant = attributes.getBooleanValue("identifiant");
        }
        return this;
    }

    public void marshall(XmlOutputter output) {
        output.startTag(this.tag);
        output.addAttribute("id", StringEscapeUtils.escapeXml(this.id));
        output.addAttribute("libelle", StringEscapeUtils.escapeXml(this.libelle));
        output.addAttribute("datatype", StringEscapeUtils.escapeXml(this.datatype));
        if (this.checked) {
            output.addAttribute("checked", "true");
        }
        if (!this.afficheDefaut) {
            output.addAttribute("default-display", "false");
        }
        if (this.sommePossible) {
            output.addAttribute("aggregate", "true");
        }
        this.path.marshall(output);
        output.endTag(this.tag);
    }

    public void validate() throws InvalidXmlDefinition {
        if (this.id == null) {
            throw new InvalidXmlDefinition("//champ/@id is required (" + this.getParentAsNoeudModifiable().getConfigXPath() + "/" + TAG + ")");
        }
        if (this.libelle == null || this.libelle.length() == 0) {
            throw new InvalidXmlDefinition("//champ/@libelle is required (" + this.getConfigXPath() + ")");
        }
        this.path.validate();
    }

    public String getId() {
        return this.id;
    }

    public String getLibelle() {
        return this.libelle;
    }

    public XPathModel getPath() {
        return this.path;
    }

    public Class getDataClass() {
        if (this.classToReturn == null) {
            this.classToReturn = DATATYPE_INTEGER.equalsIgnoreCase(this.datatype) ? Integer.class : (DATATYPE_DECIMAL.equalsIgnoreCase(this.datatype) ? Float.class : (DATATYPE_DATE.equalsIgnoreCase(this.datatype) ? Date.class : (DATATYPE_AMOUNT.equalsIgnoreCase(this.datatype) ? Amount.class : (DATATYPE_PJ.equalsIgnoreCase(this.datatype) ? PjRefHandler.class : String.class))));
        }
        return this.classToReturn;
    }

    public ChampModel clone() {
        ChampModel cm = new ChampModel(this.tag);
        cm.id = this.id;
        cm.libelle = this.libelle;
        cm.datatype = this.datatype;
        try {
            cm.addChild((XmlMarshallable)this.path.clone(), "valeur");
        }
        catch (Throwable t) {
            logger.error((Object)t);
        }
        cm.checked = this.checked;
        cm.afficheDefaut = this.afficheDefaut;
        cm.sommePossible = this.sommePossible;
        cm.affichable = this.affichable;
        cm.identifiant = this.identifiant;
        cm.exportable = this.exportable;
        return cm;
    }

    public boolean equals(Object other) {
        if (other instanceof ChampModel) {
            return ((ChampModel)other).id.equals(this.id);
        }
        return false;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean bChk) {
        this.checked = bChk;
    }

    public boolean isAfficheDefaut() {
        return this.afficheDefaut;
    }

    public void setAfficheDefaut(boolean affDef) {
        this.afficheDefaut = affDef;
    }

    public boolean isSommePossible() {
        return this.sommePossible;
    }

    public void setSommePossible(boolean somPos) {
        this.sommePossible = somPos;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setParentAsNoeudModifiable(NoeudModifiable p) {
        this._NMParent = p;
    }

    public NoeudModifiable getParentAsNoeudModifiable() {
        return this._NMParent;
    }

    public NoeudModifiable getChildAsNoeudModifiable(String tagName, String id) {
        return null;
    }

    public void modifyAttr(String attrName, String value) {
    }

    public void modifyAttrs(Attributes attrs) {
        try {
            this.getAttributes(new XmlAttributes(attrs));
        }
        catch (Exception e) {
            logger.error((Object)("Erreur lors de la mise \u00e0 jour des attributs : " + e));
        }
    }

    public String[] getChildIdAttrName(String childTagName) {
        return null;
    }

    public void resetCharData() {
    }

    public boolean isAffichable() {
        return this.affichable;
    }

    public void setAffichable(boolean affichable) {
        this.affichable = affichable;
    }

    public String getIdValue() {
        return this.getId();
    }

    public boolean isExportable() {
        return this.exportable;
    }

    public boolean isIdentifiant() {
        return this.identifiant;
    }

    public String getConfigXPath() {
        if (this.configXPath == null) {
            this.configXPath = this.getParentAsNoeudModifiable() != null ? this.getParentAsNoeudModifiable().getConfigXPath() : "";
            this.configXPath = this.configXPath + "/champ[@id='" + this.getId() + "']";
        }
        return this.configXPath;
    }
}

