/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.common;

import fr.gouv.finances.cp.xemelios.common.Scramble;
import fr.gouv.finances.cp.xemelios.data.DataConfigurationException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;

public class NetAccess {
    public static HttpClient getHttpClient() throws DataConfigurationException {
        String proxyHost = System.getProperty("xemelios.proxy.server");
        String proxyPort = System.getProperty("xemelios.proxy.port");
        String proxyUser = System.getProperty("xemelios.proxy.user");
        String sTmp = System.getProperty("xemelios.proxy.password");
        String proxyPasswd = sTmp != null ? Scramble.unScramblePassword(sTmp) : null;
        int intProxyPort = 0;
        if (proxyPort != null) {
            try {
                intProxyPort = Integer.parseInt(proxyPort);
            }
            catch (NumberFormatException nfEx) {
                throw new DataConfigurationException(proxyPort + " n'est pas un num\u00e9ro de port valide.");
            }
        }
        HttpClient client = new HttpClient();
        HostConfiguration hc = new HostConfiguration();
        if (proxyHost != null) {
            hc.setProxy(proxyHost, intProxyPort);
            client.setHostConfiguration(hc);
        }
        if (proxyUser != null) {
            client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPasswd));
        }
        return client;
    }
}

