/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.utils.ui;

import fr.gouv.finances.cp.utils.WordWrap;
import fr.gouv.finances.cp.utils.ui.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class DisplayExceptionDlg
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 3979274659365664560L;
    private JButton pbClose = null;
    private JButton pbHideShow = null;
    private JPanel center = null;

    public DisplayExceptionDlg(Dialog owner, Throwable toDisplay) throws HeadlessException {
        super(owner, true);
        this.initialize(toDisplay);
    }

    public DisplayExceptionDlg(Throwable toDisplay) throws HeadlessException {
        this.setModal(true);
        this.initialize(toDisplay);
    }

    public DisplayExceptionDlg(Frame owner, Throwable toDisplay) throws HeadlessException {
        super(owner, "Erreur", true);
        this.initialize(toDisplay);
    }

    protected void initialize(Throwable toDisplay) {
        while (toDisplay.getCause() != null) {
            toDisplay = toDisplay.getCause();
        }
        JPanel pane = new JPanel(new BorderLayout());
        String[] msg = DisplayExceptionDlg.beautify(toDisplay.getMessage());
        JPanel msgPane = new JPanel(new VerticalFlowLayout());
        for (int i = 0; i < msg.length; ++i) {
            msgPane.add(new JLabel(msg[i]));
        }
        pane.add((Component)msgPane, "North");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        while (toDisplay != null) {
            toDisplay.printStackTrace(pw);
            pw.println("caused by...");
            toDisplay = toDisplay.getCause();
        }
        pw.flush();
        String ex = sw.toString();
        pw.close();
        JTextArea ml = new JTextArea(ex);
        ml.setColumns(60);
        ml.setRows(20);
        this.center = new JPanel();
        this.center.add(new JScrollPane(ml));
        pane.add((Component)this.center, "Center");
        this.center.setVisible(false);
        JPanel buttonPane = new JPanel(new FlowLayout(1));
        this.pbClose = new JButton("Fermer");
        buttonPane.add(this.pbClose);
        this.pbHideShow = new JButton("Afficher");
        buttonPane.add(this.pbHideShow);
        pane.add((Component)buttonPane, "South");
        this.setContentPane(pane);
        this.pbClose.addActionListener(this);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.pbHideShow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean visible = DisplayExceptionDlg.this.center.isVisible();
                if (visible) {
                    DisplayExceptionDlg.this.center.setVisible(false);
                    DisplayExceptionDlg.this.pbHideShow.setText("Afficher");
                } else {
                    DisplayExceptionDlg.this.center.setVisible(true);
                    DisplayExceptionDlg.this.pbHideShow.setText("Cacher");
                }
                DisplayExceptionDlg.this.pack();
            }
        });
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        this.dispose();
    }

    public static void displayException(Frame owner, Throwable toDisplay) {
        Displayer code = new Displayer(owner, toDisplay);
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            SwingUtilities.invokeLater(code);
        }
    }

    public static void displayException(Dialog owner, Throwable toDisplay) {
        Displayer code = new Displayer(owner, toDisplay);
        if (SwingUtilities.isEventDispatchThread()) {
            code.run();
        } else {
            SwingUtilities.invokeLater(code);
        }
    }

    protected static String[] beautify(String msg) {
        if (msg == null) {
            return new String[0];
        }
        String s = WordWrap.wrap(msg, 80);
        StringTokenizer st = new StringTokenizer(s, "\n\r\f");
        String[] ret = new String[st.countTokens()];
        for (int i = 0; i < st.countTokens(); ++i) {
            ret[i] = st.nextToken();
        }
        return ret;
    }

    private static class Displayer
    implements Runnable {
        private Frame fOwner;
        private Dialog dOwner;
        private Throwable t;

        public Displayer(Frame owner, Throwable t) {
            this.fOwner = owner;
            this.t = t;
        }

        public Displayer(Dialog owner, Throwable t) {
            this.dOwner = owner;
            this.t = t;
        }

        public void run() {
            if (this.fOwner != null) {
                new DisplayExceptionDlg(this.fOwner, this.t);
            } else {
                new DisplayExceptionDlg(this.dOwner, this.t);
            }
        }
    }
}

