/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class IoUtils {
    public static InputStream getInputStream(String fileName) throws IOException {
        File f = new File(fileName);
        if (!f.exists()) {
            throw new IOException("File not found: " + fileName);
        }
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
        byte[] b = new byte[256];
        StringBuffer buff = new StringBuffer();
        int read = bis.read(b);
        while (read > 0) {
            buff.append(new String(b, 0, read));
            read = bis.read(b);
        }
        String ret = buff.toString().replaceAll("@@XSL_LOCATION@@", "file:///" + f.getPath().replace('\\', '/'));
        String encoding = IoUtils.getEncoding(ret);
        return new ByteArrayInputStream(ret.getBytes(encoding));
    }

    public static String getEncoding(String buffer) {
        String ret = "UTF-8";
        String buff = new String(buffer);
        try {
            buff = buff.substring(buff.indexOf("<?"));
            String header = buff = buff.substring(0, buff.indexOf("?>") + 2);
            int encodingPos = header.indexOf("encoding=");
            if (encodingPos >= 0) {
                String s = header.substring(encodingPos + 9);
                ret = s.startsWith("\"") ? s.substring(1, s.indexOf(34, 1)) : ((s = s.substring(0, s.length() - 2).trim()).indexOf(32) > 0 ? s.substring(0, s.indexOf(32)) : s);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }
}

