/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.dgfip.xemelios.rsa.importer;

import fr.gouv.finances.dgfip.utils.Pair;
import fr.gouv.finances.dgfip.utils.xml.SAXWriter;
import fr.gouv.finances.dgfip.xemelios.auth.XemeliosUser;
import fr.gouv.finances.dgfip.xemelios.common.FileInfo;
import fr.gouv.finances.dgfip.xemelios.importers.DefaultImporter;
import fr.gouv.finances.dgfip.xemelios.utils.XmlUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class RSAImporter
extends DefaultImporter {
    private static final Logger logger = Logger.getLogger(RSAImporter.class);
    public static final String COLLECTIVITE_TYPE_PATH = "/Racine/InfosFinancieresFoyerRSA/IdentificationRSA/Partenaire/TYPEPARTE";
    public static final String COLLECTIVITE_LIB_PATH = "/Racine/InfosFinancieresFoyerRSA/IdentificationRSA/Partenaire/IDEPARTE";
    public static final String BUDGET_PATH1 = "/Racine/InfosFinancieresFoyerRSA/IdentificationRSA/Organisme/FONORG";
    public static final String BUDGET_PATH2 = "/Racine/InfosFinancieresFoyerRSA/IdentificationRSA/Organisme/NUMORG";
    public static final String PERIODE_PATH = "/Racine/InfosFinancieresFoyerRSA/AcompteRSA/GeneraliteAcompteRSA/MOISMOUCOMPTA";
    private static final String EXPECTED_ERROR = "EXPECTED_ERROR";
    public static final String ETAT_BALISE = "DemandesRSA";
    public static final String ETAT_TOTALISATION = "Totalisations";
    public static final String PERIODE = "Periode";
    private File outputTmpFile;

    public RSAImporter(XemeliosUser user) {
        super(user);
    }

    protected FileInfo importFile(File f) throws Exception {
        this.getImpSvcProvider().startLongWait();
        File newFile = this.wrapFile(f);
        this.getImpSvcProvider().endLongWait();
        FileInfo fi = super.importFile(newFile);
        newFile.delete();
        return fi;
    }

    public void done() {
        super.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File wrapFile(File f) {
        SAXParserFactory fact = SAXParserFactory.newInstance();
        fact.setNamespaceAware(true);
        this.outputTmpFile = new File(this.getTmpDir(), f.getName());
        while (this.outputTmpFile.exists()) {
            if (this.outputTmpFile.equals(f)) {
                File tmpDir = this.outputTmpFile.getParentFile();
                tmpDir = new File(tmpDir, "TMP-DIR");
                tmpDir.mkdirs();
                this.outputTmpFile = new File(tmpDir, f.getName());
                continue;
            }
            this.outputTmpFile.delete();
        }
        OutputStream fos = null;
        try {
            SAXParser collParser = fact.newSAXParser();
            CollHandler handler = new CollHandler((NamespaceContext)this.getDocumentModel().getNamespaces());
            String collectivite = "";
            String periode = "";
            try {
                collParser.parse(f, (DefaultHandler)handler);
            }
            catch (SAXException saxEx) {
                if (EXPECTED_ERROR.equals(saxEx.getMessage())) {
                    collectivite = handler.getCollectivite();
                    periode = handler.getPeriode();
                }
                throw saxEx;
            }
            fos = new FileOutputStream(this.outputTmpFile);
            String encoding = RSAImporter.getFileEncoding((File)f);
            final String passedColl = collectivite;
            final String passedPeriode = periode;
            final Pair budget = new Pair(handler.getBudgetCode(), handler.getBudgetLibelle());
            SAXWriter writer = new SAXWriter(fos, encoding){
                private boolean alreadyCreatedEtat;
                {
                    super(x0, x1);
                    this.alreadyCreatedEtat = false;
                }

                public void startDocument() throws SAXException {
                    super.startDocument();
                    this.startPrefixMapping("added", "http://projets.admisource.gouv.fr/xemelios/namespaces#added");
                }

                public void endDocument() throws SAXException {
                    this.endPrefixMapping("added");
                    super.endDocument();
                }

                public void processingInstruction(String target, String data) throws SAXException {
                }

                public void endElement(String uri, String localName, String qName) throws SAXException {
                    super.endElement(uri, localName, qName);
                    if ("TotalisationAcompte".equals(localName)) {
                        this.endElement("", RSAImporter.ETAT_TOTALISATION, new QName("", RSAImporter.ETAT_TOTALISATION, "").toString());
                    }
                }

                public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                    if (!this.alreadyCreatedEtat && localName.equals("InfosFinancieresFoyerRSA")) {
                        this.startElement("", RSAImporter.ETAT_BALISE, new QName("", RSAImporter.ETAT_BALISE, "").toString(), new AttributesImpl());
                        this.alreadyCreatedEtat = true;
                    }
                    if (this.alreadyCreatedEtat && localName.equals("TotalisationAcompte")) {
                        this.endElement("", RSAImporter.ETAT_BALISE, new QName("", RSAImporter.ETAT_BALISE, "").toString());
                        this.startElement("", RSAImporter.ETAT_TOTALISATION, new QName("", RSAImporter.ETAT_TOTALISATION, "").toString(), new AttributesImpl());
                    }
                    super.startElement(uri, localName, qName, atts);
                    if (localName.equals("Racine")) {
                        this.startElement("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "Collectivite", new QName("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "Collectivite", "added").toString(), new AttributesImpl());
                        this.characters(passedColl.toCharArray(), 0, passedColl.length());
                        this.endElement("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "Collectivite", new QName("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "Collectivite", "added").toString());
                        AttributesImpl attrs = new AttributesImpl();
                        attrs.addAttribute("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "code", "", "xs:string", budget.key);
                        attrs.addAttribute("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "libelle", "", "xs:string", budget.libelle);
                        this.startElement("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "Budget", new QName("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "Budget", "added").toString(), attrs);
                        this.endElement("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "Budget", new QName("http://projets.admisource.gouv.fr/xemelios/namespaces#added", "Budget", "added").toString());
                        this.startElement("", RSAImporter.PERIODE, new QName("", RSAImporter.PERIODE, "").toString(), new AttributesImpl());
                        this.characters(passedPeriode.toCharArray(), 0, passedPeriode.length());
                        this.endElement("", RSAImporter.PERIODE, new QName("", RSAImporter.PERIODE, "").toString());
                    }
                }
            };
            writer.setPrettyPrint(false);
            SAXParser parser = fact.newSAXParser();
            parser.parse(f, (DefaultHandler)writer);
        }
        catch (Exception ex) {
            logger.error((Object)"wrapFile(File):", (Throwable)ex);
        }
        finally {
            try {
                fos.flush();
                ((FileOutputStream)fos).close();
            }
            catch (Throwable t) {}
        }
        return this.outputTmpFile;
    }

    private class CollHandler
    extends DefaultHandler {
        Stack<QName> stack;
        NamespaceContext nsCtx;
        Stack<StringBuffer> textContent;
        private StringBuffer collectivite;
        private StringBuffer budgetLib;
        private String periode;
        private String budgetCode;
        private String collFirstPart;
        private String collSecondPart;
        private String budgFirstPart;
        private String budgSecondPart;
        private String budgCode;
        private boolean collFirstPartDone = false;
        private boolean collSecondPartDone = false;
        private boolean periodeDone = false;
        private boolean budgFirstPartDone = false;
        private boolean budgSecondPartDone = false;
        private boolean budgCodeDone = false;

        public String getCollectivite() {
            return this.collectivite.toString();
        }

        public String getPeriode() {
            return this.periode;
        }

        public String getBudgetCode() {
            return this.budgCode;
        }

        public String getBudgetLibelle() {
            return this.budgetLib.toString();
        }

        public CollHandler(NamespaceContext nsCtx) {
            this.nsCtx = nsCtx;
            this.stack = new Stack();
            this.textContent = new Stack();
            this.collectivite = new StringBuffer();
            this.budgetLib = new StringBuffer();
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            QName qname = XmlUtils.getQName((String)uri, (String)localName, (String)qName);
            this.stack.push(qname);
            this.textContent.push(new StringBuffer());
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            String pathTag = XmlUtils.getPath(this.stack, (NamespaceContext)this.nsCtx);
            if (RSAImporter.COLLECTIVITE_TYPE_PATH.equals(pathTag)) {
                this.collFirstPart = this.textContent.peek().toString().trim();
                this.collFirstPartDone = true;
            } else if (RSAImporter.COLLECTIVITE_LIB_PATH.equals(pathTag)) {
                this.collSecondPart = this.textContent.peek().toString().trim();
                this.collSecondPartDone = true;
            } else if (RSAImporter.PERIODE_PATH.equals(pathTag)) {
                this.periode = this.textContent.peek().toString();
                this.periodeDone = true;
            } else if (RSAImporter.BUDGET_PATH1.equals(pathTag)) {
                this.budgFirstPart = this.textContent.peek().toString().trim();
                this.budgFirstPartDone = true;
            } else if (RSAImporter.BUDGET_PATH2.equals(pathTag)) {
                this.budgSecondPart = this.textContent.peek().toString().trim();
                this.budgSecondPartDone = true;
            }
            if (this.collFirstPartDone && this.collSecondPartDone && this.periodeDone && this.budgFirstPartDone && this.budgSecondPartDone) {
                this.collectivite.append(this.collFirstPart).append(this.collSecondPart);
                this.budgetLib.append(this.budgFirstPart).append(this.budgSecondPart);
                throw new SAXException(RSAImporter.EXPECTED_ERROR);
            }
            this.stack.pop();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            String s = new String(ch, start, length);
            this.textContent.peek().append(s);
        }
    }
}

