/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugin.signerfichier;

import fr.gouv.finances.cp.xemelios.plugin.signerfichier.DlgKeystore;
import fr.gouv.finances.cp.xemelios.plugin.signerfichier.IKeystoreValider;
import fr.gouv.finances.cp.xemelios.plugin.signerfichier.IStatusReporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class KeystoreFiller
implements IKeystoreValider {
    private static final Logger logger = Logger.getLogger(KeystoreFiller.class);
    public static final int LOADKSOK = 2;
    public static final int LOADPKOK = 4;
    public static final int ALGORITHMOK = 8;
    int status = 0;
    KeyStore targetKs = KeyStore.getInstance(KeystoreFiller.kstypeFromSuffix("pfx"));
    KeyStore inputKs = null;
    private String keystorePassword;
    private File keystoreFile;
    private String alias;
    private String aliasPassword;
    private DlgKeystore dlgKeystore;
    private IStatusReporter statusReporter;
    private String statusString = null;

    public boolean loadKsOK() {
        return (this.status & 2) != 0;
    }

    public boolean loadPkOK() {
        return (this.status & 4) != 0;
    }

    public boolean algoIdOK() {
        return (this.status & 8) != 0;
    }

    protected void setLoadKsOK(boolean b) {
        this.status = b ? (this.status |= 2) : (this.status &= 0xFFFFFFFD);
    }

    protected void setLoadPkOK(boolean b) {
        this.status = b ? (this.status |= 4) : (this.status &= 0xFFFFFFFB);
    }

    protected void setAlgorithmOK(boolean b) {
        this.status = b ? (this.status |= 8) : (this.status &= 0xFFFFFFF7);
    }

    protected static String kstypeFromSuffix(String suffix) {
        if (suffix.equalsIgnoreCase("jks") || suffix.equalsIgnoreCase("ks")) {
            return "JKS";
        }
        if (suffix.equalsIgnoreCase("jce")) {
            return "JCEKS";
        }
        if (suffix.equalsIgnoreCase("p12") || suffix.equalsIgnoreCase("pfx")) {
            return "PKCS12";
        }
        return null;
    }

    KeystoreFiller() throws Exception {
        this.targetKs.load(null, null);
    }

    KeystoreFiller(File keystoreFile, String keystorePassword) throws Exception {
        FileInputStream fis = new FileInputStream(keystoreFile);
        logger.info((Object)("loading " + keystoreFile.getName()));
        this.targetKs.load(fis, keystorePassword.toCharArray());
    }

    public void loadKeystore(File keystoreFile, String keystorePassword) throws Exception {
        int n = keystoreFile.getName().lastIndexOf(46);
        String extension = keystoreFile.getName().substring(n + 1);
        this.inputKs = KeyStore.getInstance(KeystoreFiller.kstypeFromSuffix(extension));
        FileInputStream fis = new FileInputStream(keystoreFile);
        logger.info((Object)("loading " + keystoreFile.getName()));
        try {
            this.inputKs.load(fis, keystorePassword.toCharArray());
        }
        catch (Exception e) {
            this.setLoadKsOK(false);
            return;
        }
        this.setLoadKsOK(true);
    }

    public void importAliases(String newPassword) throws Exception {
        Enumeration<String> e = this.inputKs.aliases();
        while (e.hasMoreElements()) {
            String curalias = e.nextElement();
            if (!this.inputKs.isCertificateEntry(curalias) && !this.inputKs.isKeyEntry(curalias)) continue;
            logger.info((Object)(curalias + "isCertificateEntry"));
            this.setAlias(curalias);
            this.setAliasPassword(this.getKeystorePassword());
            this.loadAlias(newPassword);
            if (this.loadPkOK()) continue;
            if (this.algoIdOK()) {
                this.dlgKeystore.setTitle("Ouverture de la cle priv\u00e9e  " + curalias);
                this.dlgKeystore.setMode(2);
                this.dlgKeystore.setVisible(true);
                if (this.loadPkOK()) continue;
                if (this.algoIdOK()) {
                    this.setStatusString("Mauvais mot de passe");
                }
                this.statusReporter.error(this.getStatusString(), "Cl\u00e9 non charg\u00e9e");
                continue;
            }
            this.statusReporter.error(this.getStatusString(), "Cl\u00e9 non charg\u00e9e");
        }
    }

    public void saveKeystore(File outFile, String keystorePassword) throws Exception {
        if (this.targetKs != null) {
            FileOutputStream fos = new FileOutputStream(outFile);
            this.targetKs.store(fos, keystorePassword.toCharArray());
        }
    }

    public static void main(String[] args) {
        try {
            String password = "jna";
            File outFile = new File(args[0]);
            KeystoreFiller fks = new KeystoreFiller(outFile, password);
            for (int i = 1; i < args.length; ++i) {
                File cur = new File(args[i]);
                fks.loadKeystore(cur, password);
            }
            fks.saveKeystore(outFile, password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setKeystorePassword(String password) {
        this.keystorePassword = password;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void loadKeystore() throws Exception {
        if (this.getKeystoreFile() != null) {
            this.loadKeystore(this.keystoreFile, this.keystorePassword);
        }
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setAliasPassword(String password) {
        this.aliasPassword = password;
    }

    public void loadAlias() {
        this.loadAlias(null);
    }

    public void loadAlias(String newPassword) {
        try {
            if (newPassword == null) {
                newPassword = this.aliasPassword;
            }
            this.setLoadPkOK(false);
            this.setAlgorithmOK(true);
            Certificate[] chain = this.inputKs.getCertificateChain(this.alias);
            Key key = this.inputKs.getKey(this.alias, this.aliasPassword.toCharArray());
            PrivateKey privateKey = (PrivateKey)key;
            String pkAlgo = privateKey.getAlgorithm();
            if (pkAlgo.equals("RSA") || pkAlgo.equals("DSA")) {
                this.targetKs.setKeyEntry(this.alias, key, newPassword.toCharArray(), chain);
                this.setLoadPkOK(true);
                this.setAlgorithmOK(true);
            } else {
                System.err.println("Algorithme non valable " + pkAlgo);
                this.setStatusString("La cl\u00e9 " + this.alias + " utilise un algorithme inconnu ou non utilisable : " + pkAlgo);
                this.setLoadPkOK(false);
                this.setAlgorithmOK(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public File getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(File keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    public DlgKeystore getDlgKeystore() {
        return this.dlgKeystore;
    }

    public void setDlgKeystore(DlgKeystore dlgKeystore) {
        this.dlgKeystore = dlgKeystore;
    }

    public IStatusReporter getStatusReporter() {
        return this.statusReporter;
    }

    public void setStatusReporter(IStatusReporter statusReporter) {
        this.statusReporter = statusReporter;
    }

    public String getStatusString() {
        return this.statusString;
    }

    public void setStatusString(String statusString) {
        this.statusString = statusString;
    }
}

