/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugin.signerfichier;

import fr.gouv.finances.cp.xemelios.plugin.signerfichier.Actions;
import fr.gouv.finances.cp.xemelios.plugin.signerfichier.SignerFichierPlugin;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.spi.wizard.WizardPage;

public class InputFilePanel
extends WizardPage {
    private static final Logger logger = Logger.getLogger(InputFilePanel.class);
    private static final long serialVersionUID = 7621780388749506917L;
    private JButton jButtonInputFile;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JButton pbViewFile;
    private JTextField textFieldInputFile;

    public InputFilePanel() {
        this.initComponents();
    }

    void showSelectedInputFile(File f) {
        this.textFieldInputFile.setText(f.getAbsolutePath());
        if (SignerFichierPlugin.isInXemelios()) {
            this.pbViewFile.setEnabled(true);
        }
    }

    protected String validateContents(Component comp, Object o) {
        if (this.textFieldInputFile.getText().length() == 0) {
            return "S\u00e9lectionner un fichier SVP";
        }
        return null;
    }

    public static final String getDescription() {
        return "S\u00e9lection du fichier \u00e0 signer";
    }

    private void initComponents() {
        this.textFieldInputFile = new JTextField();
        this.jButtonInputFile = new JButton();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.pbViewFile = new JButton();
        this.textFieldInputFile.setEditable(false);
        this.textFieldInputFile.setName("TextFieldInputFile");
        this.jButtonInputFile.setText("...");
        this.jButtonInputFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InputFilePanel.this.jButtonInputFileActionPerformed(evt);
            }
        });
        this.jLabel3.setFont(new Font("Tahoma", 1, 10));
        this.jLabel3.setText("Utiliser le bouton de navigation ... pour s\u00e9lectionner le fichier \u00e0 signer");
        this.jLabel4.setText("Fichier \u00e0 signer");
        this.pbViewFile.setText("Visualiser le fichier...");
        this.pbViewFile.setEnabled(false);
        this.pbViewFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InputFilePanel.this.pbViewFileActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.textFieldInputFile, -1, 513, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonInputFile).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3, -1, -1, Short.MAX_VALUE).add(212, 212, 212)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel4).addContainerGap(479, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.pbViewFile).addContainerGap(412, Short.MAX_VALUE)))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(20, 20, 20).add((Component)this.jLabel4).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonInputFile).add((Component)this.textFieldInputFile, -2, -1, -2)).addPreferredGap(1).add((Component)this.jLabel3, -2, 14, -2).addPreferredGap(0).add((Component)this.pbViewFile).addContainerGap(209, Short.MAX_VALUE)));
    }

    private void jButtonInputFileActionPerformed(ActionEvent evt) {
        try {
            Actions.getInstance().chooseInputFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Actions.getInstance().getFileToSign() != null) {
            this.showSelectedInputFile(Actions.getInstance().getFileToSign());
            this.setProblem(null);
        }
    }

    private void pbViewFileActionPerformed(ActionEvent evt) {
        Runnable r = new Runnable(){

            public void run() {
                try {
                    String cpSeparator = System.getProperty("path.separator");
                    File libDir = new File(System.getProperty("xemelios.lib"));
                    StringBuffer cp = new StringBuffer();
                    if (libDir.exists()) {
                        File[] jars;
                        for (File jar : jars = libDir.listFiles(new FileFilter(){

                            public boolean accept(File pathname) {
                                return pathname.getName().endsWith(".jar");
                            }
                        })) {
                            cp.append(jar.getAbsolutePath()).append(cpSeparator);
                        }
                    }
                    if (cp.length() > 0) {
                        cp.deleteCharAt(cp.length() - 1);
                    }
                    ArrayList<String> cmds = new ArrayList<String>();
                    boolean windows = System.getProperty("os.name").toUpperCase().indexOf("WINDOWS") >= 0;
                    String fileName = InputFilePanel.this.textFieldInputFile.getText();
                    cmds.add(windows ? "javaw" : "java");
                    cmds.add("-cp");
                    cmds.add(cp.toString());
                    cmds.add("-Dxemelios.documents.def.dir=" + System.getProperty("xemelios.documents.def.dir") + "");
                    cmds.add("fr.gouv.finances.cp.xemelios.ui.ViewXemeliosDocument");
                    cmds.add(fileName);
                    cmds.add("PES_Aller");
                    ProcessBuilder pb2 = new ProcessBuilder(cmds);
                    pb2.directory(new File(System.getProperty("xemelios.prg") + "/root"));
                    pb2.start();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        };
        Thread th = new Thread(r);
        th.start();
    }
}

