/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugin.signerfichier;

import fr.gouv.finances.cp.xemelios.plugin.signerfichier.DlgDefinePassword;
import fr.gouv.finances.cp.xemelios.plugin.signerfichier.DlgKeystore;
import fr.gouv.finances.cp.xemelios.plugin.signerfichier.FileSignerFactory;
import fr.gouv.finances.cp.xemelios.plugin.signerfichier.IFileSigner;
import fr.gouv.finances.cp.xemelios.plugin.signerfichier.IKeystoreValider;
import fr.gouv.finances.cp.xemelios.plugin.signerfichier.IStatusReporter;
import fr.gouv.finances.cp.xemelios.plugin.signerfichier.KeystoreFiller;
import fr.gouv.finances.cp.xemelios.plugin.signerfichier.W32CryptExporter;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentsModel;
import fr.gouv.finances.dgfip.xemelios.common.config.Loader;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.xml.namespace.NamespaceContext;
import org.apache.log4j.Logger;

public class Actions {
    private static Actions _instance = null;
    private File fileToSign = null;
    private File fileToGenerate = null;
    private File xemeliosCertFile = null;
    static Logger logger = Logger.getLogger(Actions.class);
    protected JFileChooser fc;
    IFileSigner signer = null;
    private boolean busy = false;
    private Frame parentWindow;
    private DlgKeystore dialogKeystore = null;
    private String xemeliosCertPassword = "xemelios";
    private String xemeliosCertFilename = "privatekeys";
    private static final String USER_HOME_KEY = "user.home";
    public static final String USER_HOME = Actions.getSystemProperty("user.home");
    private OptionsPaneStatusReporter statusReporter = null;

    private Actions() {
        _instance = this;
        this.statusReporter = new OptionsPaneStatusReporter();
        this.initCertFile();
        this.initSigner();
    }

    private static String getSystemProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException ex) {
            System.err.println("Caught a SecurityException reading the system property '" + property + "'; the SystemUtils property value will default to null.");
            return null;
        }
    }

    public static Actions getInstance() {
        if (_instance == null) {
            _instance = new Actions();
        }
        return _instance;
    }

    public void dispose() {
        if (this.signer != null) {
            this.signer.dispose();
            this.signer = null;
        }
        if (this.dialogKeystore != null) {
            this.dialogKeystore.dispose();
            this.dialogKeystore = null;
        }
    }

    public void ShowInputFileSelector() {
        this.fc = this.getFileToSign() != null ? new JFileChooser(this.getFileToSign()) : new JFileChooser(".");
        this.fc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toUpperCase().endsWith("XML");
            }

            public String getDescription() {
                return "Document XML";
            }
        });
        this.fc.showOpenDialog(null);
        this.setFileToSign(this.fc.getSelectedFile());
    }

    public File SelectCertFile() {
        this.fc = this.getXemeliosCertFile() != null ? new JFileChooser(this.getXemeliosCertFile()) : new JFileChooser(".");
        this.fc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toUpperCase().endsWith("KS") || f.getName().toUpperCase().endsWith("JKS") || f.getName().toUpperCase().endsWith("JCE") || f.getName().toUpperCase().endsWith("P12") || f.getName().toUpperCase().endsWith("PFX");
            }

            public String getDescription() {
                return "Magasins de cl\u00e9s (.ks, .jks, .jce, .p12, .pks)";
            }
        });
        this.fc.showOpenDialog(null);
        return this.fc.getSelectedFile();
    }

    public void ShowCertFileSelector() {
        this.fc = this.getXemeliosCertFile() != null ? new JFileChooser(this.getXemeliosCertFile()) : new JFileChooser(".");
        this.fc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toUpperCase().endsWith("KS") || f.getName().toUpperCase().endsWith("JKS") || f.getName().toUpperCase().endsWith("JCE") || f.getName().toUpperCase().endsWith("P12") || f.getName().toUpperCase().endsWith("PFX");
            }

            public String getDescription() {
                return "Magasins de cl\u00e9s (.ks, .jks, .jce, .p12, .pks)";
            }
        });
        this.fc.showOpenDialog(null);
        this.setXemeliosCertFile(this.fc.getSelectedFile());
    }

    public void fillFromFile(File f) throws Exception {
        this.fillFromFile(f, null);
    }

    public void fillFromFile(File f, String forcedPassword) throws Exception {
        KeystoreFiller ksf = null;
        ksf = this.xemeliosCertFile.exists() ? new KeystoreFiller(this.xemeliosCertFile, this.xemeliosCertPassword) : new KeystoreFiller();
        ksf.setStatusReporter(this.statusReporter);
        if (f == null) {
            f = this.SelectCertFile();
        }
        if (f != null && f.exists()) {
            DlgKeystore tmpDlgK = new DlgKeystore(this.parentWindow, true);
            tmpDlgK.setValider(ksf);
            ksf.setDlgKeystore(tmpDlgK);
            ksf.setKeystoreFile(f);
            ksf.setKeystorePassword(this.xemeliosCertPassword);
            tmpDlgK.setMode(1);
            this.openCertFile(f, tmpDlgK, ksf);
            if (ksf.loadKsOK()) {
                ksf.importAliases(forcedPassword);
                ksf.saveKeystore(this.xemeliosCertFile, this.xemeliosCertPassword);
            }
        }
    }

    public void fillFromWindows(Window parent, boolean tous) throws Exception {
        W32CryptExporter wce = new W32CryptExporter(parent);
        if (tous) {
            wce.exportAll(this.xemeliosCertPassword);
        } else {
            wce.exportSelected(this.xemeliosCertPassword);
        }
        if (wce.getGeneratedFiles() != null) {
            logger.info((Object)("wce.getGeneratedFiles().size()=" + wce.getGeneratedFiles().size()));
            for (File f : wce.getGeneratedFiles()) {
                DlgDefinePassword dlgDefinePassword = new DlgDefinePassword(this.parentWindow, true);
                dlgDefinePassword.setVisible(true);
                this.fillFromFile(f, dlgDefinePassword.getPassword());
                f.delete();
            }
        }
    }

    public void ShowOutputFileSelector() {
        this.fc = this.getFileToGenerate() != null ? new JFileChooser(this.getFileToGenerate()) : new JFileChooser(".");
        this.fc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toUpperCase().endsWith("XML");
            }

            public String getDescription() {
                return "Document XML";
            }
        });
        this.fc.showSaveDialog(null);
        this.setFileToGenerate(this.fc.getSelectedFile());
        if (this.getFileToGenerate() == null) {
            return;
        }
        if (!this.fileToGenerate.getName().toUpperCase().endsWith("XML")) {
            this.setFileToGenerate(new File(this.getFileToGenerate().getPath() + ".xml"));
        }
        if (this.fileToGenerate.exists()) {
            int response = JOptionPane.showConfirmDialog(this.parentWindow, new String[]{"Le fichier " + this.fileToGenerate.getName(), "existe et sera \u00e9cras\u00e9"}, "Remplacer le fichier?", 0, 2);
            switch (response) {
                case 0: {
                    return;
                }
                case 1: {
                    this.setFileToGenerate(null);
                    return;
                }
                case -1: {
                    this.setFileToGenerate(null);
                    return;
                }
            }
        }
    }

    protected void initCertFile() {
        if (USER_HOME != null) {
            File certDir = new File(USER_HOME, "xemelios");
            if (!certDir.exists()) {
                certDir.mkdirs();
            }
            this.setXemeliosCertFile(new File(certDir, this.xemeliosCertFilename));
        }
    }

    protected void initSigner() {
        DocumentModel docModel = null;
        DocumentsModel docModels = null;
        try {
            docModels = Loader.getDocumentsInfos(null);
            docModel = docModels.getDocumentById("PES_Aller");
            logger.info((Object)docModel);
            File modelBaseDirectory = new File(docModel.getBaseDirectory());
            FileSignerFactory fsf = FileSignerFactory.newInstance();
            fsf.setAttribute(FileSignerFactory.USE_APACHEXMLSEC, true);
            fsf.setNsCtx((NamespaceContext)docModel.getNamespaces());
            this.signer = fsf.newFileSigner();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chooseInputFile() {
        this.ShowInputFileSelector();
        if (this.getFileToSign() == null) {
            return;
        }
        this.signer.setInputFile(this.getFileToSign());
        try {
            this.setBusy(true);
            this.signer.loadInputFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
        finally {
            this.setBusy(false);
        }
        if (!this.signer.parseOK()) {
            this.showStatus();
        }
    }

    public void openCertFile() {
        if (this.dialogKeystore == null) {
            JFrame frame = new JFrame("test");
            this.dialogKeystore = new DlgKeystore((Frame)frame, true);
        }
        this.signer.setKeystorePassword(this.xemeliosCertPassword);
        this.signer.setKeystoreFile(this.xemeliosCertFile);
        this.openCertFile(null, this.dialogKeystore, (IKeystoreValider)this.signer);
    }

    public void openCertFile(File someCertFile, DlgKeystore dlgKeystore, IKeystoreValider valider) {
        if (someCertFile == null) {
            if (!this.getXemeliosCertFile().exists()) {
                return;
            }
            someCertFile = this.getXemeliosCertFile();
        }
        if (valider == null) {
            valider = this.signer;
        }
        try {
            valider.loadKeystore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!valider.loadKsOK()) {
            if (dlgKeystore == null) {
                JFrame frame = new JFrame("test");
                dlgKeystore = new DlgKeystore((Frame)frame, true);
            }
            dlgKeystore.setValider(valider);
            dlgKeystore.setTitle("Ouverture du fichier " + someCertFile.getName());
            try {
                dlgKeystore.setMode(1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            dlgKeystore.setVisible(true);
        }
    }

    public void chooseOutputFile() {
        this.ShowOutputFileSelector();
        if (this.getFileToGenerate() == null) {
            return;
        }
        this.signer.setOutputFile(this.getFileToGenerate());
    }

    public Enumeration getAliases() throws Exception {
        if (this.signer != null && this.signer.loadKsOK()) {
            ArrayList list = Collections.list(this.signer.getAliases());
            Collections.sort(list, new AliasComparator());
            return Collections.enumeration(list);
        }
        return null;
    }

    public String getIssuedFor(String alias) {
        if (this.signer != null && this.signer.loadKsOK()) {
            return this.signer.getIssuedFor(alias);
        }
        return "Echec Readable form de " + alias;
    }

    public String getDetails(String alias) {
        if (this.signer != null && this.signer.loadKsOK()) {
            return this.signer.getDetails(alias);
        }
        return "Echec Readable form de " + alias;
    }

    public String getNomBonhomme(String alias) {
        if (this.signer != null && this.signer.loadKsOK()) {
            return this.signer.getNomBonhomme(alias);
        }
        return "Echec Readable form de " + alias;
    }

    public String getEmetteur(String alias) {
        if (this.signer != null && this.signer.loadKsOK()) {
            return this.signer.getEmetteur(alias);
        }
        return "Echec Readable form de " + alias;
    }

    public Date getDateDebut(String alias) {
        if (this.signer != null && this.signer.loadKsOK()) {
            return this.signer.getDebutValidite(alias);
        }
        return null;
    }

    public Date getDateFin(String alias) {
        if (this.signer != null && this.signer.loadKsOK()) {
            return this.signer.getFinValidite(alias);
        }
        return null;
    }

    public boolean loadAlias(Object o) {
        if (this.signer != null) {
            try {
                this.signer.setAlias((String)o);
                this.signer.setAliasPassword(this.signer.getKeystorePassword());
                this.signer.loadAlias();
                if (!this.signer.loadPkOK()) {
                    if (this.dialogKeystore == null) {
                        JFrame frame = new JFrame("test");
                        this.dialogKeystore = new DlgKeystore((Frame)frame, true);
                    }
                    this.dialogKeystore.setValider((IKeystoreValider)this.signer);
                    this.dialogKeystore.setTitle("Ouverture de la cle priv\u00e9e  " + this.signer.getAlias());
                    this.dialogKeystore.setMode(2);
                    this.dialogKeystore.setVisible(true);
                }
                return this.signer.loadPkOK();
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public String getAliasName() {
        return this.signer.getAlias();
    }

    public File getFileToSign() {
        return this.fileToSign;
    }

    public void setFileToSign(File fileToSign) {
        if (fileToSign == null) {
            return;
        }
        this.fileToSign = fileToSign;
        File parent = fileToSign.getParentFile();
        String fileName = fileToSign.getName();
        String newFileName = fileName.substring(0, fileName.lastIndexOf(46)) + ".signe.xml";
        this.setFileToGenerate(new File(parent, newFileName));
        this.signer.setOutputFile(this.getFileToGenerate());
    }

    public String getSignStatusString() {
        String bla = this.signer != null ? this.signer.getStatusAsString() : "Une erreur inattendue est survenue; veuillez consulter le log de l'application";
        return bla;
    }

    public void showStatus() {
        int sever;
        String bla;
        if (this.signer != null) {
            bla = this.signer.getStatusAsString();
            sever = this.signer.getStatusAsSeverity();
        } else {
            sever = 2;
            bla = "Une erreur inattendue est survenue; veuillez consulter le log de l'application";
        }
        JOptionPane.showMessageDialog(this.getParentWindow(), bla, "R\u00e9sultat de la v\u00e9rification", sever == 2 ? 0 : (sever == 1 ? 2 : -1));
    }

    public boolean isBusy() {
        return this.busy;
    }

    void setBusy(boolean busy) {
        if (this.busy != busy) {
            this.busy = busy;
        }
    }

    public Frame getParentWindow() {
        return this.parentWindow;
    }

    public void setParentWindow(Frame parentWindow) {
        this.parentWindow = parentWindow;
    }

    public File getXemeliosCertFile() {
        return this.xemeliosCertFile;
    }

    public void setXemeliosCertFile(File certFile) {
        this.xemeliosCertFile = certFile;
    }

    public File getFileToGenerate() {
        return this.fileToGenerate;
    }

    public void setFileToGenerate(File fileToGenerate) {
        this.fileToGenerate = fileToGenerate;
    }

    public void doSign() throws Exception {
        this.signer.sign();
    }

    private class AliasComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            String a1 = Actions.this.getIssuedFor((String)o1);
            String a2 = Actions.this.getIssuedFor((String)o2);
            return a1.compareToIgnoreCase(a2);
        }

        public boolean equals(Object obj) {
            return false;
        }
    }

    private class OptionsPaneStatusReporter
    implements IStatusReporter {
        OptionsPaneStatusReporter() {
        }

        public void info(String statusMessage, String title) {
            this.show(statusMessage, title, -1);
        }

        public void warning(String statusMessage, String title) {
            this.show(statusMessage, title, 2);
        }

        public void error(String statusMessage, String title) {
            this.show(statusMessage, title, 0);
        }

        private void show(String statusMessage, String title, int sever) {
            JOptionPane.showMessageDialog(Actions.this.parentWindow, statusMessage, title, sever);
        }
    }
}

