/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugin.signerfichier;

import fr.gouv.finances.cp.xemelios.plugin.signerfichier.Actions;
import fr.gouv.finances.cp.xemelios.plugin.signerfichier.IFileSigner;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class AbstractDlgSignerfichier
implements KeyListener,
MouseListener {
    private static final Logger logger = Logger.getLogger(AbstractDlgSignerfichier.class);
    protected JDialog dialog = null;
    protected JFrame parentWindow;
    private boolean busy = false;
    private Component glassPane = null;
    private Component defaultGlassPane = null;

    public AbstractDlgSignerfichier(Frame parent, boolean modal) {
        this.dialog = new JDialog(parent, modal);
        Actions actions = Actions.getInstance();
        actions.setParentWindow(parent);
    }

    public void showStatus(IFileSigner signer) {
        int sever;
        String bla;
        if (signer != null) {
            bla = signer.getStatusAsString();
            sever = signer.getStatusAsSeverity();
        } else {
            sever = 2;
            bla = "Une erreur inattendue est survenue; veuillez consulter le log de l'application";
        }
        JOptionPane.showMessageDialog(this.parentWindow, bla, "R\u00e9sultat de la v\u00e9rification", sever == 2 ? 0 : (sever == 1 ? 2 : -1));
    }

    public boolean isBusy() {
        return this.busy;
    }

    void setBusy(boolean busy) {
        if (this.busy != busy) {
            this.busy = busy;
            if (busy) {
                this.defaultGlassPane = this.dialog.getGlassPane();
                this.dialog.setGlassPane(this.glassPane);
            } else {
                this.dialog.setGlassPane(this.defaultGlassPane);
                this.defaultGlassPane = null;
            }
            this.glassPane.setVisible(busy);
            this.glassPane.setCursor(busy ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor());
            this.dialog.setCursor(this.glassPane.getCursor());
        }
    }

    public void keyTyped(KeyEvent ke) {
        ke.consume();
    }

    public void keyReleased(KeyEvent ke) {
        ke.consume();
    }

    public void keyPressed(KeyEvent ke) {
        ke.consume();
    }

    public void mouseClicked(MouseEvent me) {
        me.consume();
    }

    public void mouseEntered(MouseEvent me) {
        me.consume();
    }

    public void mouseExited(MouseEvent me) {
        me.consume();
    }

    public void mousePressed(MouseEvent me) {
        me.consume();
    }

    public void mouseReleased(MouseEvent me) {
        me.consume();
    }

    protected void initGlassPane() {
        this.glassPane = new JPanel();
        ((JPanel)this.glassPane).setOpaque(false);
        this.glassPane.addKeyListener(this);
        this.glassPane.addMouseListener(this);
    }

    protected void initSigner() {
        this.preInit();
        Actions.getInstance().initSigner();
    }

    protected void preInit() {
    }

    abstract void initOthers();

    abstract void showSelectedInputFile(File var1);

    public void run() {
        this.initGlassPane();
        this.preInit();
        this.initSigner();
        this.initOthers();
        this.dialog.setVisible(true);
    }

    public void close() {
        logger.debug((Object)"closing dialog (DlgSignerFichierBase)");
        SwingUtilities.getWindowAncestor(this.dialog).dispose();
    }
}

