/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugin.signerfichier;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import com.sun.jna.win32.StdCallLibrary;
import java.awt.Window;
import java.io.File;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class W32CryptExporter {
    private static final Logger logger = Logger.getLogger(W32CryptExporter.class);
    private Window parentWindow;
    private Vector<File> generatedFiles;

    public Vector<File> getGeneratedFiles() {
        return this.generatedFiles;
    }

    public void setGeneratedFiles(Vector<File> generatedFiles) {
        this.generatedFiles = generatedFiles;
    }

    public W32CryptExporter(Window parentWindow) {
        this.parentWindow = parentWindow;
        this.generatedFiles = new Vector();
    }

    public void exportSelected(String password) {
        this.generatedFiles.clear();
        Native.setProtected((boolean)true);
        Pointer storeHandle = Crypt32.INSTANCE.CertOpenSystemStoreA(null, "MY");
        if (storeHandle != null) {
            Pointer certContext = null;
            boolean again = true;
            CryptuiWizExportCertContextInfo certContextInfo = new CryptuiWizExportCertContextInfo();
            CryptuiWizExportInfo exportInfo = new CryptuiWizExportInfo();
            certContextInfo.dwExportFormat = 2;
            certContextInfo.fExportChain = true;
            certContextInfo.fExportPrivateKeys = true;
            certContextInfo.pwszPassword = new WString(password);
            certContextInfo.fStrongEncryption = true;
            certContextInfo.write();
            logger.info((Object)certContextInfo);
            exportInfo.pwszExportFileName = new WString("C:\\lolo.pfx");
            exportInfo.dwSubjectChoice = 1;
            exportInfo.pCertContext = certContext;
            exportInfo.rghStores = null;
            exportInfo.cStores = 0;
            while (again) {
                certContext = Cryptui.INSTANCE.CryptUIDlgSelectCertificateFromStore(storeHandle, Native.getWindowPointer((Window)this.parentWindow), new WString("Selection d'un certificat"), new WString("OK pour exporter le certificat s\u00e9lectionn\u00e9, Annuler pour terminer"), 0, 0, null);
                if (certContext != null) {
                    byte[] byteArray = new byte[256];
                    Crypt32.INSTANCE.CertGetNameStringA(certContext, 5, 0, null, byteArray, 128);
                    String nameString = Native.toString((byte[])byteArray);
                    System.out.println("found " + nameString);
                    if (Crypt32.INSTANCE.CryptFindCertificateKeyProvInfo(certContext, 0, null)) {
                        logger.info((Object)("found private key for " + nameString));
                        String filename = new String("C:\\" + nameString + ".pfx");
                        exportInfo.pwszExportFileName = new WString(filename);
                        logger.info((Object)("Certificate for " + nameString + " a mettre dans " + filename));
                        this.generatedFiles.add(new File(filename));
                        exportInfo.pCertContext = certContext;
                        exportInfo.write();
                        logger.info((Object)exportInfo);
                        boolean result = Cryptui.INSTANCE.CryptUIWizExport(771, null, new WString("Hello"), exportInfo.getPointer(), certContextInfo.getPointer());
                        if (result) {
                            again = false;
                        }
                    } else {
                        logger.info((Object)("did not found private key for " + nameString));
                        int iresult = User32.INSTANCE.MessageBoxA(0, "Ce certificat n'est pas associ\u00e9 \u00e0 une cl\u00e9 priv\u00e9e", "Certificat non export\u00e9", 335872L);
                        logger.debug((Object)("MessageBoxA(,,,) -> " + iresult));
                    }
                    Crypt32.INSTANCE.CertFreeCertificateContext(certContext);
                    certContext = null;
                    continue;
                }
                again = false;
            }
        }
    }

    public void exportAll(String password) {
        this.generatedFiles.clear();
        Native.setProtected((boolean)true);
        Pointer storeHandle = Crypt32.INSTANCE.CertOpenSystemStoreA(null, "MY");
        if (storeHandle != null) {
            logger.info((Object)"CertOpenSystemStoreA returned not null");
            Pointer certContext = null;
            CryptuiWizExportCertContextInfo certContextInfo = new CryptuiWizExportCertContextInfo();
            CryptuiWizExportInfo exportInfo = new CryptuiWizExportInfo();
            certContextInfo.dwExportFormat = 2;
            certContextInfo.fExportChain = true;
            certContextInfo.fExportPrivateKeys = true;
            certContextInfo.pwszPassword = new WString(password);
            certContextInfo.fStrongEncryption = false;
            certContextInfo.write();
            logger.info((Object)certContextInfo);
            exportInfo.pwszExportFileName = new WString("C:\\lolo.pfx");
            exportInfo.dwSubjectChoice = 1;
            exportInfo.pCertContext = certContext;
            exportInfo.rghStores = null;
            exportInfo.cStores = 0;
            while ((certContext = Crypt32.INSTANCE.CertEnumCertificatesInStore(storeHandle, certContext)) != null) {
                logger.debug((Object)"Looping ..");
                byte[] byteArray = new byte[256];
                Crypt32.INSTANCE.CertGetNameStringA(certContext, 5, 0, null, byteArray, 128);
                String nameString = Native.toString((byte[])byteArray);
                logger.info((Object)("found " + nameString));
                if (Crypt32.INSTANCE.CryptFindCertificateKeyProvInfo(certContext, 0, null)) {
                    logger.info((Object)("found private key for " + nameString));
                    String filename = new String("C:\\" + nameString + ".pfx");
                    exportInfo.pwszExportFileName = new WString(filename);
                    logger.info((Object)("Certificate for " + nameString + " a mettre dans " + filename));
                    this.generatedFiles.add(new File(filename));
                    exportInfo.pCertContext = certContext;
                    exportInfo.write();
                    logger.info((Object)exportInfo);
                    boolean result = Cryptui.INSTANCE.CryptUIWizExport(771, null, new WString("Hello"), exportInfo.getPointer(), certContextInfo.getPointer());
                    continue;
                }
                logger.info((Object)("did not found private key for " + nameString));
            }
            if (certContext != null) {
                Crypt32.INSTANCE.CertFreeCertificateContext(certContext);
                certContext = null;
            }
            Crypt32.INSTANCE.CertCloseStore(storeHandle, 0);
        } else {
            logger.info((Object)"CertOpenSystemStoreA returned null");
        }
    }

    public static interface Cryptui
    extends StdCallLibrary {
        public static final int CRYPTUI_WIZ_EXPORT_FORMAT_PFX = 2;
        public static final int CRYPTUI_WIZ_EXPORT_CERT_CONTEXT = 1;
        public static final int CRYPTUI_WIZ_NO_UI_EXCEPT_CSP = 3;
        public static final int CRYPTUI_WIZ_EXPORT_PRIVATE_KEY = 256;
        public static final int CRYPTUI_WIZ_EXPORT_NO_DELETE_PRIVATE_KEY = 512;
        public static final Cryptui INSTANCE = (Cryptui)Native.loadLibrary((String)"Cryptui", Cryptui.class);

        public boolean CryptUIWizExport(int var1, Pointer var2, WString var3, Pointer var4, Pointer var5);

        public Pointer CryptUIDlgSelectCertificateFromStore(Pointer var1, Pointer var2, WString var3, WString var4, int var5, int var6, Pointer var7);

        public boolean CryptUIDlgViewContext(int var1, Pointer var2, Pointer var3, WString var4, int var5, Pointer var6);
    }

    public static interface Crypt32
    extends StdCallLibrary {
        public static final Crypt32 INSTANCE = (Crypt32)Native.loadLibrary((String)"Crypt32", Crypt32.class);

        public Pointer CertOpenSystemStoreA(Pointer var1, String var2);

        public boolean CertCloseStore(Pointer var1, int var2);

        public Pointer CertEnumCertificatesInStore(Pointer var1, Pointer var2);

        public int CertGetNameStringA(Pointer var1, int var2, int var3, Pointer var4, byte[] var5, int var6);

        public boolean CryptFindCertificateKeyProvInfo(Pointer var1, int var2, Pointer var3);

        public boolean CertFreeCertificateContext(Pointer var1);
    }

    public static interface User32
    extends StdCallLibrary {
        public static final User32 INSTANCE = (User32)Native.loadLibrary((String)"User32", User32.class);
        public static final long MB_OK = 0L;
        public static final long MB_OKCANCEL = 1L;
        public static final long MB_ABORTRETRYIGNORE = 2L;
        public static final long MB_YESNOCANCEL = 3L;
        public static final long MB_YESNO = 4L;
        public static final long MB_RETRYCANCEL = 5L;
        public static final long MB_CANCELTRYCONTINUE = 6L;
        public static final long MB_ICONHAND = 16L;
        public static final long MB_ICONQUESTION = 32L;
        public static final long MB_ICONEXCLAMATION = 48L;
        public static final long MB_ICONASTERISK = 64L;
        public static final long MB_USERICON = 128L;
        public static final long MB_ICONWARNING = 48L;
        public static final long MB_ICONERROR = 16L;
        public static final long MB_ICONINFORMATION = 64L;
        public static final long MB_ICONSTOP = 16L;
        public static final long MB_DEFBUTTON1 = 0L;
        public static final long MB_DEFBUTTON2 = 256L;
        public static final long MB_DEFBUTTON3 = 512L;
        public static final long MB_DEFBUTTON4 = 768L;
        public static final long MB_APPLMODAL = 0L;
        public static final long MB_SYSTEMMODAL = 4096L;
        public static final long MB_TASKMODAL = 8192L;
        public static final long MB_HELP = 16384L;
        public static final long MB_NOFOCUS = 32768L;
        public static final long MB_SETFOREGROUND = 65536L;
        public static final long MB_DEFAULT_DESKTOP_ONLY = 131072L;
        public static final long MB_TOPMOST = 262144L;
        public static final long MB_RIGHT = 524288L;
        public static final long MB_RTLREADING = 0x100000L;
        public static final long MB_TYPEMASK = 15L;
        public static final long MB_ICONMASK = 240L;
        public static final long MB_DEFMASK = 3840L;
        public static final long MB_MODEMASK = 12288L;
        public static final long MB_MISCMASK = 49152L;
        public static final int IDOK = 1;
        public static final int IDCANCEL = 2;
        public static final int IDABORT = 3;
        public static final int IDRETRY = 4;
        public static final int IDIGNORE = 5;
        public static final int IDYES = 6;
        public static final int IDNO = 7;
        public static final int IDCLOSE = 8;
        public static final int IDHELP = 9;
        public static final int IDTRYAGAIN = 10;
        public static final int IDCONTINUE = 11;
        public static final int IDTIMEOUT = 32000;

        public int MessageBoxA(int var1, String var2, String var3, long var4);
    }

    public static class CryptuiWizExportInfo
    extends Structure {
        public int dwSize = this.size();
        public WString pwszExportFileName;
        public int dwSubjectChoice;
        public Pointer pCertContext;
        public int cStores;
        public Pointer rghStores;
    }

    public static class CryptuiWizExportCertContextInfo
    extends Structure {
        public int dwSize = this.size();
        public int dwExportFormat;
        public boolean fExportChain;
        public boolean fExportPrivateKeys;
        public WString pwszPassword;
        public boolean fStrongEncryption;
    }
}

