/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugin.signerfichier;

import fr.gouv.finances.cp.xemelios.plugin.signerfichier.Actions;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardPage;
import org.netbeans.spi.wizard.WizardPanelNavResult;

public class CertListPanel
extends WizardPage {
    private static final Logger logger = Logger.getLogger(CertListPanel.class);
    private CertTableModel model;
    private ButtonGroup buttonGroup1;
    private JButton jButtonImportFromFile;
    private JButton jButtonImportFromWindows;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelFromFile;
    private JPanel jPanelFromWindowsStore;
    private JRadioButton jRadioButtonWSelection;
    private JRadioButton jRadioButtonWTous;
    private JScrollPane jScrollPane3;
    private JTable tblCerts;

    public CertListPanel() {
        String osname = System.getProperty("os.name");
        this.model = new CertTableModel();
        this.initComponents();
        this.fillCertList();
        if (osname.startsWith("Windows")) {
            this.jPanelFromWindowsStore.setVisible(true);
            this.jRadioButtonWSelection.setVisible(false);
            this.jRadioButtonWTous.setVisible(false);
        } else {
            this.jButtonImportFromWindows.setVisible(false);
            this.jRadioButtonWSelection.setVisible(false);
            this.jRadioButtonWTous.setVisible(false);
        }
    }

    public static final String getDescription() {
        return "S\u00e9lection de la cl\u00e9 priv\u00e9e";
    }

    public WizardPanelNavResult allowNext(String stepName, Map settings, Wizard wizard) {
        if (this.tblCerts.getSelectedRow() < 0) {
            return WizardPanelNavResult.REMAIN_ON_PAGE;
        }
        boolean ret = Actions.getInstance().loadAlias(this.model.getAlias(this.tblCerts.getSelectedRow()).getAlias());
        if (ret) {
            return WizardPanelNavResult.PROCEED;
        }
        return WizardPanelNavResult.REMAIN_ON_PAGE;
    }

    protected void fillCertList() {
        try {
            Actions.getInstance().openCertFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.model.clear();
        try {
            if (Actions.getInstance().getAliases() == null) {
                return;
            }
            Enumeration e = Actions.getInstance().getAliases();
            while (e.hasMoreElements()) {
                AliasListEntry le = new AliasListEntry(e.nextElement());
                this.model.addCert(le);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String validateContents(Component comp, Object o) {
        if (this.model.getRowCount() == 0) {
            return "Veuillez importer des cl\u00e9s SVP";
        }
        if (this.tblCerts.getSelectedRow() < 0) {
            return "S\u00e9lectionner une cl\u00e9 SVP";
        }
        return null;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.tblCerts = new JTable();
        this.jPanel2 = new JPanel();
        this.jPanelFromWindowsStore = new JPanel();
        this.jButtonImportFromWindows = new JButton();
        this.jRadioButtonWTous = new JRadioButton();
        this.jRadioButtonWSelection = new JRadioButton();
        this.jPanelFromFile = new JPanel();
        this.jButtonImportFromFile = new JButton();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "S\u00e9lectionner une cl\u00e9..", 0, 0, new Font("Tahoma", 1, 10)));
        this.jPanel1.setMaximumSize(new Dimension(294, 263));
        this.jPanel1.setOpaque(false);
        this.tblCerts.setModel(this.model);
        this.jScrollPane3.setViewportView(this.tblCerts);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane3, -1, 505, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane3, -2, 120, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Importer des cl\u00e9s..", 0, 0, new Font("Tahoma", 1, 10)));
        this.jPanelFromWindowsStore.setBorder(new SoftBevelBorder(0));
        this.jButtonImportFromWindows.setFont(new Font("Tahoma", 0, 10));
        this.jButtonImportFromWindows.setText("<html>Depuis<br> le magasin de certificats de Windows...</html>");
        this.jButtonImportFromWindows.setToolTipText("<html>Vous permet de r\u00e9cup\u00e9rer des cl\u00e9s priv\u00e9es en passant par les <br>libraries cryptographiques propres \u00e0 Windows</html>");
        this.jButtonImportFromWindows.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CertListPanel.this.jButtonImportFromWindowsActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonWTous);
        this.jRadioButtonWTous.setFont(new Font("Tahoma", 0, 10));
        this.jRadioButtonWTous.setText("Tout");
        this.jRadioButtonWTous.setToolTipText("<html>Importer tous vos certificats</html>");
        this.jRadioButtonWTous.setHorizontalTextPosition(4);
        this.jRadioButtonWTous.setVerticalTextPosition(3);
        this.buttonGroup1.add(this.jRadioButtonWSelection);
        this.jRadioButtonWSelection.setFont(new Font("Tahoma", 0, 10));
        this.jRadioButtonWSelection.setSelected(true);
        this.jRadioButtonWSelection.setText("Choix");
        this.jRadioButtonWSelection.setToolTipText("<html>S\u00e9lectionner un certificat</html>");
        this.jRadioButtonWSelection.setHorizontalTextPosition(4);
        this.jRadioButtonWSelection.setVerticalTextPosition(3);
        this.jRadioButtonWSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CertListPanel.this.jRadioButtonWSelectionActionPerformed(evt);
            }
        });
        GroupLayout jPanelFromWindowsStoreLayout = new GroupLayout((Container)this.jPanelFromWindowsStore);
        this.jPanelFromWindowsStore.setLayout((LayoutManager)jPanelFromWindowsStoreLayout);
        jPanelFromWindowsStoreLayout.setHorizontalGroup((GroupLayout.Group)jPanelFromWindowsStoreLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelFromWindowsStoreLayout.createSequentialGroup().addContainerGap().add((Component)this.jButtonImportFromWindows, -2, 109, -2).addPreferredGap(0).add((GroupLayout.Group)jPanelFromWindowsStoreLayout.createParallelGroup(1).add((Component)this.jRadioButtonWSelection, -2, 66, -2).add((Component)this.jRadioButtonWTous)).addContainerGap(134, Short.MAX_VALUE)));
        jPanelFromWindowsStoreLayout.setVerticalGroup((GroupLayout.Group)jPanelFromWindowsStoreLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelFromWindowsStoreLayout.createSequentialGroup().addContainerGap(13, Short.MAX_VALUE).add((GroupLayout.Group)jPanelFromWindowsStoreLayout.createParallelGroup(2).add((Component)this.jButtonImportFromWindows, -2, 75, -2).add(1, (GroupLayout.Group)jPanelFromWindowsStoreLayout.createSequentialGroup().add((Component)this.jRadioButtonWSelection, -2, 31, -2).addPreferredGap(0).add((Component)this.jRadioButtonWTous))).addContainerGap()));
        this.jPanelFromFile.setBorder(new SoftBevelBorder(0));
        this.jButtonImportFromFile.setFont(new Font("Tahoma", 0, 10));
        this.jButtonImportFromFile.setText("<html>Depuis <br>  un fichier...</html>");
        this.jButtonImportFromFile.setToolTipText("<html>Ajouter des cl\u00e9s priv\u00e9es contenus dans un fichier<br>\nde type \"magasin de cl\u00e9s\"</html>");
        this.jButtonImportFromFile.setActionCommand("AddFromFile");
        this.jButtonImportFromFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CertListPanel.this.jButtonImportFromFileActionPerformed(evt);
            }
        });
        GroupLayout jPanelFromFileLayout = new GroupLayout((Container)this.jPanelFromFile);
        this.jPanelFromFile.setLayout((LayoutManager)jPanelFromFileLayout);
        jPanelFromFileLayout.setHorizontalGroup((GroupLayout.Group)jPanelFromFileLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelFromFileLayout.createSequentialGroup().addContainerGap().add((Component)this.jButtonImportFromFile, -2, 109, -2).addContainerGap(43, Short.MAX_VALUE)));
        jPanelFromFileLayout.setVerticalGroup((GroupLayout.Group)jPanelFromFileLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelFromFileLayout.createSequentialGroup().addContainerGap().add((Component)this.jButtonImportFromFile, -2, 67, -2).addContainerGap(21, Short.MAX_VALUE)));
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.jPanelFromFile, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanelFromWindowsStore, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add(1, (Component)this.jPanelFromWindowsStore, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanelFromFile, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(20, 20, 20).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jButtonImportFromFileActionPerformed(ActionEvent evt) {
        try {
            Actions.getInstance().fillFromFile(null);
            this.fillCertList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jButtonImportFromWindowsActionPerformed(ActionEvent evt) {
        CertListPanel me = this;
        Runnable code = new Runnable((Component)((Object)me)){
            final /* synthetic */ Component val$me;
            {
                this.val$me = component;
            }

            public void run() {
                try {
                    Actions.getInstance().fillFromWindows(SwingUtilities.getWindowAncestor(this.val$me), CertListPanel.this.jRadioButtonWTous.isSelected());
                    CertListPanel.this.fillCertList();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        try {
            SwingUtilities.invokeLater(code);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void jRadioButtonWSelectionActionPerformed(ActionEvent evt) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CertTableModel
    extends AbstractTableModel {
        public Vector<AliasListEntry> data = new Vector();

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "D\u00e9livr\u00e9 \u00e0";
                }
                case 1: {
                    return "D\u00e9livr\u00e9 par";
                }
                case 2: {
                    return "Valable de";
                }
            }
            return "\u00e0";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            AliasListEntry alias = this.data.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return alias.getBonhomme();
                }
                case 1: {
                    return alias.getEmetteur();
                }
                case 2: {
                    return alias.getDateDebut();
                }
            }
            return alias.getDateFin();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 1: {
                    return String.class;
                }
            }
            return Date.class;
        }

        public void clear() {
            this.data = new Vector();
            this.fireTableDataChanged();
        }

        public void addCert(AliasListEntry entry) {
            this.data.add(entry);
            this.fireTableRowsInserted(this.data.size(), this.data.size());
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        public AliasListEntry getAlias(int row) {
            return this.data.get(row);
        }
    }

    private class AliasListEntry {
        private String alias;
        private String issuedFor = null;
        private String details = null;
        private String bonhomme = null;
        private String emetteur = null;
        private Date dateDebut = null;
        private Date dateFin = null;

        AliasListEntry(Object oalias) {
            try {
                this.alias = (String)oalias;
                this.details = Actions.getInstance().getDetails(this.alias);
                this.issuedFor = Actions.getInstance().getIssuedFor(this.alias);
                this.bonhomme = Actions.getInstance().getNomBonhomme(this.alias);
                this.emetteur = Actions.getInstance().getEmetteur(this.alias);
                this.dateDebut = Actions.getInstance().getDateDebut(this.alias);
                this.dateFin = Actions.getInstance().getDateFin(this.alias);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String toString() {
            return this.getIssuedFor() + "   (" + this.getAlias() + ")";
        }

        public String getAlias() {
            return this.alias;
        }

        public String getDetails() {
            return this.details;
        }

        public String getIssuedFor() {
            return this.issuedFor;
        }

        public String getBonhomme() {
            return this.bonhomme;
        }

        public String getEmetteur() {
            return this.emetteur;
        }

        public Date getDateDebut() {
            return this.dateDebut;
        }

        public Date getDateFin() {
            return this.dateFin;
        }
    }
}

