/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.finances.cp.xemelios.plugin.generatorEdmn;

import fr.gouv.finances.cp.utils.xml.marshal.CharacterEscaper;
import fr.gouv.finances.cp.utils.xml.marshal.escapers.DefaultCharacterEscaper;
import fr.gouv.finances.cp.xemelios.plugin.generatorEdmn.DlgGenEdmn;
import fr.gouv.finances.cp.xemelios.plugin.generatorEdmn.ProgressFrame;
import fr.gouv.finances.cp.xemelios.ui.MainWindow;
import fr.gouv.finances.dgfip.xemelios.common.FileInfo;
import fr.gouv.finances.dgfip.xemelios.common.PJRef;
import fr.gouv.finances.dgfip.xemelios.common.config.DocumentModel;
import fr.gouv.finances.dgfip.xemelios.common.config.Loader;
import fr.gouv.finances.dgfip.xemelios.data.impl.pool.PoolManager;
import fr.gouv.finances.dgfip.xemelios.importers.EtatImporteur;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.jdesktop.swingworker.SwingWorker;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdmnImporteurWorker
extends SwingWorker<String, String> {
    private static Logger logger = Logger.getLogger(EdmnImporteurWorker.class);
    private static final boolean DEBUG = false;
    public static final int MAX_SIZE_FILE = 5000;
    protected File[] filesToTreat;
    protected Exception inProcessException = null;
    protected long start;
    public final int MSG_TYPE_INFORMATION = 1;
    public final int MSG_TYPE_ERROR = 2;
    public static String TABLE_INDEX = "EDMN_INDEX_NUM_LIASSE";
    public static String TABLE_BUDGETS = "EDMN_BUDGS";
    public static String TABLE_ORDOS = "EDMN_ORDOS";
    public static String TABLE_COMPTABLES = "EDMN_COMPTAS";
    public static String TABLE_MINISTERES = "EDMN_MINISTERES";
    public static final transient String ENCODING = "ISO-8859-1";
    public static final String EDMN_NS_URI = "http://projets.admisource.gouv.fr/xemelios/namespaces#edmn";
    private ProgressFrame progress;
    private int progressShowing = 0;
    private String fireName = "";
    private Object fireValue;
    private File dirEDMN = null;
    private File budgets = null;
    private File ordos = null;
    private File comptables = null;
    private File output = null;
    private ArrayList<File> generatedFiles;
    private static final int BUFFER_SIZE = 8192;
    private DlgGenEdmn dlg;
    private Connection con = null;
    CharacterEscaper escaper = null;

    public EdmnImporteurWorker(Connection con, File budgets, File ordos, File comptables, File output, DlgGenEdmn dlg) {
        this.con = con;
        this.budgets = budgets;
        this.ordos = ordos;
        this.comptables = comptables;
        this.output = output;
        this.dlg = dlg;
        this.escaper = new DefaultCharacterEscaper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doInBackground() {
        FileInfo fileInfo = new FileInfo();
        this.start = System.currentTimeMillis();
        this.getProgressDlg().displayProgress();
        this.filesToTreat[2] = this.budgets;
        this.filesToTreat[3] = this.ordos;
        this.filesToTreat[4] = this.comptables;
        try {
            String fName;
            File f;
            try {
                f = this.filesToTreat[1];
                fName = f.getName();
                this.fireProperty("FILE_NAME", fName);
                this.fireProperty("initialize", this.getProgressDlg().nbLines[1]);
                this.saveIndex(f, this.getProgressDlg().nbLines[1]);
                this.fireProperty("currentTerminated", null);
            }
            catch (Exception ex) {
                this.inProcessException = ex;
                ex.printStackTrace();
            }
            try {
                f = this.filesToTreat[2];
                fName = f.getName();
                this.fireProperty("FILE_NAME", fName);
                this.fireProperty("initialize", this.getProgressDlg().nbLines[2]);
                this.saveBudgets(f, this.getProgressDlg().nbLines[2]);
                this.fireProperty("currentTerminated", null);
            }
            catch (Exception ex) {
                this.inProcessException = ex;
                ex.printStackTrace();
            }
            try {
                f = this.filesToTreat[3];
                fName = f.getName();
                this.fireProperty("FILE_NAME", fName);
                this.fireProperty("initialize", this.getProgressDlg().nbLines[3]);
                this.saveOrdos(f, this.getProgressDlg().nbLines[3]);
                this.fireProperty("currentTerminated", null);
            }
            catch (Exception ex) {
                this.inProcessException = ex;
                ex.printStackTrace();
            }
            try {
                f = this.filesToTreat[4];
                fName = f.getName();
                this.fireProperty("FILE_NAME", fName);
                this.fireProperty("initialize", this.getProgressDlg().nbLines[4]);
                this.saveComptas(f, this.getProgressDlg().nbLines[4]);
                this.fireProperty("currentTerminated", null);
            }
            catch (Exception ex) {
                this.inProcessException = ex;
                ex.printStackTrace();
            }
            this.generatedFiles = new ArrayList();
            try {
                f = this.filesToTreat[0];
                fName = f.getName();
                this.fireProperty("FILE_NAME", fName);
                this.fireProperty("initialize", this.getProgressDlg().nbLines[0]);
                this.importFile(f, this.getProgressDlg().nbLines[0]);
                this.fireProperty("currentTerminated", null);
            }
            catch (Exception ex) {
                this.inProcessException = ex;
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            this.inProcessException = ex;
            ex.printStackTrace();
        }
        finally {
            if (this.con != null) {
                try {
                    PoolManager.getInstance().releaseConnection(this.con);
                }
                catch (Exception sqlEx) {}
            }
        }
        StringBuffer msg = new StringBuffer();
        if (!this.isCancelled()) {
            long ms = System.currentTimeMillis() - this.start;
            int s = Integer.parseInt(String.valueOf(ms / 1000L));
            int m = Integer.parseInt(String.valueOf(s / 60));
            int h = Integer.parseInt(String.valueOf(m / 60));
            StringBuffer sb = new StringBuffer("La g\u00e9n\u00e9ration a dur\u00e9 : ");
            if (Integer.parseInt(String.valueOf(h)) != 0) {
                sb.append(h + "h ");
            }
            if (Integer.parseInt(String.valueOf(m)) != 0) {
                sb.append((h != 0 ? " et " : "") + (m - h * 60) + "mins ");
            }
            if (Integer.parseInt(String.valueOf(s)) != 0) {
                sb.append((h != 0 || m != 0 ? " et " : "") + (s - m * 60) + "s ");
            }
            if (Integer.parseInt(String.valueOf(ms)) != 0) {
                sb.append((h != 0 || m != 0 || s != 0 ? " et " : "") + (ms - (long)(s * 1000)) + "ms ");
            }
            msg.append("La g\u00e9n\u00e9ration du fichier est termin\u00e9.\n");
            try {
                msg.append(fileInfo.toString(Loader.getDocumentsInfos(null)));
            }
            catch (Exception ex) {
                // empty catch block
            }
            msg.append("");
        } else {
            msg.append("La g\u00e9n\u00e9ration du fichier EDMN a \u00e9t\u00e9 interrompue.");
        }
        logger.info((Object)("\n" + msg));
        return msg.toString();
    }

    private void fireProperty(String name, Object value) {
        this.fireName = name;
        this.fireValue = value;
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.firePropertyChange(name, null, value);
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        EdmnImporteurWorker.this.firePropertyChange(EdmnImporteurWorker.this.fireName, null, EdmnImporteurWorker.this.fireValue);
                    }
                });
            }
        }
        catch (Throwable t) {
            logger.fatal((Object)"in fire:", t);
        }
    }

    protected void done() {
        super.done();
        if (this.inProcessException != null) {
            this.getProgressDlg().displayException(this.inProcessException);
        }
        String msg = "";
        try {
            msg = (String)this.get();
        }
        catch (InterruptedException iEx) {
            iEx.printStackTrace();
        }
        catch (ExecutionException eEx) {
            eEx.printStackTrace();
        }
        catch (CancellationException cEx) {
            msg = "G\u00e9n\u00e9ration annul\u00e9e";
        }
        if (this.inProcessException == null) {
            if (this.generateArchive()) {
                this.cleanTempFile();
            }
            JOptionPane.showMessageDialog(this.dlg, "G\u00e9n\u00e9ration correctement termin\u00e9e.");
            this.dlg.enableGenerateButton();
        } else {
            this.getProgressDlg().displayMessage(msg, 1);
        }
        this.getProgressDlg().hide();
    }

    public void setFilesToTreat(File[] fichiers) throws Exception {
        this.filesToTreat = fichiers;
    }

    public ProgressFrame getProgressDlg() {
        return this.progress;
    }

    public void setProgressDlg(ProgressFrame prog) {
        this.progress = prog;
    }

    protected void saveIndex(File index, int nbLignes) throws Exception {
        Statement ps = null;
        StringBuffer sb = new StringBuffer();
        File fSQL = new File(System.getProperty("user.home"), "insert_index.txt");
        FileWriter fw = new FileWriter(fSQL);
        this.progressShowing = nbLignes / 500;
        try {
            BufferedReader br = new BufferedReader(new FileReader(index));
            String line = br.readLine();
            int i = 0;
            int total = 0;
            Long tempsTotalTraitement = Long.parseLong("0");
            Date datedeb = new Date();
            while (line != null) {
                ++i;
                ++total;
                if (line.length() > 15) {
                    if (total == nbLignes) {
                        sb.append(line.substring(0, 2) + "," + line.substring(2, 3) + "," + line.substring(3, 9) + "," + line.substring(9, 12) + "," + line.substring(17, 21) + "," + line.substring(21, 24) + "," + line.substring(24, 26) + "," + line.substring(31, 37));
                    } else {
                        sb.append(line.substring(0, 2) + "," + line.substring(2, 3) + "," + line.substring(3, 9) + "," + line.substring(9, 12) + "," + line.substring(17, 21) + "," + line.substring(21, 24) + "," + line.substring(24, 26) + "," + line.substring(31, 37) + "\n");
                    }
                }
                if (i == this.progressShowing) {
                    this.fireProperty("progress", i);
                    i = 0;
                }
                line = br.readLine();
            }
            if (i != 0) {
                this.fireProperty("progress", i);
            }
            i = 0;
            fw.write(sb.toString());
            fw.flush();
            fw.close();
            ps = this.con.prepareStatement("LOAD DATA LOCAL INFILE '" + fSQL.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\") + "' INTO TABLE " + TABLE_INDEX + " FIELDS TERMINATED BY ','");
            ps.execute();
            fSQL.delete();
            Date datefin = new Date();
            tempsTotalTraitement = tempsTotalTraitement + (datefin.getTime() - datedeb.getTime());
            int minutes = Integer.parseInt(Long.toString(tempsTotalTraitement / 60000L));
            int secondes = Integer.parseInt(Long.toString(tempsTotalTraitement / 1000L));
            int millis = Integer.parseInt(Long.toString(tempsTotalTraitement));
            logger.info((Object)("Temps d'insertion de l'index = " + (minutes != 0 ? minutes + "mins et " : "") + (secondes - minutes * 60) + "s et " + (millis - secondes * 1000) + "ms"));
        }
        catch (IOException e) {
            if (e.getClass().equals(FileNotFoundException.class)) {
                logger.debug((Object)"Le fichier d'index n'a pas \u00e9t\u00e9 trouv\u00e9 !", e.getCause());
            } else {
                logger.debug((Object)("IOException sur le fichier " + index.getAbsolutePath() + " !"), e.getCause());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    protected void saveBudgets(File budgets, int nbLignes) throws Exception {
        Statement ps = null;
        File fSQL = new File(System.getProperty("user.home"), "insert_budgets.txt");
        FileWriter fw = new FileWriter(fSQL);
        this.progressShowing = nbLignes / 500;
        try {
            BufferedReader br = new BufferedReader(new FileReader(budgets));
            String line = br.readLine();
            int i = 0;
            int total = 0;
            Long tempsTotalTraitement = Long.parseLong("0");
            Date datedeb = new Date();
            ArrayList<String> ministeres = new ArrayList<String>();
            while (line != null) {
                ++i;
                ++total;
                if (line.length() > 15) {
                    if (line.substring(8, "00000000".length() + 8).equals("00000000")) {
                        ministeres.add(line);
                    }
                    if (total == nbLignes) {
                        fw.write(line.substring(0, 4) + line.substring(12, 16) + "," + line.substring(16, line.length() - 1));
                    } else {
                        fw.write(line.substring(0, 4) + line.substring(12, 16) + "," + line.substring(16, line.length() - 1) + "\n");
                    }
                }
                if (i == this.progressShowing) {
                    this.fireProperty("progress", i);
                    i = 0;
                }
                line = br.readLine();
            }
            if (i != 0) {
                this.fireProperty("progress", i);
            }
            i = 0;
            fw.flush();
            fw.close();
            ps = this.con.prepareStatement("LOAD DATA LOCAL INFILE '" + fSQL.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\") + "' INTO TABLE " + TABLE_BUDGETS + " FIELDS TERMINATED BY ','");
            ps.execute();
            fSQL.delete();
            ps = this.con.prepareStatement("INSERT INTO " + TABLE_MINISTERES + " (CODE,LIBELLE) VALUES(?,?)");
            for (String s : ministeres) {
                ps.setString(1, s.substring(6, 8));
                ps.setString(2, s.substring(16).trim());
                ps.executeUpdate();
            }
            Date datefin = new Date();
            tempsTotalTraitement = tempsTotalTraitement + (datefin.getTime() - datedeb.getTime());
            int minutes = Integer.parseInt(Long.toString(tempsTotalTraitement / 60000L));
            int secondes = Integer.parseInt(Long.toString(tempsTotalTraitement / 1000L));
            int millis = Integer.parseInt(Long.toString(tempsTotalTraitement));
            logger.info((Object)("Temps d'insertion budgets = " + (minutes != 0 ? minutes + "mins et " : "") + (secondes - minutes * 60) + "s et " + (millis - secondes * 1000) + "ms"));
        }
        catch (IOException e) {
            if (e.getClass().equals(FileNotFoundException.class)) {
                logger.debug((Object)"Le fichier des budgets n'a pas \u00e9t\u00e9 trouv\u00e9 !", e.getCause());
            } else {
                logger.debug((Object)("IOException sur le fichier " + budgets.getAbsolutePath() + " !"), e.getCause());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    protected void saveOrdos(File ordos, int nbLignes) throws Exception {
        Statement ps = null;
        File fSQL = new File(System.getProperty("user.home"), "insert_ordos.txt");
        FileWriter fw = new FileWriter(fSQL);
        this.progressShowing = nbLignes / 50;
        try {
            BufferedReader br = new BufferedReader(new FileReader(ordos));
            String line = br.readLine();
            int i = 0;
            int total = 0;
            Long tempsTotalTraitement = Long.parseLong("0");
            Date datedeb = new Date();
            while (line != null) {
                ++total;
                if (line.length() > 15) {
                    if (total == nbLignes) {
                        fw.write(line.substring(5, 10) + "," + line.substring(10, line.length() - 1));
                    } else {
                        fw.write(line.substring(5, 10) + "," + line.substring(10, line.length() - 1) + "\n");
                    }
                }
                if (i == this.progressShowing) {
                    this.fireProperty("progress", i);
                    i = 0;
                }
                line = br.readLine();
            }
            if (i != 0) {
                this.fireProperty("progress", i);
            }
            i = 0;
            fw.flush();
            fw.close();
            ps = this.con.prepareStatement("LOAD DATA LOCAL INFILE '" + fSQL.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\") + "' INTO TABLE " + TABLE_ORDOS + " FIELDS TERMINATED BY ','");
            ps.execute();
            fSQL.delete();
            Date datefin = new Date();
            tempsTotalTraitement = tempsTotalTraitement + (datefin.getTime() - datedeb.getTime());
            int minutes = Integer.parseInt(Long.toString(tempsTotalTraitement / 60000L));
            int secondes = Integer.parseInt(Long.toString(tempsTotalTraitement / 1000L));
            int millis = Integer.parseInt(Long.toString(tempsTotalTraitement));
            logger.info((Object)("Temps d'insertion ordos = " + (minutes != 0 ? minutes + "mins et " : "") + (secondes - minutes * 60) + "s et " + (millis - secondes * 1000) + "ms"));
        }
        catch (IOException e) {
            if (e.getClass().equals(FileNotFoundException.class)) {
                logger.debug((Object)"Le fichier d'ordos n'a pas \u00e9t\u00e9 trouv\u00e9 !", e.getCause());
            } else {
                logger.debug((Object)("IOException sur le fichier " + ordos.getAbsolutePath() + " !"), e.getCause());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    protected void saveComptas(File comptas, int nbLignes) throws Exception {
        Statement ps = null;
        File fSQL = new File(System.getProperty("user.home"), "insert_comptas.txt");
        FileWriter fw = new FileWriter(fSQL);
        this.progressShowing = nbLignes / 500;
        try {
            BufferedReader br = new BufferedReader(new FileReader(comptas));
            String line = br.readLine();
            int i = 0;
            int total = 0;
            Long tempsTotalTraitement = Long.parseLong("0");
            Date datedeb = new Date();
            while (line != null) {
                ++total;
                if (line.length() > 15) {
                    if (total == nbLignes) {
                        fw.write(line.substring(0, 6) + "," + line.substring(6, line.length() - 1));
                    } else {
                        fw.write(line.substring(0, 6) + "," + line.substring(6, line.length() - 1) + "\n");
                    }
                }
                if (i == this.progressShowing) {
                    this.fireProperty("progress", i);
                    i = 0;
                }
                line = br.readLine();
            }
            if (i != 0) {
                this.fireProperty("progress", i);
            }
            i = 0;
            fw.flush();
            fw.close();
            ps = this.con.prepareStatement("LOAD DATA LOCAL INFILE '" + fSQL.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\") + "' INTO TABLE " + TABLE_COMPTABLES + " FIELDS TERMINATED BY ','");
            ps.execute();
            fSQL.delete();
            Date datefin = new Date();
            tempsTotalTraitement = tempsTotalTraitement + (datefin.getTime() - datedeb.getTime());
            int minutes = Integer.parseInt(Long.toString(tempsTotalTraitement / 60000L));
            int secondes = Integer.parseInt(Long.toString(tempsTotalTraitement / 1000L));
            int millis = Integer.parseInt(Long.toString(tempsTotalTraitement));
            logger.info((Object)("Temps d'insertion comptas = " + (minutes != 0 ? minutes + "mins et " : "") + (secondes - minutes * 60) + "s et " + (millis - secondes * 1000) + "ms"));
        }
        catch (IOException e) {
            if (e.getClass().equals(FileNotFoundException.class)) {
                logger.debug((Object)"Le fichier des comptas n'a pas \u00e9t\u00e9 trouv\u00e9 !", e.getCause());
            } else {
                logger.debug((Object)("IOException sur le fichier " + comptas.getAbsolutePath() + " !"), e.getCause());
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    protected FileInfo importFile(File f, int nbLignes) throws Exception {
        FileInfo ret = new FileInfo();
        this.dirEDMN = File.createTempFile("tmp", "edmn", f.getParentFile());
        this.dirEDMN.delete();
        this.dirEDMN.mkdir();
        if (this.dirEDMN != null && this.dirEDMN.listFiles().length > 0) {
            for (File fToDelete : this.dirEDMN.listFiles()) {
                fToDelete.delete();
            }
        }
        this.generateXmlFileText(f, this.dirEDMN, nbLignes);
        return ret;
    }

    protected static String fmtNumLiasse(int i) {
        String v = Integer.toString(i);
        while (v.length() < 4) {
            v = "0".concat(v);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getNumLiasseNationale(String annee, String trimestre, String comptable, String ministere, String numLiasseLocaleDeb, String numLiasseLocaleFin, Connection con) {
        Statement ps = null;
        StringBuffer ret = new StringBuffer();
        StringBuffer numLiasses = new StringBuffer();
        int start = 0;
        int end = 0;
        try {
            start = Integer.parseInt(numLiasseLocaleDeb);
        }
        catch (NumberFormatException nfEx) {
            // empty catch block
        }
        try {
            end = Integer.parseInt(numLiasseLocaleFin);
        }
        catch (NumberFormatException nfEx) {
            // empty catch block
        }
        numLiasses.append("(");
        for (int i = start; i < end; ++i) {
            numLiasses.append("'").append(EdmnImporteurWorker.fmtNumLiasse(i)).append("',");
        }
        numLiasses.append("'").append(EdmnImporteurWorker.fmtNumLiasse(end)).append("')");
        try {
            ps = con.prepareStatement("SELECT NATIONALE FROM " + TABLE_INDEX + " WHERE ANNEE = ? AND TRIMESTRE = ? AND COMPTABLE = ? AND MINISTERE = ? AND LOCALE IN " + numLiasses.toString() + " ORDER BY 1");
            ps.setString(1, annee);
            ps.setString(2, trimestre);
            ps.setString(3, comptable);
            ps.setString(4, ministere);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ret.append("<Liasse V=\"").append(rs.getString(1)).append("\"/>");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLibelleBudget(String code, Connection con) {
        Statement ps = null;
        String ret = "";
        long start = System.currentTimeMillis();
        try {
            ps = con.prepareStatement("SELECT LIBELLE FROM " + TABLE_BUDGETS + " WHERE CODE = ?");
            ps.setString(1, code);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ret = EdmnImporteurWorker.escape(rs.getString(1));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLibelleMinistere(String code, Connection con) {
        Statement ps = null;
        String ret = "";
        try {
            ps = con.prepareStatement("SELECT LIBELLE FROM " + TABLE_MINISTERES + " WHERE CODE = ?");
            ps.setString(1, code);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ret = EdmnImporteurWorker.escape(rs.getString(1));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLibelleOrdo(String code, Connection con) {
        Statement ps = null;
        String ret = "";
        try {
            ps = con.prepareStatement("SELECT LIBELLE FROM " + TABLE_ORDOS + " WHERE CODE = ?");
            ps.setString(1, code);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ret = EdmnImporteurWorker.escape(rs.getString(1));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLibelleCompta(String code, Connection con) {
        Statement ps = null;
        String ret = "";
        try {
            ps = con.prepareStatement("SELECT LIBELLE FROM " + TABLE_COMPTABLES + " WHERE CODE = ?");
            ps.setString(1, code);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ret = EdmnImporteurWorker.escape(rs.getString(1));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Throwable t) {}
            }
        }
        return ret;
    }

    protected void generateXmlFileText(File source, File dirDest, int nbLignes) throws IOException, SAXException, SQLException {
        this.progressShowing = nbLignes / (nbLignes / 500);
        dirDest.mkdir();
        FileOutputStream fWriter = null;
        BufferedReader br = new BufferedReader(new FileReader(source));
        int breakFile = 5000;
        long nbTotalLines = Long.parseLong(String.valueOf(nbLignes));
        int nbLignesToSplitFile = (int)Math.ceil(nbTotalLines / (long)breakFile);
        if (nbTotalLines % (long)breakFile > 0L) {
            ++nbLignesToSplitFile;
        }
        int nbLignesParcourues = 0;
        int i = 0;
        int iLines = 0;
        Vector<String> vLignes = new Vector<String>();
        long start = 0L;
        long startLines = 0L;
        int nbLinesToGroup = 500;
        boolean firstEtat = true;
        String line = br.readLine();
        for (int numFile = 1; numFile <= nbLignesToSplitFile; ++numFile) {
            File destFile = new File(dirDest.getAbsolutePath(), source.getName() + "-" + numFile + ".xml");
            fWriter = new FileOutputStream(destFile);
            this.generatedFiles.add(destFile);
            fWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<Edmn xmlns=\"http://projets.admisource.gouv.fr/xemelios/namespaces#edmn\" xmlns:n=\"http://projets.admisource.gouv.fr/xemelios/namespaces#edmn\">\n".getBytes(ENCODING));
            fWriter.write(("<ReferenceNomenclature>\n<Code V=\"" + this.getCodeReferenceNomenclature(line) + "\"/>\n<Libelle V=\"" + this.getLibelleReferenceNomenclature(line) + "\"/>\n</ReferenceNomenclature>\n").getBytes(ENCODING));
            fWriter.write("<Budget><Code V=\"0000\"/><Libelle V=\"LFI\"/></Budget>\n".getBytes(ENCODING));
            fWriter.write("<Collectivite><Code V=\"000000000000\"/><Libelle V=\"ETAT\"/></Collectivite>\n".getBytes(ENCODING));
            fWriter.write("<EtatEdmn>\n".getBytes(ENCODING));
            try {
                while (line != null && nbLignesParcourues != breakFile) {
                    ++nbLignesParcourues;
                    if (firstEtat) continue;
                    if (iLines == 0) {
                        startLines = System.currentTimeMillis();
                    }
                    ++i;
                    ++iLines;
                    long startLine = System.currentTimeMillis();
                    vLignes.add(this.createLineText(line.toCharArray(), this.con));
                    if (vLignes.size() == nbLinesToGroup) {
                        iLines = 0;
                        start = System.currentTimeMillis();
                        StringBuilder sb = new StringBuilder();
                        for (String s : vLignes) {
                            sb.append(s);
                        }
                        fWriter.write(sb.toString().getBytes(ENCODING));
                        vLignes.clear();
                    }
                    if (i == this.progressShowing) {
                        this.fireProperty("progress", i);
                        i = 0;
                    }
                    line = br.readLine();
                }
            }
            catch (SAXException e) {
                logger.debug((Object)"", (Throwable)e);
            }
            nbLignesParcourues = 0;
            if (vLignes.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (String s : vLignes) {
                    sb.append(s);
                }
                fWriter.write(sb.toString().getBytes(ENCODING));
                vLignes.clear();
            }
            fWriter.write("</EtatEdmn>\n".getBytes(ENCODING));
            if (firstEtat) {
                firstEtat = false;
                fWriter.write("<Nomenclatures>\n".getBytes(ENCODING));
                this.createRepositorys(fWriter, this.budgets, this.ordos, this.comptables);
                fWriter.write("</Nomenclatures>\n".getBytes(ENCODING));
            }
            fWriter.write("</Edmn>".getBytes(ENCODING));
            fWriter.flush();
            fWriter.close();
        }
        if (i != 0) {
            this.fireProperty("progress", i);
        }
    }

    private void createRepositorys(FileOutputStream writer, File budgets, File ordonateurs, File comptables) {
        this.createBudgetRepository(writer, budgets);
        this.createOrdoRepository(writer, ordonateurs);
        this.createComptaRepository(writer, comptables);
    }

    private void createBudgetRepository(FileOutputStream writer, File f) {
        try {
            writer.write("<NomenclatureBudgets>\n<Description V=\"Nomenclature des Budgets\"/>\n".getBytes());
            BufferedReader br = new BufferedReader(new FileReader(f));
            String line = br.readLine();
            while (line != null) {
                writer.write(("<Correspondance><Code V=\"" + line.substring(0, 16).trim() + "\"/><Libelle V=\"" + line.substring(16, line.length() - 1).trim().replaceAll("\"", "'") + "\"/></Correspondance>\n").replaceAll("&", "&amp;").getBytes());
                line = br.readLine();
            }
            writer.write("</NomenclatureBudgets>\n".getBytes());
            br.close();
        }
        catch (Exception e) {
            logger.debug((Object)"Probl\u00e8me lors de la cr\u00e9ation de la nomenclature budget !");
            e.printStackTrace();
        }
    }

    private void createOrdoRepository(FileOutputStream writer, File f) {
        try {
            writer.write("<NomenclatureOrdonnateurs>\n<Description V=\"Nomenclature des Ordonateurs\"/>\n".getBytes());
            BufferedReader br = new BufferedReader(new FileReader(f));
            String line = br.readLine();
            while (line != null) {
                writer.write(("<Correspondance><Code V=\"" + line.substring(0, 10).trim() + "\"/><Libelle V=\"" + line.substring(10, line.length() - 1).trim().replaceAll("\"", "'") + "\"/></Correspondance>\n").replaceAll("&", "&amp;").getBytes());
                line = br.readLine();
            }
            writer.write("</NomenclatureOrdonnateurs>\n".getBytes());
            br.close();
        }
        catch (Exception e) {
            logger.debug((Object)"Probl\u00e8me lors de la cr\u00e9ation de la nomenclature budget !");
            e.printStackTrace();
        }
    }

    private void createComptaRepository(FileOutputStream writer, File f) {
        try {
            writer.write("<NomenclatureComptables>\n<Description V=\"Nomenclature des Comptables\"/>\n".getBytes());
            BufferedReader br = new BufferedReader(new FileReader(f));
            String line = br.readLine();
            while (line != null) {
                writer.write(("<Correspondance><Code V=\"" + line.substring(0, 6).trim() + "\"/><Libelle V=\"" + line.substring(6, line.length() - 1).trim().replaceAll("\"", "'") + "\"/></Correspondance>\n").replaceAll("&", "&amp;").getBytes());
                line = br.readLine();
            }
            writer.write("</NomenclatureComptables>\n".getBytes());
            br.close();
        }
        catch (Exception e) {
            logger.debug((Object)"Probl\u00e8me lors de la cr\u00e9ation de la nomenclature budget !");
            e.printStackTrace();
        }
    }

    public String getAdditionalMessage() {
        return "";
    }

    private String getLine(char[] tab, int deb, int fin) {
        String s = "";
        for (int i = deb; i < fin; ++i) {
            s = s + String.valueOf(tab[i]);
        }
        return this.escaper.escapeString(s.trim());
    }

    private String getCodeReferenceNomenclature(String line) {
        return line.substring(72, 76) + "-" + line.substring(69, 70);
    }

    private String getLibelleReferenceNomenclature(String line) {
        return "Ann\u00e9e " + line.substring(72, 76) + " - Trimestre " + line.substring(69, 70);
    }

    protected void writeNode(String nodeName, String value, DefaultHandler h) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        attr.addAttribute("", "V", "V", "String", value);
        h.startElement(EDMN_NS_URI, nodeName, "n:" + nodeName, attr);
        h.endElement(EDMN_NS_URI, nodeName, "n:" + nodeName);
    }

    private String createLineText(char[] line, Connection con) throws SAXException {
        StringBuilder sb = new StringBuilder("<LigneEdmn>");
        sb.append("<Comptable V=\"").append(this.getLine(line, 0, 6)).append("\"/><LibelleComptable V=\"").append(this.getLibelleCompta(this.getLine(line, 0, 6), con));
        sb.append("\"/><Ministere V=\"").append(this.getLine(line, 7, 9)).append("\" LibelleMinistere=\"");
        sb.append(this.getLibelleMinistere(this.getLine(line, 7, 9), con)).append("\"/><Ordo V=\"").append(this.getLine(line, 9, 15)).append("\"/><LibelleOrdonnateur V=\"");
        sb.append(this.getLibelleOrdo(this.getLine(line, 7, 12), con)).append("\"/><LibelleBudget V=\"").append(this.getLibelleBudget(this.getLine(line, 72, 76) + this.getLine(line, 51, 55), con));
        sb.append("\"/><TypeEvt V=\"").append(this.getLine(line, 15, 18)).append("\"/><AnneeBudget V=\"20").append(this.getLine(line, 18, 20));
        sb.append("\"/><NumMandat V=\"").append(this.getLine(line, 20, 26)).append("\"/><CompteSpeTresor V=\"").append(this.getLine(line, 26, 31));
        sb.append("\"/><NumOpeInvest V=\"").append(this.getLine(line, 31, 39)).append("\"/><AnneeEngag V=\"").append(this.getLine(line, 39, 41));
        sb.append("\"/><NumEngag V=\"").append(this.getLine(line, 41, 47)).append("\"/><ChapBudg V=\"").append(this.getLine(line, 47, 51));
        sb.append("\"/><ArtBudgExec V=\"").append(this.getLine(line, 51, 53)).append("\"/><ParagBudgExec V=\"").append(this.getLine(line, 53, 55)).append("\"/>");
        String mtedm = this.getLine(line, 55, 68);
        while (mtedm.startsWith("<0")) {
            mtedm = mtedm.substring(1);
        }
        if (this.getLine(line, 68, 69).trim().equals("-")) {
            mtedm = "-" + mtedm;
        }
        sb.append("<MtPJ V=\"").append(mtedm).append("\"/><Trimestre V=\"").append(this.getLine(line, 69, 70)).append("\"/><Mois V=\"");
        sb.append(this.getLine(line, 70, 72)).append("\"/><AnneeCrea V=\"").append(this.getLine(line, 72, 76)).append("\"/><MoisCrea V=\"");
        sb.append(this.getLine(line, 76, 78)).append("\"/><JourCrea V=\"").append(this.getLine(line, 78, 80)).append("\"/><ChapClassPJ V=\"");
        sb.append(this.getLine(line, 80, 84)).append("\"/><TypePaiement V=\"").append(this.getLine(line, 84, 87)).append("\"/><ArtBudgPrev V=\"");
        sb.append(this.getLine(line, 87, 89)).append("\"/><Zone24 V=\"").append(this.getLine(line, 89, 113)).append("\"/><NumLiasseDeb V=\"");
        sb.append(this.getLine(line, 113, 117)).append("\"/><NumLiasseFin V=\"").append(this.getLine(line, 117, 121)).append("\"/><TypeSuiviEco1 V=\"").append(this.getLine(line, 121, 123));
        sb.append("\"/><TypeSuiviEco2 V=\"").append(this.getLine(line, 123, 125)).append("\"/><TypeSuiviEco3 V=\"").append(this.getLine(line, 125, 127));
        sb.append("\"/><CodeCorrection V=\"").append(this.getLine(line, 127, 131)).append("\"/><NumLiasseNationale>");
        sb.append(this.getNumLiasseNationale(this.getLine(line, 74, 76), this.getLine(line, 69, 70), this.getLine(line, 0, 6), this.getLine(line, 6, 9), this.getLine(line, 113, 117), this.getLine(line, 117, 121), con)).append("</NumLiasseNationale>");
        sb.append("<CodeManip V=\"").append(this.getLine(line, 137, 138)).append("\"/><Zone32 V=\"").append(this.getLine(line, 138, 170));
        sb.append("\"/><DateCreation V=\"").append(this.getLine(line, 72, 76)).append("-" + this.getLine(line, 76, 78)).append("-").append(this.getLine(line, 78, 80));
        sb.append("\"/></LigneEdmn>\n");
        return sb.toString();
    }

    private boolean generateArchive() {
        boolean bRet = false;
        File target = this.output;
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(target));
            for (File f : this.generatedFiles) {
                ZipEntry ze = new ZipEntry("data/" + f.getName());
                zos.putNextEntry(ze);
                byte[] buffer = new byte[2048];
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
                int read = bis.read(buffer);
                while (read > 0) {
                    zos.write(buffer, 0, read);
                    read = bis.read(buffer);
                }
                bis.close();
            }
            ZipEntry manifestEntry = new ZipEntry("manifeste_XeMeLios.xml");
            zos.putNextEntry(manifestEntry);
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            sb.append("<manifeste cgIdCol=\"000000000000\" cgLibelle=\"ETAT\">\n");
            sb.append("\t<volumes>\n");
            sb.append("\t\t<volume fichier=\"").append(target.getName()).append("\" num=\"1\" dateProduction=\"").append(EdmnImporteurWorker.getFormattedCurrentDateTime()).append("\"/>\n");
            sb.append("\t</volumes>\n");
            sb.append("\t<documents>\n");
            for (File f : this.generatedFiles) {
                sb.append("\t\t<document volume=\"1\" path=\"data/").append(f.getName()).append("\" type=\"edmn\" buIdCol=\"000000000000\" buLibelle=\"ETAT\" buCode=\"0000\" libBudget=\"LFI\"/>\n");
            }
            sb.append("\t</documents>\n");
            sb.append("\t</manifeste>\n");
            zos.write(sb.toString().getBytes("UTF-8"));
            zos.flush();
            zos.close();
            bRet = true;
        }
        catch (Exception ex) {
            logger.error(null, (Throwable)ex);
        }
        return bRet;
    }

    private void cleanTempFile() {
        File[] files;
        for (File f : files = this.dirEDMN.listFiles()) {
            f.delete();
        }
        this.dirEDMN.delete();
    }

    private static String getFormattedCurrentDateTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        return sdf.format(new Date(System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importEdmnFile() {
        if (MainWindow.instance != null) {
            DocumentModel dm = MainWindow.instance.getDocModels().getDocumentById("edmn");
            try {
                Class<?> clazz = Class.forName(dm.getImportClass());
                Object obj = clazz.newInstance();
                if (!(obj instanceof EtatImporteur)) {
                    JOptionPane.showMessageDialog((Component)MainWindow.instance, "Cette classe n'est pas un importeur.\nLe fichier de configuration qui vous a \u00e9t\u00e9 livr\u00e9 est certainement invalide.\nVeuillez contacter votre fournisseur.\n", "Erreur", 0);
                    return;
                }
                EtatImporteur ei = (EtatImporteur)obj;
                ei.setDocument(dm);
                File zip = this.makeZip();
                MainWindow.ImportContent ic = new MainWindow.ImportContent();
                File tmpDir = new File(System.getProperty("java.io.tmpdir"));
                ZipFile zf = null;
                try {
                    zf = new ZipFile(zip);
                    Enumeration<? extends ZipEntry> enumer = zf.entries();
                    while (enumer.hasMoreElements()) {
                        ZipEntry ze = enumer.nextElement();
                        if (ze.isDirectory()) continue;
                        String fileName = ze.getName();
                        String entryName = fileName.toLowerCase();
                        fileName = fileName.replace(File.pathSeparatorChar, '_').replace(File.separatorChar, '_').replace(':', '|').replace('\'', '_').replace('/', '_');
                        if (PJRef.isPJ((ZipEntry)ze)) {
                            PJRef pj = new PJRef(ze);
                            pj.writeTmpFile(tmpDir, zf);
                            ic.getPjs().add(pj);
                            continue;
                        }
                        if (!entryName.endsWith(dm.getExtension().toLowerCase()) && !entryName.endsWith(".xml") || fileName.startsWith("_")) continue;
                        InputStream is = zf.getInputStream(ze);
                        BufferedInputStream bis = new BufferedInputStream(is);
                        File output = new File(tmpDir, fileName);
                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(output));
                        byte[] buffer = new byte[1024];
                        int read = bis.read(buffer);
                        while (read > 0) {
                            bos.write(buffer, 0, read);
                            read = bis.read(buffer);
                        }
                        bos.flush();
                        bos.close();
                        bis.close();
                        ic.getFilesToImport().add(output);
                    }
                    zf.close();
                }
                catch (ZipException zEx) {
                    JOptionPane.showMessageDialog((Component)MainWindow.instance, "Le fichier " + zip.getName() + " n'est pas une archive ZIP valide", "Erreur", 0);
                }
                catch (IOException ioEx) {
                    JOptionPane.showMessageDialog((Component)MainWindow.instance, "Le fichier " + zip.getName() + " est illisible. V\u00e9rifiez que les noms des fichiers\ncontenus dans l'archive ne comportent pas de caract\u00e8res sp\u00e9ciaux ou accentu\u00e9s.", "Erreur", 0);
                    ioEx.printStackTrace();
                }
                finally {
                    if (zf != null) {
                        try {
                            zf.close();
                        }
                        catch (Throwable t) {}
                    }
                }
                this.fireProperty("terminated", "G\u00e9n\u00e9ration termin\u00e9e.");
                this.dirEDMN.delete();
                MainWindow.instance.doImport(ei, ic, dm, false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        this.fireProperty("terminated", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File makeZip() throws IOException {
        File fout = new File(this.dirEDMN.getParent(), "EDMN.xml.zip");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fout);
            CheckedOutputStream checksum = new CheckedOutputStream(fos, new Adler32());
            try {
                BufferedOutputStream bos = new BufferedOutputStream(checksum, 8192);
                try {
                    ZipOutputStream zos = new ZipOutputStream(bos);
                    try {
                        try {
                            zos.setMethod(8);
                            zos.setLevel(9);
                        }
                        catch (Exception ignor) {
                            // empty catch block
                        }
                        EdmnImporteurWorker.zipDir(this.dirEDMN.getAbsolutePath(), null, zos);
                    }
                    finally {
                        zos.close();
                    }
                }
                finally {
                    bos.close();
                }
            }
            finally {
                checksum.close();
            }
        }
        finally {
            fos.close();
        }
        return fout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipDir(String basedir, String currentdir, ZipOutputStream zos) throws FileNotFoundException, IOException {
        ZipEntry anEntry;
        String currentdir2;
        File zipDir = currentdir != null ? new File(basedir, currentdir) : new File(basedir);
        String[] dirList = zipDir.list();
        byte[] readBuffer = new byte[8192];
        int bytesIn = 0;
        String string = currentdir2 = currentdir != null ? currentdir + "/" : "";
        if (currentdir2.length() > 0) {
            anEntry = new ZipEntry(currentdir2);
            zos.putNextEntry(anEntry);
            zos.closeEntry();
        }
        for (int i = 0; i < dirList.length; ++i) {
            File f = new File(zipDir, dirList[i]);
            if (!f.exists()) continue;
            if (f.isDirectory()) {
                EdmnImporteurWorker.zipDir(basedir, currentdir2 + dirList[i], zos);
                continue;
            }
            FileInputStream fis = new FileInputStream(f);
            try {
                BufferedInputStream bis = new BufferedInputStream(fis, 8192);
                try {
                    anEntry = new ZipEntry(currentdir2 + dirList[i]);
                    anEntry.setTime(f.lastModified());
                    zos.putNextEntry(anEntry);
                    while ((bytesIn = bis.read(readBuffer, 0, 8192)) != -1) {
                        zos.write(readBuffer, 0, bytesIn);
                    }
                    zos.closeEntry();
                    continue;
                }
                finally {
                    bis.close();
                }
            }
            finally {
                fis.close();
            }
        }
    }

    public static String escape(String s) {
        StringBuffer sb = new StringBuffer();
        block7: for (char c : s.trim().toCharArray()) {
            switch (c) {
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

